/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.util.Locale;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.timeseries.regression.ISystemVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class GenericTradingDaysVariable
implements ITradingDaysVariable,
ISystemVariable {
    private final DayClustering clustering;
    static final String[] TD2 = new String[]{"week", "week-end"};
    static final String[] TD2c = new String[]{"mon-sat", "sun"};
    static final String[] TD2d = new String[]{"mon-thu", "fri-sat-sun"};
    static final String[] TD7 = new String[]{"mon", "tue", "wed", "thu", "fri", "sat", "sun"};
    static final String[] TD3 = new String[]{"week", "sat", "sun"};
    static final String[] TD3c = new String[]{"mon-thu", "fri-sat", "sun"};
    static final String[] TD4 = new String[]{"mon-thu", "fri", "sat", "sun"};
    static final String[] TD4c = new String[]{"mon", "tue-fri", "sat", "sun"};
    static final String[] TD6 = new String[]{"mon", "tue", "wed", "thu", "fri", "week-end"};

    public GenericTradingDaysVariable(GenericTradingDays td) {
        this.clustering = td.getClustering();
    }

    @Override
    public int dim() {
        return this.clustering.getGroupsCount() - 1;
    }

    @Override
    public TradingDaysType getTradingDaysType() {
        return this.clustering.getType();
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        return GenericTradingDaysVariable.nameOf(this.clustering);
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(int idx, D context) {
        return GenericTradingDaysVariable.description(this.clustering, idx);
    }

    public static String description(DayClustering dc, int idx) {
        if (dc.equals(DayClustering.TD2)) {
            return TD2[idx];
        }
        if (dc.equals(DayClustering.TD7)) {
            return TD7[idx];
        }
        if (dc.equals(DayClustering.TD3)) {
            return TD3[idx];
        }
        if (dc.equals(DayClustering.TD2c)) {
            return TD2c[idx];
        }
        if (dc.equals(DayClustering.TD2d)) {
            return TD2d[idx];
        }
        if (dc.equals(DayClustering.TD3c)) {
            return TD3c[idx];
        }
        if (dc.equals(DayClustering.TD4)) {
            return TD4[idx];
        }
        if (dc.equals(DayClustering.TD4c)) {
            return TD4c[idx];
        }
        if (dc.equals(DayClustering.TD6)) {
            return TD6[idx];
        }
        return "td-" + (idx + 1);
    }

    public static String nameOf(DayClustering dc) {
        TradingDaysType type = dc.getType();
        if (type != null) {
            return type.name().toLowerCase(Locale.ROOT);
        }
        return "td";
    }

    @Generated
    public DayClustering getClustering() {
        return this.clustering;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericTradingDaysVariable)) {
            return false;
        }
        GenericTradingDaysVariable other = (GenericTradingDaysVariable)o;
        DayClustering this$clustering = this.getClustering();
        DayClustering other$clustering = other.getClustering();
        return !(this$clustering == null ? other$clustering != null : !((Object)this$clustering).equals(other$clustering));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DayClustering $clustering = this.getClustering();
        result = result * 59 + ($clustering == null ? 43 : ((Object)$clustering).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "GenericTradingDaysVariable(clustering=" + String.valueOf(this.getClustering()) + ")";
    }

    @Generated
    public GenericTradingDaysVariable(DayClustering clustering) {
        this.clustering = clustering;
    }
}

