/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;

public class PeriodicOutlierFactory
implements IOutlierFactory {
    private final boolean zeroEnded;
    private final int period;

    public PeriodicOutlierFactory(int period, boolean zeroEnded) {
        this.zeroEnded = zeroEnded;
        this.period = period;
    }

    public PeriodicOutlier make(LocalDateTime position) {
        return new PeriodicOutlier(position, this.period, this.zeroEnded);
    }

    @Override
    public void fill(int xpos, DataBlock buffer) {
        double z = -1.0 / (double)(this.period - 1);
        int len = buffer.length();
        if (this.zeroEnded) {
            int j = 1;
            while (true) {
                if (j < this.period && xpos > 0) {
                    if (--xpos < len) {
                        buffer.set(xpos, z);
                    }
                    ++j;
                    continue;
                }
                if (xpos > 0) {
                    if (--xpos < len) {
                        buffer.set(xpos, 1.0);
                    }
                    j = 1;
                    continue;
                }
                break;
            }
        } else {
            int i = xpos;
            while (i < len) {
                if (i >= 0) {
                    buffer.set(i, 1.0);
                }
                ++i;
                for (int j = 1; j < this.period && i < len; ++i, ++j) {
                    if (i < 0) continue;
                    buffer.set(i, z);
                }
            }
        }
    }

    @Override
    public IOutlierFactory.FilterRepresentation getFilterRepresentation() {
        return new IOutlierFactory.FilterRepresentation(new RationalBackFilter(BackFilter.ONE, new BackFilter(UnitRoots.D(this.period)), 0), 0.0);
    }

    @Override
    public int excludingZoneAtStart() {
        return 2 * this.period;
    }

    @Override
    public int excludingZoneAtEnd() {
        return 2 * this.period;
    }

    @Override
    public String getCode() {
        return "SO";
    }
}

