/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima;

import java.util.function.Function;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaMapping;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaEstimation;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaProcessor;
import jdplus.toolkit.base.core.regsarima.internal.HannanRissanenInitializer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaFixedMapping;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping2;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LogLikelihoodFunction;

public class RegSarimaComputer
implements IRegArimaComputer<SarimaModel> {
    public static final RegSarimaComputer PROCESSOR = new Builder().precision(1.0E-9).startingPoint(StartingPoint.Multiple).build();
    public static final double DEF_EPS = 1.0E-7;
    public static final double DEF_INTERNAL_EPS = 1.0E-4;
    private final double eps;
    private final double feps;
    private final boolean ml;
    private final boolean mt;
    private final boolean cdf;
    private final boolean fast;
    private final StartingPoint start;
    private final SsqFunctionMinimizer.Builder min;
    private static final double UR_LIMIT = 0.1;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isMaximumLikelihood() {
        return this.ml;
    }

    public StartingPoint getStartingPoint() {
        return this.start;
    }

    public RegSarimaComputer(SsqFunctionMinimizer.Builder min, double eps, double feps, boolean ml, StartingPoint start, boolean cdf, boolean mt, boolean fast) {
        this.min = min;
        this.eps = eps;
        this.feps = feps;
        this.ml = ml;
        this.mt = mt;
        this.cdf = cdf;
        this.start = start;
        this.fast = fast;
    }

    @Override
    public RegArimaEstimation<SarimaModel> process(RegArimaModel<SarimaModel> regs, IArimaMapping<SarimaModel> mapping) {
        SarimaModel mstart;
        SarimaOrders curSpec;
        SarimaModel current = regs.arima();
        if (mapping == null) {
            mapping = SarimaMapping2.of(current.orders());
        }
        if ((curSpec = current.orders()).getParametersCount() == 0 || mapping != null && mapping.getDim() == 0) {
            return RegArimaEstimation.builder().model(regs).concentratedLikelihood(ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(regs)).build();
        }
        switch (this.start.ordinal()) {
            case 2: 
            case 3: {
                RegArimaEstimation<SarimaModel> mdef;
                HannanRissanenInitializer initializer = HannanRissanenInitializer.builder().stabilize(true).useDefaultIfFailed(true).build();
                RegArmaModel<SarimaModel> dregs = regs.differencedModel();
                SarimaModel starthr = initializer.initialize(dregs);
                SarimaOrders spec = starthr.orders();
                mstart = starthr;
                if (this.start != StartingPoint.Multiple) break;
                RegArimaEstimation<SarimaModel> mhr = this.estimate(regs, mapping, starthr, this.feps);
                SarimaModel startdef = mhr.getModel().arima();
                if (spec.getP() > 0 && spec.getQ() > 0) {
                    int i;
                    SarimaModel.Builder nstart = startdef.toBuilder();
                    double p = startdef.theta(1) < 0.0 ? 0.9 : -0.9;
                    nstart.theta(1, p);
                    for (i = 1; i <= spec.getP(); ++i) {
                        nstart.phi(i, 0.0);
                    }
                    for (i = 2; i <= spec.getQ(); ++i) {
                        nstart.theta(i, 0.0);
                    }
                    startdef = nstart.adjustOrders(false).build();
                }
                if ((mdef = this.estimate(regs, mapping, startdef, this.feps)) == null) break;
                if (mhr.getConcentratedLikelihood().logLikelihood() < mdef.getConcentratedLikelihood().logLikelihood()) {
                    mstart = mdef.getModel().arima().stationaryTransformation().getStationaryModel();
                    break;
                }
                mstart = mhr.getModel().arima().stationaryTransformation().getStationaryModel();
                break;
            }
            case 1: {
                mstart = SarimaModel.builder(regs.arima().orders().doStationary()).setDefault().build();
                break;
            }
            default: {
                mstart = SarimaModel.builder(regs.arima().orders().doStationary()).setDefault(0.0, 0.0).build();
            }
        }
        return this.estimate(regs, mapping, mstart, this.eps);
    }

    @Override
    public RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs, IArimaMapping<SarimaModel> mapping) {
        SarimaModel arima = regs.arima();
        if (mapping == null) {
            mapping = SarimaMapping2.of(arima.orders());
        }
        return this.estimate(regs, mapping, arima.stationaryTransformation().getStationaryModel(), this.eps);
    }

    private RegArimaEstimation<SarimaModel> estimate(RegArimaModel<SarimaModel> regs, IArimaMapping<SarimaModel> mapping, SarimaModel start, double precision) {
        SarimaOrders curSpec = regs.arima().orders();
        if (curSpec.getParametersCount() == 0 || mapping.getDim() == 0) {
            return RegArimaEstimation.builder().model(regs).concentratedLikelihood(ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(regs)).build();
        }
        return this.optimize(regs, mapping, start, precision, true);
    }

    private RegArimaEstimation<SarimaModel> finalProcessing(RegArimaEstimation<SarimaModel> estimation, IArimaMapping<SarimaModel> mapping) {
        RegArimaEstimation<SarimaModel> nestimation = this.tryUrpCancelling(estimation, mapping);
        RegArimaEstimation<SarimaModel> festimation = this.tryUrmCancelling(nestimation, mapping);
        return festimation;
    }

    private RegArimaEstimation<SarimaModel> tryUrpCancelling(RegArimaEstimation<SarimaModel> estimation, IArimaMapping<SarimaModel> mapping) {
        double c;
        int i;
        SarimaModel arima = estimation.getModel().arima();
        SarimaOrders spec = arima.orders();
        if (spec.getP() == 0 || spec.getQ() == 0 || spec.getDifferenceOrder() == 0) {
            return estimation;
        }
        DataBlock parameters = DataBlock.of(arima.parameters());
        int pstart = 0;
        int pend = spec.getP();
        double p = 0.0;
        for (int i2 = pstart; i2 < pend; ++i2) {
            p += parameters.get(i2);
        }
        if (Math.abs(p + 1.0) > 0.1) {
            return estimation;
        }
        int qstart = pend + spec.getBp();
        int qend = qstart + spec.getQ();
        double q = 0.0;
        for (int i3 = qstart; i3 < qend; ++i3) {
            q += parameters.get(i3);
        }
        if (Math.abs(q + 1.0) > 0.1) {
            return estimation;
        }
        double tmp = 0.0;
        for (i = pend - 1; i >= pstart; --i) {
            c = parameters.get(i);
            parameters.set(i, -tmp);
            tmp += c;
        }
        tmp = 0.0;
        for (i = qend - 1; i >= qstart; --i) {
            c = parameters.get(i);
            parameters.set(i, -tmp);
            tmp += c;
        }
        try {
            SarimaModel narima = SarimaModel.builder(SarimaOrders.stationary((SarimaOrders)spec)).parameters((DoubleSeq)parameters).build();
            RegArimaEstimation<SarimaModel> nrslts = this.optimize(estimation.getModel(), mapping, narima, this.eps, false);
            if (nrslts.getConcentratedLikelihood().logLikelihood() > estimation.getConcentratedLikelihood().logLikelihood()) {
                return nrslts;
            }
            return estimation;
        }
        catch (Exception err) {
            return estimation;
        }
    }

    private RegArimaEstimation<SarimaModel> tryUrmCancelling(RegArimaEstimation<SarimaModel> estimation, IArimaMapping<SarimaModel> mapping) {
        double c;
        int i;
        SarimaModel arima = estimation.getModel().arima();
        SarimaOrders spec = arima.orders();
        if (spec.getP() == 0 || spec.getQ() == 0 || spec.getBd() == 0) {
            return estimation;
        }
        DataBlock parameters = DataBlock.of(arima.parameters());
        int pstart = 0;
        int pend = spec.getP();
        double p = 0.0;
        boolean pos = false;
        for (int i2 = pstart; i2 < pend; ++i2) {
            p += pos ? parameters.get(i2) : -parameters.get(i2);
            pos = !pos;
        }
        if (Math.abs(p + 1.0) > 0.1) {
            return estimation;
        }
        int qstart = pend + spec.getBp();
        int qend = qstart + spec.getQ();
        double q = 0.0;
        pos = false;
        for (int i3 = qstart; i3 < qend; ++i3) {
            q += pos ? parameters.get(i3) : -parameters.get(i3);
            pos = !pos;
        }
        if (Math.abs(q + 1.0) > 0.1) {
            return estimation;
        }
        double tmp = 0.0;
        for (i = pend - 1; i >= pstart; --i) {
            c = parameters.get(i);
            parameters.set(i, tmp);
            tmp = c - tmp;
        }
        tmp = 0.0;
        for (i = qend - 1; i >= qstart; --i) {
            c = parameters.get(i);
            parameters.set(i, tmp);
            tmp = c - tmp;
        }
        try {
            SarimaModel narima = SarimaModel.builder(SarimaOrders.stationary((SarimaOrders)spec)).parameters((DoubleSeq)parameters).build();
            RegArimaEstimation<SarimaModel> nrslts = this.optimize(estimation.getModel(), mapping, narima, this.eps, false);
            if (nrslts.getConcentratedLikelihood().logLikelihood() > estimation.getConcentratedLikelihood().logLikelihood()) {
                return nrslts;
            }
            return estimation;
        }
        catch (Exception err) {
            return estimation;
        }
    }

    private RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs, IArimaMapping<SarimaModel> mapping, SarimaModel ststart, double precision, boolean finalProcessing) {
        Object r;
        RegArmaModel<SarimaModel> dmodel = regs.differencedModel();
        RegArmaProcessor processor = new RegArmaProcessor(this.ml, this.mt, this.fast);
        IArimaMapping<SarimaModel> stationaryMapping = mapping.stationaryMapping();
        DataBlock p = DataBlock.of(stationaryMapping.parametersOf(ststart));
        stationaryMapping.validate(p);
        int ndf = dmodel.getY().length() - dmodel.getX().getColumnsCount();
        if (this.cdf) {
            ndf -= stationaryMapping.getDim();
        }
        RegArmaEstimation<SarimaModel> rslt = processor.compute(dmodel, (DoubleSeq)p, stationaryMapping, this.min.functionPrecision(precision).build(), ndf);
        boolean fm = stationaryMapping instanceof SarimaFixedMapping;
        if (fm) {
            SarimaFixedMapping sfm = (SarimaFixedMapping)stationaryMapping;
            r = sfm.fullParameters(rslt.getParameters());
        } else {
            r = rslt.getParameters();
        }
        SarimaModel arima = SarimaModel.builder(regs.arima().orders()).parameters((DoubleSeq)r).build();
        RegArimaModel nmodel = RegArimaModel.of(regs, arima);
        RegArimaEstimation<SarimaModel> finalRslt = RegArimaEstimation.builder().model(nmodel).concentratedLikelihood(ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(nmodel)).max(new LogLikelihoodFunction.Point(this.llFunction(regs, mapping), rslt.getParameters(), rslt.getScore(), rslt.getInformation())).build();
        return finalProcessing ? this.finalProcessing(finalRslt, mapping) : finalRslt;
    }

    public LogLikelihoodFunction<RegArimaModel<SarimaModel>, ConcentratedLikelihoodWithMissing> llFunction(RegArimaModel<SarimaModel> regs, IArimaMapping<SarimaModel> mapping) {
        RegArimaMapping<SarimaModel> rmapping = new RegArimaMapping<SarimaModel>(mapping, regs);
        Function<RegArimaModel, ConcentratedLikelihoodWithMissing> fn = model -> ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(model);
        return new LogLikelihoodFunction<RegArimaModel<SarimaModel>, ConcentratedLikelihoodWithMissing>(rmapping, fn);
    }

    public static class Builder {
        private double eps = 1.0E-7;
        private double feps = 1.0E-4;
        private boolean ml = true;
        private boolean mt = false;
        private boolean cdf = true;
        private boolean fast = true;
        private StartingPoint start = StartingPoint.HannanRissanen;
        private SsqFunctionMinimizer.Builder min;

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder preliminaryEpsilon(double eps) {
            this.feps = eps;
            return this;
        }

        public Builder useParallelProcessing(boolean mt) {
            this.mt = mt;
            return this;
        }

        public Builder computeExactFinalDerivatives(boolean exact) {
            this.fast = !exact;
            return this;
        }

        public Builder useMaximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public Builder useCorrectedDegreesOfFreedom(boolean cdf) {
            this.cdf = cdf;
            return this;
        }

        public Builder startingPoint(StartingPoint start) {
            this.start = start;
            return this;
        }

        public Builder minimizer(SsqFunctionMinimizer.Builder min) {
            this.min = min;
            return this;
        }

        public RegSarimaComputer build() {
            return new RegSarimaComputer(this.min == null ? LevenbergMarquardtMinimizer.builder() : this.min, this.eps, this.feps, this.ml, this.start, this.cdf, this.mt, this.fast);
        }
    }

    public static enum StartingPoint {
        Zero,
        Default,
        HannanRissanen,
        Multiple;

    }
}

