/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.dk.DiffuseState;
import jdplus.toolkit.base.core.ssf.dk.DiffuseUpdateInformation;
import jdplus.toolkit.base.core.ssf.dk.IDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.sqrt.IDiffuseSquareRootFilteringResults;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.ssf.univariate.PredictionErrorDecomposition;
import jdplus.toolkit.base.core.stats.likelihood.DeterminantalTerm;

public class DiffusePredictionErrorDecomposition
extends PredictionErrorDecomposition
implements IDiffuseFilteringResults,
IDiffuseSquareRootFilteringResults {
    private final DeterminantalTerm ddet = new DeterminantalTerm();
    private int nd;
    private int enddiffuse;

    public DiffusePredictionErrorDecomposition(boolean res) {
        super(res);
    }

    @Override
    public DiffuseLikelihood likelihood(boolean scalingfactor) {
        return DiffuseLikelihood.builder(this.nd + this.cumulator.getObsCount(), this.nd).concentratedScalingFactor(scalingfactor).ssqErr(this.cumulator.getSsqErr()).logDeterminant(this.cumulator.getLogDeterminant()).diffuseCorrection(this.ddet.getLogDeterminant()).residuals((DoubleSeq)(this.bres ? this.res : null)).build();
    }

    @Override
    public void close(int pos) {
        this.enddiffuse = pos;
    }

    @Override
    public void clear() {
        super.clear();
        this.ddet.clear();
        this.nd = 0;
        this.enddiffuse = 0;
    }

    @Override
    public void save(int t, DiffuseUpdateInformation pe) {
        double d = pe.getDiffuseVariance();
        if (d != 0.0) {
            if (pe.getStatus() == UpdateInformation.Status.OBSERVATION) {
                ++this.nd;
                this.ddet.add(d);
            }
        } else {
            double e = pe.get();
            if (pe.getStatus() == UpdateInformation.Status.OBSERVATION) {
                this.cumulator.add(e, pe.getVariance());
            }
            if (this.bres) {
                double sd = pe.getStandardDeviation();
                if (e == 0.0) {
                    this.res.set(t, 0.0);
                } else if (sd == 0.0) {
                    this.res.set(t, Double.NaN);
                } else {
                    this.res.set(t, e / sd);
                }
            }
        }
    }

    @Override
    public void save(int pos, DiffuseState state, StateInfo info) {
    }

    @Override
    public void save(int pos, AugmentedState state, StateInfo info) {
    }

    @Override
    public int getEndDiffusePosition() {
        return this.enddiffuse;
    }
}

