/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class VarLocalLevel {
    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    public static StateComponent of(double[] std, double scale) {
        return new StateComponent(new Initialization(std, scale, Double.NaN), new Dynamics(std, scale));
    }

    public static StateComponent of(double[] std, double scale, double initialValue) {
        return new StateComponent(new Initialization(std, scale, initialValue), new Dynamics(std, scale));
    }

    @Generated
    private VarLocalLevel() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Initialization
    implements ISsfInitialization {
        final double scale;
        final double[] std;
        final double initialValue;

        Initialization(double[] std, double scale, double initialValue) {
            this.std = std;
            this.scale = scale;
            this.initialValue = initialValue;
        }

        @Override
        public int getStateDim() {
            return 1;
        }

        @Override
        public boolean isDiffuse() {
            return Double.isNaN(this.initialValue);
        }

        @Override
        public int getDiffuseDim() {
            return Double.isNaN(this.initialValue) ? 1 : 0;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            if (Double.isNaN(this.initialValue)) {
                b.set(0, 0, 1.0);
            }
        }

        @Override
        public void a0(DataBlock a0) {
            if (Double.isFinite(this.initialValue)) {
                a0.set(0, this.initialValue);
            }
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            if (Double.isFinite(this.initialValue)) {
                pf0.set(0, 0, this.scale * this.scale);
            }
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            if (Double.isNaN(this.initialValue)) {
                pi0.set(0, 0, 1.0);
            }
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final double scale;
        private final double scale2;
        private final double[] std;

        Dynamics(double[] std, double scale) {
            this.std = std;
            this.scale = scale;
            this.scale2 = scale * scale;
        }

        double var(int pos) {
            if (pos < this.std.length) {
                double q = this.std[pos] * this.scale;
                return q * q;
            }
            return this.scale2;
        }

        double std(int pos) {
            return pos < this.std.length ? this.std[pos] * this.scale : this.scale;
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return false;
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.set(0, 0, this.var(pos));
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public void S(int pos, FastMatrix sm) {
            sm.set(0, 0, this.std(pos));
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.add(0, this.std(pos) * u.get(0));
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.set(0, this.std(pos) * x.get(0));
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.set(0, 0, 1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
        }

        @Override
        public void TVT(int pos, FastMatrix v) {
        }

        @Override
        public void XT(int pos, DataBlock x) {
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(0, 0, this.var(pos));
        }
    }
}

