/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.stats.samples.Moments;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class JarqueBera {
    private int k;
    private boolean corrected;
    private double skewness;
    private double kurtosis;
    private final DoubleSeq x;

    public JarqueBera(DoubleSeq data) {
        this.x = data;
    }

    public JarqueBera degreeOfFreedomCorrection(int k) {
        this.k = k;
        return this;
    }

    public JarqueBera correctionForSample(boolean scorr) {
        this.corrected = scorr;
        return this;
    }

    public StatisticalTest build() {
        double n = this.x.length();
        if (n < 4.0) {
            throw new StatException("Invalid test: not enough observations");
        }
        double m = Moments.mean(this.x);
        double v = Moments.variance(this.x, m, this.corrected);
        this.skewness = Moments.skewness(this.x, m, v, this.corrected);
        this.kurtosis = Moments.excessKurtosis(this.x, m, v, this.corrected);
        double val = (n - (double)this.k) * (this.skewness * this.skewness / 6.0 + this.kurtosis * this.kurtosis / 24.0);
        Chi2 chi = new Chi2(2.0);
        return TestsUtility.testOf(val, chi, TestType.Upper);
    }

    public double getSkewness() {
        return this.skewness;
    }

    public double getKurtosis() {
        return this.kurtosis;
    }
}

