/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evomodel.branchratemodel.RateEpochBranchRateModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class ContinuousEpochBranchRateModel
extends RateEpochBranchRateModel {
    private Parameter rootHeight;
    private double normalization;
    private double savedNormalization;
    private boolean normalizationKnown;

    public ContinuousEpochBranchRateModel(Parameter[] parameterArray, Parameter[] parameterArray2, Parameter parameter) {
        super(parameterArray, parameterArray2);
        this.rootHeight = parameter;
        this.addVariable(parameter);
        this.normalizationKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        this.normalizationKnown = false;
    }

    private void normalize() {
        int n;
        this.normalization = 0.0;
        double d = 0.0;
        double d2 = this.rootHeight.getParameterValue(0);
        for (n = 0; n < this.timeParameters.length && d2 > this.timeParameters[n].getParameterValue(0); ++n) {
            double d3 = this.timeParameters[n].getParameterValue(0);
            this.normalization += (d3 - d) * this.rateParameters[n].getParameterValue(0);
            d = d3;
        }
        this.normalization += (d2 - d) * this.rateParameters[n].getParameterValue(0);
    }

    @Override
    protected void storeState() {
        this.savedNormalization = this.normalization;
    }

    @Override
    protected void restoreState() {
        this.normalization = this.savedNormalization;
    }

    @Override
    protected double normalizeRate(double d) {
        if (!this.normalizationKnown) {
            this.normalize();
        }
        return d / this.normalization;
    }
}

