/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.ContinuousBranchValueProvider;
import dr.evomodel.branchratemodel.CountableMixtureBranchRates;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class IntegratedTimeDependentModel
extends AbstractModel
implements ContinuousBranchValueProvider,
CountableMixtureBranchRates.TimeDependentModel {
    private final TreeModel treeModel;
    private final ParameterPack pack;
    private HashMap<BranchLength, Double> integratedValues;
    private HashMap<BranchLength, Double> savedIntegratedValues;

    public IntegratedTimeDependentModel(TreeModel treeModel, ParameterPack parameterPack) {
        super("integratedBranchValues");
        this.treeModel = treeModel;
        this.pack = parameterPack;
        this.addModel(treeModel);
        for (Parameter parameter : parameterPack) {
            this.addVariable(parameter);
        }
    }

    private double computeIntegratedValue(double d, double d2) {
        return d - d2;
    }

    @Override
    public double getBranchValue(Tree tree, NodeRef nodeRef) {
        double d = tree.getNodeHeight(tree.getParent(nodeRef));
        double d2 = tree.getNodeHeight(nodeRef);
        BranchLength branchLength2 = new BranchLength(d, d2);
        return this.integratedValues.computeIfAbsent(branchLength2, branchLength -> this.computeIntegratedValue(d, d2));
    }

    @Override
    public double getMidpointValue(Tree tree, NodeRef nodeRef, boolean bl) {
        double d = this.getBranchValue(tree, nodeRef);
        if (bl) {
            return Math.log(d);
        }
        return d;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model != this.treeModel) {
            throw new IllegalArgumentException("Unknown model");
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (!this.pack.contains(variable)) {
            throw new IllegalArgumentException("Unknown variable");
        }
        this.integratedValues.clear();
    }

    @Override
    protected void storeState() {
        this.savedIntegratedValues.clear();
        this.savedIntegratedValues.putAll(this.integratedValues);
    }

    @Override
    protected void restoreState() {
        HashMap<BranchLength, Double> hashMap = this.integratedValues;
        this.integratedValues = this.savedIntegratedValues;
        this.savedIntegratedValues = hashMap;
    }

    @Override
    protected void acceptState() {
    }

    public static class ParameterPack
    implements Iterable<Parameter> {
        final Parameter historicValue;
        final Parameter currentValue;
        final Parameter midTime;
        final Parameter slope;
        final List<Parameter> parameterList = new ArrayList<Parameter>();

        public ParameterPack(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
            this.historicValue = parameter;
            this.currentValue = parameter2;
            this.midTime = parameter3;
            this.slope = parameter4;
            this.parameterList.add(parameter);
            this.parameterList.add(parameter2);
            this.parameterList.add(parameter3);
            this.parameterList.add(parameter4);
        }

        public boolean contains(Variable variable) {
            return this.parameterList.contains((Parameter)variable);
        }

        @Override
        public Iterator<Parameter> iterator() {
            return this.parameterList.iterator();
        }
    }

    static class BranchLength {
        final double parent;
        final double child;

        BranchLength(double d, double d2) {
            this.parent = d;
            this.child = d2;
        }
    }
}

