/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.shrinkage;

import dr.inference.distribution.ExponentialTiltedStableDistribution;
import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.GammaDistribution;

public class BayesianBridgeShrinkageOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private final BayesianBridgeStatisticsProvider provider;
    private final Parameter globalScale;
    private final Parameter localScale;
    private final Parameter regressionExponent;
    private final Parameter mask;
    private final int dim;
    private final int effectiveDim;
    private final GammaDistribution globalScalePrior;

    public BayesianBridgeShrinkageOperator(BayesianBridgeStatisticsProvider bayesianBridgeStatisticsProvider, GammaDistribution gammaDistribution, Parameter parameter, double d) {
        this.setWeight(d);
        this.provider = bayesianBridgeStatisticsProvider;
        this.globalScale = bayesianBridgeStatisticsProvider.getGlobalScale();
        this.localScale = bayesianBridgeStatisticsProvider.getLocalScale();
        this.regressionExponent = bayesianBridgeStatisticsProvider.getExponent();
        this.mask = parameter;
        this.dim = bayesianBridgeStatisticsProvider.getDimension();
        this.effectiveDim = this.getEffectiveDim();
        this.globalScalePrior = gammaDistribution;
    }

    private int getEffectiveDim() {
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            if (!this.random(i)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public String getOperatorName() {
        return "bayesianBridgeGibbsOperator";
    }

    @Override
    public double doOperation() {
        if (this.globalScalePrior != null) {
            this.sampleGlobalScale();
        }
        if (this.localScale != null) {
            this.sampleLocalScale();
        }
        return 0.0;
    }

    public double drawGlobalScale(double d, double d2, double d3, double d4, double d5) {
        double d6 = d4 / d3;
        double d7 = d5;
        if (d > 0.0) {
            d6 += d;
            d7 += 1.0 / d2;
        }
        double d8 = GammaDistribution.nextGamma(d6, 1.0 / d7);
        double d9 = Math.pow(d8, -1.0 / d3);
        return d9;
    }

    public void sampleGlobalScale() {
        double d = this.drawGlobalScale(this.globalScalePrior.getShape(), this.globalScalePrior.getScale(), this.regressionExponent.getParameterValue(0), this.effectiveDim, this.absSumBeta());
        this.globalScale.setParameterValue(0, d);
    }

    private boolean random(int n) {
        return this.mask == null || this.mask.getParameterValue(n) == 1.0;
    }

    private double absSumBeta() {
        double d = this.regressionExponent.getParameterValue(0);
        double d2 = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            if (!this.random(i)) continue;
            d2 += Math.pow(Math.abs(this.provider.getCoefficient(i)), d);
        }
        return d2;
    }

    public double drawSingleLocalScale(double d, double d2, double d3) {
        double d4 = ExponentialTiltedStableDistribution.nextTiltedStable(d2 / 2.0, Math.pow(d3 / d, 2.0));
        d4 = Math.sqrt(1.0 / (2.0 * d4));
        return d4;
    }

    private void sampleLocalScale() {
        double d = this.regressionExponent.getParameterValue(0);
        double d2 = this.globalScale.getParameterValue(0);
        for (int i = 0; i < this.dim; ++i) {
            if (!this.random(i)) continue;
            double d3 = this.drawSingleLocalScale(d2, d, this.provider.getCoefficient(i));
            this.localScale.setParameterValueQuietly(i, d3);
        }
        this.localScale.fireParameterChangedEvent();
    }
}

