
# **Changelog**

## **Version 0.2.1**

**Maintainer:** Heyang Ji  

**Previous Version:** 0.2.0  

### **Bug Fix**

- Fixed an issue in the `ME.fcQR_CLS` function where the `data.Z` argument did not support data frames containing non-numeric variables.

### **Visualization**

- Enhanced the `plot` function for basis function series, providing more options and greater flexibility for visualization.

### **Documentation**

- Improved the clarity of the documentation.


## **Version 0.2.0**  

**Maintainer:** Heyang Ji  

**Previous Version:** 0.1.0  

### **New Features**  
- Added classes and functions required for basis expansion using **Functional Principal Component (FPC)** basis, including:  
  - **S4 classes**: `numeric_basis`, `numericBasis_series`.  
  - **S4 class methods**: `plot.numeric_series`.  
  - **Functions**: `FPC_basis_expansion()`, `numeric_basis_expansion()`, `numericBasisSeries2fun()`.  

### **Enhancements & Compatibility Improvements**  
- Enhanced existing functions to support the newly introduced FPC basis expansion:  
  - Added an option to use the FPC basis in **scalar-on-function regression functions**, `fcRegression` and `fcQR`.  
  - Updated **s3 methods** `predict.fcRegression` and `predict.fcQR` to support FPC basis.  
  - Extended the **generic function** `basis2fun` with new methods.  

### **New Utility Functions**  
- Introduced two functions for generating synthetic test datasets:  
  - `MECfda_simDataGen_fcReg`  
  - `MECfda_simDataGen_ME`  

### **Bug Fixes**  
- Fixed an issue in `bspline_basis_expansion` and `fourier_basis_expansion` where the numerical integration step did not properly handle **non-default integration intervals**.  

### **Other Improvements**  
- Added the function `MEM_X_hat()`, which returns $\hat X(t)$ used in `ME.fcRegression_MEM`.  
- Removed the package dependency on **stringr**.  
- Updated and refined the **help documentation** and **vignette** content.  
- Corrected **author roles** in the author list.  
