/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.EigenRoutines;
import jdplus.toolkit.base.core.math.matrices.decomposition.EigenSystem;
import jdplus.toolkit.base.core.math.matrices.decomposition.IEigenSystem;

class GeneralEigenSystem
implements IEigenSystem {
    private FastMatrix m_std;
    private Complex[] m_ev;
    private double m_zero = 1.0E-6;
    private int m_maxiter = 120;
    private boolean m_bCalc = false;
    private boolean m_bVec = false;

    public GeneralEigenSystem(FastMatrix im) {
        this.m_std = im.deepClone();
    }

    @Override
    public void compute() {
        this.m_bCalc = false;
        this.calc();
    }

    @Override
    public Complex[] getEigenValues() {
        this.calc();
        int n = this.m_std.getRowsCount();
        Complex[] rout = new Complex[n];
        System.arraycopy(this.m_ev, 0, rout, 0, rout.length);
        return rout;
    }

    @Override
    public Complex[] getEigenValues(int m) {
        this.calc();
        int n = this.m_std.getRowsCount();
        int mel = Math.min(n, m);
        Complex[] rout = new Complex[mel];
        System.arraycopy(this.m_ev, 0, rout, 0, mel);
        return rout;
    }

    @Override
    public double getZero() {
        return this.m_zero;
    }

    @Override
    public void setZero(double value) {
        this.m_zero = value;
    }

    public int getMaxIter() {
        return this.m_maxiter;
    }

    public void setMaxIter(int value) {
        this.m_maxiter = value;
    }

    @Override
    public boolean isComputingEigenVectors() {
        return this.m_bVec;
    }

    @Override
    public void setComputingEigenVectors(boolean value) {
        this.m_bVec = value;
    }

    @Override
    public double[] getEigenVector(int idx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FastMatrix getEigenVectors() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FastMatrix getEigenVectors(int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void calc() {
        if (this.m_bCalc) {
            return;
        }
        EigenRoutines.setMaxIter(this.m_maxiter);
        double[] data = EigenSystem.convertToArray(this.m_std);
        EigenRoutines.balance(data, this.m_std.getRowsCount());
        if (!this.isHessenberg()) {
            EigenRoutines.hessenberg(data, this.m_std.getRowsCount());
        }
        this.m_ev = EigenRoutines.hessenbergQR(data, this.m_std.getRowsCount());
        this.m_bCalc = true;
    }

    private boolean isHessenberg() {
        int n = this.m_std.getColumnsCount() - 2;
        for (int i = 0; i < n; ++i) {
            if (this.m_std.column(i).drop(i + 2, 0).isZero(0.0)) continue;
            return false;
        }
        return true;
    }
}

