/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.estimation;

import internal.toolkit.base.core.arima.KalmanFilter;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.eco.EcoException;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderWithPivoting;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;

public final class ConcentratedLikelihoodComputer {
    public static final double RCOND = 1.0E-12;
    private final ArmaFilter filter;
    private final double rcond;
    private final boolean xfixed;
    private final boolean fullResiduals;
    public static final ConcentratedLikelihoodComputer DEFAULT_COMPUTER = new ConcentratedLikelihoodComputer(null, 1.0E-12, true, false);
    public static final ConcentratedLikelihoodComputer DEFAULT_FULL_COMPUTER = new ConcentratedLikelihoodComputer(null, 1.0E-12, false, true);

    public static Builder builder() {
        return new Builder();
    }

    public ConcentratedLikelihoodComputer(ArmaFilter filter, double rcond, boolean xfixed, boolean fullResiduals) {
        this.filter = filter;
        this.rcond = rcond;
        this.xfixed = xfixed;
        this.fullResiduals = fullResiduals;
    }

    public <M extends IArimaModel> ConcentratedLikelihoodWithMissing compute(RegArimaModel<M> model) {
        return this.compute(model.differencedModel());
    }

    public <M extends IArimaModel> ConcentratedLikelihoodWithMissing compute(RegArmaModel<M> dmodel) {
        DoubleSeq dy = dmodel.getY();
        int n = dy.length();
        FastMatrix x = dmodel.getX();
        int nx = x.getColumnsCount();
        ArmaFilter curFilter = this.filter == null ? new KalmanFilter(nx > 0) : this.filter;
        int nl = curFilter.prepare((IArimaModel)dmodel.getArma(), n);
        try {
            return this.process(curFilter, dmodel.getY(), dmodel.getX(), nl, dmodel.getMissingCount());
        }
        catch (Exception ex) {
            throw new EcoException("Gls failed");
        }
    }

    private <M extends IArimaModel> ConcentratedLikelihoodWithMissing process(ArmaFilter curFilter, DoubleSeq dy, FastMatrix x, int nl, int nm) {
        DataBlock y = DataBlock.of(dy);
        int n = y.length();
        DataBlock yl = DataBlock.make(nl);
        curFilter.apply((DoubleSeq)y, yl);
        int nx = x.getColumnsCount();
        if (nx > 0) {
            DoubleSeq e;
            FastMatrix xl = FastMatrix.make(nl, nx);
            for (int i = 0; i < nx; ++i) {
                curFilter.apply((DoubleSeq)x.column(i), xl.column(i));
            }
            HouseholderWithPivoting hous = new HouseholderWithPivoting();
            QRDecomposition qr = hous.decompose(xl, this.xfixed ? nx : nm);
            QRLeastSquaresSolution ls = QRLeastSquaresSolver.leastSquares(qr, (DoubleSeq)yl, this.rcond);
            if (this.xfixed && ls.rank() != nx) {
                throw new EcoException("Gls failed");
            }
            if (ls.rank() == 0) {
                double ssqerr = yl.ssq();
                double ldet = curFilter.getLogDeterminant();
                ConcentratedLikelihoodWithMissing cll = ConcentratedLikelihoodWithMissing.builder().ndata(n).logDeterminant(ldet).ssqErr(ssqerr).residuals((DoubleSeq)yl).build();
                return cll;
            }
            double ssqerr = ls.getSsqErr();
            double ldet = curFilter.getLogDeterminant();
            if (nm > 0) {
                double corr = LogSign.of(qr.rawRdiagonal().extract(0, nm)).getValue();
                ldet += 2.0 * corr;
            }
            if (this.fullResiduals) {
                DoubleSeqCursor b = ls.getB().cursor();
                for (int i = 0; i < nx; ++i) {
                    yl.addAY(-b.getAndNext(), xl.column(i));
                }
                e = yl.unmodifiable();
            } else {
                e = ls.getE();
            }
            FastMatrix bvar = ls.unscaledCovariance();
            DoubleSeq b = ls.getB();
            ConcentratedLikelihoodWithMissing cll = ConcentratedLikelihoodWithMissing.builder().ndata(n).nmissing(nm).coefficients(b).unscaledCovariance(bvar).logDeterminant(ldet).ssqErr(ssqerr).residuals(e).build();
            DataBlock rel = yl.deepClone();
            DoubleSeqCursor cursor = b.cursor();
            for (int i = 0; i < nx; ++i) {
                rel.addAY(-cursor.getAndNext(), xl.column(i));
            }
            return cll;
        }
        double ssqerr = yl.ssq();
        double ldet = curFilter.getLogDeterminant();
        ConcentratedLikelihoodWithMissing cll = ConcentratedLikelihoodWithMissing.builder().ndata(n).ssqErr(ssqerr).logDeterminant(ldet).residuals((DoubleSeq)yl).build();
        return cll;
    }

    public static class Builder {
        private ArmaFilter filter;
        private double rcond = 1.0E-12;
        private boolean xfixed;
        private boolean fullResiduals = false;

        public Builder filter(ArmaFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder rankCondition(double rcond) {
            this.rcond = rcond;
            return this;
        }

        public Builder noPivoting(boolean xfixed) {
            this.xfixed = xfixed;
            return this;
        }

        public Builder fullResiduals(boolean full) {
            this.fullResiduals = full;
            return this;
        }

        public ConcentratedLikelihoodComputer build() {
            return new ConcentratedLikelihoodComputer(this.filter, this.rcond, this.xfixed, this.fullResiduals || !this.xfixed);
        }
    }
}

