/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.DataBlockResults;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.dk.DefaultDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;

public class FastDkSmoother {
    private final VarianceFilterProvider vf;
    private final ISsf ssf;
    private final ISsfLoading loading;
    private final ISsfDynamics dynamics;
    private final int enddiffuse;
    private final DataBlock state;
    private final DataBlockResults A = new DataBlockResults();
    private final DataBlock Rf;
    private final DataBlock Ri;
    private final DataBlock C;
    private final DataBlock Ci;

    public FastDkSmoother(ISsf ssf, DefaultDiffuseFilteringResults frslts) {
        this.vf = VarianceFilterProvider.of(frslts);
        this.ssf = ssf;
        this.loading = ssf.loading();
        this.dynamics = ssf.dynamics();
        this.enddiffuse = frslts.getEndDiffusePosition();
        int dim = ssf.getStateDim();
        this.state = DataBlock.make(dim);
        this.Rf = DataBlock.make(dim);
        this.C = DataBlock.make(dim);
        this.Ri = DataBlock.make(dim);
        this.Ci = DataBlock.make(dim);
        this.A.prepare(dim, 0, this.vf.size());
    }

    public void smooth(DoubleSeq x) {
        this.clear();
        DoubleSeq fx = this.forwardFilter(x);
        this.backwardFilter(fx);
    }

    public DataBlockResults smoothedStates() {
        return this.A;
    }

    private void clear() {
        this.state.set(0.0);
        this.Rf.set(0.0);
        this.Ri.set(0.0);
    }

    DoubleSeq forwardFilter(DoubleSeq x) {
        int n = this.vf.size();
        double[] fx = new double[n];
        this.ssf.initialization().a0(this.state);
        DoubleSeqCursor cursor = x.cursor();
        for (int pos = 0; pos < n; ++pos) {
            fx[pos] = this.iterateFilter(pos, cursor.getAndNext());
        }
        return DoubleSeq.of((double[])fx);
    }

    private double iterateFilter(int i, double x) {
        this.A.save(i, this.state);
        boolean missing = this.vf.isMissing(i);
        double fx = x - this.loading.ZX(i, this.state);
        if (!missing) {
            DataBlock M;
            double f;
            if (i < this.enddiffuse) {
                double fi = this.vf.diffuseNorm2(i);
                if (fi != 0.0) {
                    f = fi;
                    M = this.vf.Mi(i);
                } else {
                    f = this.vf.errorVariance(i);
                    M = this.vf.M(i);
                }
            } else {
                f = this.vf.errorVariance(i);
                M = this.vf.M(i);
            }
            if (f > 0.0) {
                this.state.addAY(fx / f, M);
            }
        }
        this.dynamics.TX(i, this.state);
        return fx;
    }

    void backwardFilter(DoubleSeq x) {
        int t;
        for (t = x.length() - 1; t >= this.enddiffuse; --t) {
            this.iterateSmoother(t, x.get(t));
        }
        while (t >= 0) {
            this.iterateDiffuseSmoother(t, x.get(t));
            --t;
        }
    }

    private void iterateDiffuseSmoother(int pos, double fx) {
        double f = this.vf.errorVariance(pos);
        double fi = this.vf.diffuseNorm2(pos);
        this.C.copy(this.vf.M(pos));
        if (fi != 0.0) {
            this.Ci.copy(this.vf.Mi(pos));
            this.Ci.mul(1.0 / fi);
            this.C.addAY(-f, this.Ci);
            this.C.mul(1.0 / fi);
        } else {
            this.C.mul(1.0 / f);
            this.Ci.set(0.0);
        }
        boolean missing = this.vf.isMissing(pos);
        this.dynamics.XT(pos, this.Rf);
        this.dynamics.XT(pos, this.Ri);
        if (!missing) {
            if (fi == 0.0) {
                double u = fx / f - this.Rf.dot(this.C);
                this.loading.XpZd(pos, this.Rf, u);
            } else {
                double ci = fx / fi - this.Ri.dot(this.Ci) - this.Rf.dot(this.C);
                this.loading.XpZd(pos, this.Ri, ci);
                double u = -this.Rf.dot(this.Ci);
                this.loading.XpZd(pos, this.Rf, u);
            }
        }
        DataBlock a = this.A.datablock(pos);
        a.addProduct(this.Rf, this.vf.P(pos).columnsIterator());
        a.addProduct(this.Ri, this.vf.Pi(pos).columnsIterator());
    }

    private void iterateSmoother(int pos, double fx) {
        double f = this.vf.errorVariance(pos);
        this.C.copy(this.vf.M(pos));
        this.C.mul(1.0 / f);
        boolean missing = this.vf.isMissing(pos);
        this.dynamics.XT(pos, this.Rf);
        if (!missing) {
            double u = fx / f - this.Rf.dot(this.C);
            this.loading.XpZd(pos, this.Rf, u);
        }
        DataBlock a = this.A.datablock(pos);
        a.addProduct(this.Rf, this.vf.P(pos).columnsIterator());
    }

    public static interface VarianceFilterProvider {
        public int size();

        public int endDiffusePosition();

        public boolean isMissing(int var1);

        public double errorVariance(int var1);

        public double diffuseNorm2(int var1);

        public DataBlock M(int var1);

        public DataBlock Mi(int var1);

        public FastMatrix P(int var1);

        public FastMatrix Pi(int var1);

        public static VarianceFilterProvider of(final DefaultDiffuseFilteringResults fr2) {
            return new VarianceFilterProvider(){

                @Override
                public int size() {
                    return fr2.size();
                }

                @Override
                public int endDiffusePosition() {
                    return fr2.getEndDiffusePosition();
                }

                @Override
                public boolean isMissing(int pos) {
                    return fr2.isMissing(pos);
                }

                @Override
                public double errorVariance(int pos) {
                    return fr2.errorVariance(pos);
                }

                @Override
                public double diffuseNorm2(int pos) {
                    return fr2.diffuseNorm2(pos);
                }

                @Override
                public DataBlock M(int pos) {
                    return fr2.M(pos);
                }

                @Override
                public DataBlock Mi(int pos) {
                    return fr2.Mi(pos);
                }

                @Override
                public FastMatrix P(int pos) {
                    return fr2.P(pos);
                }

                @Override
                public FastMatrix Pi(int pos) {
                    return fr2.Pi(pos);
                }
            };
        }

        public static VarianceFilterProvider of(final DefaultFilteringResults fr2) {
            return new VarianceFilterProvider(){

                @Override
                public int size() {
                    return fr2.size();
                }

                @Override
                public int endDiffusePosition() {
                    return 0;
                }

                @Override
                public boolean isMissing(int pos) {
                    return fr2.isMissing(pos);
                }

                @Override
                public double errorVariance(int pos) {
                    return fr2.errorVariance(pos);
                }

                @Override
                public double diffuseNorm2(int pos) {
                    return 0.0;
                }

                @Override
                public DataBlock M(int pos) {
                    return fr2.M(pos);
                }

                @Override
                public DataBlock Mi(int pos) {
                    return DataBlock.EMPTY;
                }

                @Override
                public FastMatrix P(int pos) {
                    return fr2.P(pos);
                }

                @Override
                public FastMatrix Pi(int pos) {
                    return FastMatrix.EMPTY;
                }
            };
        }
    }
}

