/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.protobuf.modelling;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Iterables;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.Range;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.TsContextVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.modelling.StationaryTransformation;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import lombok.Generated;

public final class ModellingProtosUtility {
    public static LengthOfPeriodType convert(ModellingProtos.LengthOfPeriod lp) {
        return switch (lp) {
            case ModellingProtos.LengthOfPeriod.LP_LEAPYEAR -> LengthOfPeriodType.LeapYear;
            case ModellingProtos.LengthOfPeriod.LP_LENGTHOFPERIOD -> LengthOfPeriodType.LengthOfPeriod;
            default -> LengthOfPeriodType.None;
        };
    }

    public static ModellingProtos.LengthOfPeriod convert(LengthOfPeriodType lp) {
        return switch (lp) {
            case LengthOfPeriodType.LeapYear -> ModellingProtos.LengthOfPeriod.LP_LEAPYEAR;
            case LengthOfPeriodType.LengthOfPeriod -> ModellingProtos.LengthOfPeriod.LP_LENGTHOFPERIOD;
            default -> ModellingProtos.LengthOfPeriod.LP_NONE;
        };
    }

    public static ModellingProtos.TradingDays convert(TradingDaysType td) {
        return switch (td) {
            case TradingDaysType.TD7 -> ModellingProtos.TradingDays.TD7;
            case TradingDaysType.TD6 -> ModellingProtos.TradingDays.TD6;
            case TradingDaysType.TD4c -> ModellingProtos.TradingDays.TD4C;
            case TradingDaysType.TD4 -> ModellingProtos.TradingDays.TD4;
            case TradingDaysType.TD3c -> ModellingProtos.TradingDays.TD3C;
            case TradingDaysType.TD3 -> ModellingProtos.TradingDays.TD3;
            case TradingDaysType.TD2c -> ModellingProtos.TradingDays.TD2C;
            case TradingDaysType.TD2d -> ModellingProtos.TradingDays.TD2D;
            case TradingDaysType.TD2 -> ModellingProtos.TradingDays.TD2;
            default -> ModellingProtos.TradingDays.TD_NONE;
        };
    }

    public static TradingDaysType convert(ModellingProtos.TradingDays td) {
        return switch (td) {
            case ModellingProtos.TradingDays.TD7 -> TradingDaysType.TD7;
            case ModellingProtos.TradingDays.TD6 -> TradingDaysType.TD6;
            case ModellingProtos.TradingDays.TD4C -> TradingDaysType.TD4c;
            case ModellingProtos.TradingDays.TD4 -> TradingDaysType.TD4;
            case ModellingProtos.TradingDays.TD3 -> TradingDaysType.TD3;
            case ModellingProtos.TradingDays.TD3C -> TradingDaysType.TD3c;
            case ModellingProtos.TradingDays.TD2C -> TradingDaysType.TD2c;
            case ModellingProtos.TradingDays.TD2D -> TradingDaysType.TD2d;
            case ModellingProtos.TradingDays.TD2 -> TradingDaysType.TD2;
            default -> TradingDaysType.NONE;
        };
    }

    public static ModellingProtos.Transformation convert(TransformationType fn) {
        return switch (fn) {
            case TransformationType.Log -> ModellingProtos.Transformation.FN_LOG;
            case TransformationType.Auto -> ModellingProtos.Transformation.FN_AUTO;
            default -> ModellingProtos.Transformation.FN_LEVEL;
        };
    }

    public static TransformationType convert(ModellingProtos.Transformation fn) {
        return switch (fn) {
            case ModellingProtos.Transformation.FN_LOG -> TransformationType.Log;
            case ModellingProtos.Transformation.FN_AUTO -> TransformationType.Auto;
            default -> TransformationType.None;
        };
    }

    public static ModellingProtos.TsVariable convertTsContextVariable(Variable<TsContextVariable> v) {
        return ModellingProtos.TsVariable.newBuilder().setName(v.getName()).setId(((TsContextVariable)v.getCore()).getId()).setLag(((TsContextVariable)v.getCore()).getLag()).setCoefficient(ToolkitProtosUtility.convert(v.getCoefficient(0))).putAllMetadata(v.getAttributes()).build();
    }

    public static Variable<TsContextVariable> convert(ModellingProtos.TsVariable v) {
        Parameter[] parameterArray;
        Parameter c = ToolkitProtosUtility.convert(v.getCoefficient());
        Variable.Builder builder = Variable.builder().name(v.getName()).core((ITsVariable)new TsContextVariable(v.getId(), v.getLag())).attributes(v.getMetadataMap());
        if (c == null) {
            parameterArray = null;
        } else {
            Parameter[] parameterArray2 = new Parameter[1];
            parameterArray = parameterArray2;
            parameterArray2[0] = c;
        }
        return builder.coefficients(parameterArray).build();
    }

    public static ModellingProtos.Ramp convertRamp(Variable<Ramp> v) {
        return ModellingProtos.Ramp.newBuilder().setName(v.getName()).setStart(ToolkitProtosUtility.convert(((Ramp)v.getCore()).getStart().toLocalDate())).setEnd(ToolkitProtosUtility.convert(((Ramp)v.getCore()).getEnd().toLocalDate())).setCoefficient(ToolkitProtosUtility.convert(v.getCoefficient(0))).putAllMetadata(v.getAttributes()).build();
    }

    public static Variable<Ramp> convert(ModellingProtos.Ramp v) {
        Parameter[] parameterArray;
        LocalDate start = ToolkitProtosUtility.convert(v.getStart());
        LocalDate end = ToolkitProtosUtility.convert(v.getEnd());
        Parameter c = ToolkitProtosUtility.convert(v.getCoefficient());
        Variable.Builder builder = Variable.builder().name(v.getName()).core((ITsVariable)new Ramp(start.atStartOfDay(), end.atStartOfDay())).attributes(v.getMetadataMap());
        if (c == null) {
            parameterArray = null;
        } else {
            Parameter[] parameterArray2 = new Parameter[1];
            parameterArray = parameterArray2;
            parameterArray2[0] = c;
        }
        return builder.coefficients(parameterArray).build();
    }

    public static ModellingProtos.InterventionVariable convertInterventionVariable(Variable<InterventionVariable> var) {
        InterventionVariable v = (InterventionVariable)var.getCore();
        ModellingProtos.InterventionVariable.Builder builder = ModellingProtos.InterventionVariable.newBuilder().setName(var.getName()).setDelta(v.getDelta()).setSeasonalDelta(v.getDeltaSeasonal()).setCoefficient(ToolkitProtosUtility.convert(var.getCoefficient(0))).putAllMetadata(var.getAttributes());
        List seqs = v.getSequences();
        for (Range seq : seqs) {
            builder.addSequences(ModellingProtos.InterventionVariable.Sequence.newBuilder().setStart(ToolkitProtosUtility.convert(((LocalDateTime)seq.start()).toLocalDate())).setEnd(ToolkitProtosUtility.convert(((LocalDateTime)seq.end()).toLocalDate())).build());
        }
        return builder.build();
    }

    public static Variable<InterventionVariable> convert(ModellingProtos.InterventionVariable v) {
        Parameter[] parameterArray;
        InterventionVariable.Builder builder = InterventionVariable.builder().delta(v.getDelta()).deltaSeasonal(v.getSeasonalDelta());
        int n = v.getSequencesCount();
        for (int i = 0; i < n; ++i) {
            ModellingProtos.InterventionVariable.Sequence seq = v.getSequences(i);
            LocalDate start = ToolkitProtosUtility.convert(seq.getStart());
            LocalDate end = ToolkitProtosUtility.convert(seq.getEnd());
            builder.sequence(Range.of((Comparable)start.atStartOfDay(), (Comparable)end.atStartOfDay()));
        }
        Parameter c = ToolkitProtosUtility.convert(v.getCoefficient());
        Variable.Builder builder2 = Variable.builder().name(v.getName()).core((ITsVariable)builder.build());
        if (c == null) {
            parameterArray = null;
        } else {
            Parameter[] parameterArray2 = new Parameter[1];
            parameterArray = parameterArray2;
            parameterArray2[0] = c;
        }
        return builder2.coefficients(parameterArray).attributes(v.getMetadataMap()).build();
    }

    public static ModellingProtos.StationaryTransformation convert(StationaryTransformation st) {
        ModellingProtos.StationaryTransformation.Builder builder = ModellingProtos.StationaryTransformation.newBuilder().addAllStationarySeries(Iterables.of((DoubleSeq)st.getStationarySeries())).setMeanCorrection(st.isMeanCorrection());
        for (StationaryTransformation.Differencing d : st.getDifferences()) {
            builder.addDifferences(ModellingProtos.StationaryTransformation.Differencing.newBuilder().setLag(d.getLag()).setOrder(d.getOrder()).build());
        }
        return builder.build();
    }

    public static StationaryTransformation convert(ModellingProtos.StationaryTransformation st) {
        double[] ds = new double[st.getStationarySeriesCount()];
        for (int i = 0; i < ds.length; ++i) {
            ds[i] = st.getStationarySeries(i);
        }
        StationaryTransformation.Builder builder = StationaryTransformation.builder().stationarySeries(DoubleSeq.of((double[])ds)).meanCorrection(st.getMeanCorrection());
        for (int i = 0; i < st.getDifferencesCount(); ++i) {
            ModellingProtos.StationaryTransformation.Differencing d = st.getDifferences(i);
            builder.difference(new StationaryTransformation.Differencing(d.getLag(), d.getOrder()));
        }
        return builder.build();
    }

    public static ModellingProtos.ArimaModel convert(IArimaModel arima, String name) {
        return ModellingProtos.ArimaModel.newBuilder().setName(name).addAllAr(Iterables.of((DoubleSeq)arima.getStationaryAr().asPolynomial().coefficients())).addAllDelta(Iterables.of((DoubleSeq)arima.getNonStationaryAr().asPolynomial().coefficients())).addAllMa(Iterables.of((DoubleSeq)arima.getMa().asPolynomial().coefficients())).setInnovationVariance(arima.getInnovationVariance()).build();
    }

    @Generated
    private ModellingProtosUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

