/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries;

import jdplus.toolkit.base.api.data.AggregationType;
import jdplus.toolkit.base.api.data.DoubleSeq;

@FunctionalInterface
public interface InternalAggregator {
    public double aggregate(DoubleSeq var1, int var2, int var3);

    public static InternalAggregator of(AggregationType type) {
        switch (type) {
            case Average: {
                return InternalAggregator::average;
            }
            case First: {
                return InternalAggregator::first;
            }
            case Last: {
                return InternalAggregator::last;
            }
            case Max: {
                return InternalAggregator::max;
            }
            case Min: {
                return InternalAggregator::min;
            }
            case None: {
                return InternalAggregator::none;
            }
            case Sum: {
                return InternalAggregator::sum;
            }
        }
        throw new RuntimeException();
    }

    public static double none(DoubleSeq values, int start, int end) {
        return Double.NaN;
    }

    public static double sum(DoubleSeq values, int start, int end) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            double val = values.get(i);
            if (!Double.isFinite(val)) continue;
            sum += val;
        }
        return sum;
    }

    public static double average(DoubleSeq values, int start, int end) {
        double sum = 0.0;
        double count = 0.0;
        for (int i = start; i < end; ++i) {
            double val = values.get(i);
            if (!Double.isFinite(val)) continue;
            sum += val;
            count += 1.0;
        }
        return count != 0.0 ? sum / count : Double.NaN;
    }

    public static double first(DoubleSeq values, int start, int end) {
        for (int i = start; i < end; ++i) {
            double val = values.get(i);
            if (!Double.isFinite(val)) continue;
            return val;
        }
        return Double.NaN;
    }

    public static double last(DoubleSeq values, int start, int end) {
        double last = Double.NaN;
        for (int i = start; i < end; ++i) {
            double val = values.get(i);
            if (!Double.isFinite(val)) continue;
            last = val;
        }
        return last;
    }

    public static double min(DoubleSeq values, int start, int end) {
        double min = Double.MAX_VALUE;
        for (int i = start; i < end; ++i) {
            double val = values.get(i);
            if (!Double.isFinite(val) || !(val < min)) continue;
            min = val;
        }
        return min != Double.MAX_VALUE ? min : Double.NaN;
    }

    public static double max(DoubleSeq values, int start, int end) {
        double max = Double.MIN_VALUE;
        for (int i = start; i < end; ++i) {
            double val = values.get(i);
            if (!Double.isFinite(val) || !(val > max)) continue;
            max = val;
        }
        return max != Double.MIN_VALUE ? max : Double.NaN;
    }
}

