/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.util.Arrays;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import lombok.NonNull;

public interface ITsVariable {
    public int dim();

    public <D extends TimeSeriesDomain<?>> String description(D var1);

    default public <D extends TimeSeriesDomain<?>> String description(int idx, D context) {
        if (this.dim() == 1) {
            return this.description(context);
        }
        StringBuilder builder = new StringBuilder();
        return builder.append(this.description(context)).append(" - ").append(idx + 1).toString();
    }

    public static int dim(ITsVariable ... vars) {
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        return ITsVariable.dim(Arrays.stream(vars));
    }

    public static int dim(@NonNull Stream<ITsVariable> vars) {
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        return vars.mapToInt(var -> var.dim()).sum();
    }

    public static String nextName(String name) {
        int pos0 = name.lastIndexOf(40);
        int pos1 = name.lastIndexOf(41);
        if (pos0 > 0 && pos1 > 0) {
            String prefix = name.substring(0, pos0);
            int cur = 1;
            try {
                String num = name.substring(pos0 + 1, pos1);
                cur = Integer.parseInt(num) + 1;
            }
            catch (NumberFormatException num) {
                // empty catch block
            }
            StringBuilder builder = new StringBuilder();
            builder.append(prefix).append('(').append(cur).append(')');
            return builder.toString();
        }
        return name + "(1)";
    }
}

