/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DSITypeUtilities;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.Searchable;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.InvalidArgumentException;
import com.amazon.dsi.exceptions.InvalidOperationException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;

public class DSIExtTypeInfoMetadataSource
implements IMetadataSource {
    private static int[] BASIC_SQL_TYPES = new int[]{1, 12, -1, -2, -3, -4, -7, 2, 3, 8, 6, 7, -6, 5, 4, -5, 93, 91, 92, -8, -9, -10, -11, 16, 2003};
    private boolean m_isFetching = false;
    private int m_currentIndex = 0;
    ArrayList<SqlTypeInfo> m_dataTypes = new ArrayList();
    private ILogger m_logger;
    private final boolean m_isODBC2;

    public DSIExtTypeInfoMetadataSource(ILogger iLogger, boolean bl) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_isODBC2 = bl;
        this.initializeDataTypes();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.closeCursor();
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isFetching = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case DATA_TYPE_NAME: {
                String string = this.m_dataTypes.get((int)this.m_currentIndex).m_typeName;
                return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(TypeUtilities.NormalizeDateTimeTypeForODBC2(this.m_dataTypes.get((int)this.m_currentIndex).m_sqlType, this.m_isODBC2));
                return false;
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(this.m_dataTypes.get((int)this.m_currentIndex).m_columnSize);
                return false;
            }
            case LITERAL_PREFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_literalPrefix, dataWrapper, l, l2);
            }
            case LITERAL_SUFFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_literalSuffix, dataWrapper, l, l2);
            }
            case CREATE_PARAM: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_createParams, dataWrapper, l, l2);
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_nullable.ordinal());
                return false;
            }
            case CASE_SENSITIVE: {
                if (this.m_dataTypes.get((int)this.m_currentIndex).m_isCaseSensitive) {
                    dataWrapper.setSmallInt(1);
                } else {
                    dataWrapper.setSmallInt(0);
                }
                return false;
            }
            case SEARCHABLE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_searchable.ordinal());
                return false;
            }
            case UNSIGNED_ATTRIBUTE: {
                SqlTypeInfo sqlTypeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (!(TypeUtilities.isApproximateNumericType(sqlTypeInfo.m_sqlType) || TypeUtilities.isExactNumericType(sqlTypeInfo.m_sqlType) || TypeUtilities.isIntegerType(sqlTypeInfo.m_sqlType))) {
                    dataWrapper.setNull(5);
                } else if (this.m_dataTypes.get((int)this.m_currentIndex).m_isUnsigned.booleanValue()) {
                    dataWrapper.setSmallInt(1);
                } else {
                    dataWrapper.setSmallInt(0);
                }
                return false;
            }
            case FIXED_PREC_SCALE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_hasFixedPrecisionAndScale != false ? 1 : 0);
                return false;
            }
            case AUTO_UNIQUE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_autoUnique);
                return false;
            }
            case LOCAL_TYPE_NAME: {
                String string = this.m_dataTypes.get((int)this.m_currentIndex).m_typeName;
                if (string.toUpperCase().startsWith("SQL_")) {
                    string = string.substring(4);
                }
                return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
            }
            case MINIMUM_SCALE: {
                SqlTypeInfo sqlTypeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isExactNumericType(sqlTypeInfo.m_sqlType) || TypeUtilities.isIntegerType(sqlTypeInfo.m_sqlType) || -7 == sqlTypeInfo.m_sqlType || 92 == sqlTypeInfo.m_sqlType || 93 == sqlTypeInfo.m_sqlType) {
                    dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_minScale);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case MAXIMUM_SCALE: {
                SqlTypeInfo sqlTypeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isExactNumericType(sqlTypeInfo.m_sqlType) || TypeUtilities.isIntegerType(sqlTypeInfo.m_sqlType) || -7 == sqlTypeInfo.m_sqlType || 92 == sqlTypeInfo.m_sqlType || 93 == sqlTypeInfo.m_sqlType) {
                    dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_maxScale);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case SQL_DATA_TYPE: {
                int n = this.m_dataTypes.get((int)this.m_currentIndex).m_sqlType;
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(n));
                return false;
            }
            case SQL_DATETIME_SUB: {
                SqlTypeInfo sqlTypeInfo = this.m_dataTypes.get(this.m_currentIndex);
                short s = TypeUtilities.getIntervalCodeFromConciseType(sqlTypeInfo.m_sqlType);
                if (0 == s) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(s);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                SqlTypeInfo sqlTypeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isApproximateNumericType(sqlTypeInfo.m_sqlType)) {
                    dataWrapper.setInteger(2L);
                } else if (TypeUtilities.isExactNumericType(sqlTypeInfo.m_sqlType) || TypeUtilities.isIntegerType(sqlTypeInfo.m_sqlType)) {
                    dataWrapper.setInteger(10L);
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case INTERVAL_PRECISION: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_intervalPrecision);
                return false;
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_dataTypes.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            ++this.m_currentIndex;
        } else {
            this.m_isFetching = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_dataTypes.size();
    }

    protected void addUserDataTypeInfo(SqlTypeInfo sqlTypeInfo) throws ErrorException {
        boolean bl = false;
        for (int n : BASIC_SQL_TYPES) {
            if (n != sqlTypeInfo.m_sqlType) continue;
            bl = true;
        }
        if (!bl) {
            throw SQLEngineExceptionFactory.unsupportedTypesException(Integer.toString(sqlTypeInfo.m_sqlType));
        }
        this.m_dataTypes.add(sqlTypeInfo);
    }

    protected TypePrepared prepareType(SqlTypeInfo sqlTypeInfo) {
        return TypePrepared.DONE;
    }

    protected final SqlTypeInfo createSqlTypeInfo(int n) throws IncorrectTypeException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        SqlTypeInfo sqlTypeInfo = new SqlTypeInfo(n, TypeUtilities.sqlTypeToString((short)n), 0);
        switch (n) {
            case 1: {
                sqlTypeInfo.m_columnSize = 255;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                sqlTypeInfo.m_createParams = "LENGTH";
                sqlTypeInfo.m_isCaseSensitive = true;
                break;
            }
            case 12: {
                sqlTypeInfo.m_columnSize = 510;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                sqlTypeInfo.m_createParams = "MAX LENGTH";
                sqlTypeInfo.m_isCaseSensitive = true;
                break;
            }
            case -1: {
                sqlTypeInfo.m_columnSize = 65500;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                sqlTypeInfo.m_createParams = "MAX LENGTH";
                sqlTypeInfo.m_isCaseSensitive = true;
                break;
            }
            case -2: {
                sqlTypeInfo.m_columnSize = 512;
                sqlTypeInfo.m_createParams = "LENGTH";
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_NONE;
                break;
            }
            case -3: {
                sqlTypeInfo.m_columnSize = Short.MAX_VALUE;
                sqlTypeInfo.m_createParams = "MAX LENGTH";
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_NONE;
                break;
            }
            case -4: {
                sqlTypeInfo.m_columnSize = 2147483000;
                sqlTypeInfo.m_createParams = "MAX LENGTH";
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_NONE;
                break;
            }
            case -7: {
                sqlTypeInfo.m_columnSize = 1;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 0;
                sqlTypeInfo.m_isUnsigned = true;
                break;
            }
            case 2: {
                sqlTypeInfo.m_columnSize = 38;
                sqlTypeInfo.m_createParams = "PRECISION,SCALE";
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 38;
                sqlTypeInfo.m_hasFixedPrecisionAndScale = true;
                break;
            }
            case 3: {
                sqlTypeInfo.m_columnSize = 38;
                sqlTypeInfo.m_createParams = "PRECISION,SCALE";
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 38;
                sqlTypeInfo.m_hasFixedPrecisionAndScale = true;
                break;
            }
            case 8: {
                sqlTypeInfo.m_columnSize = 53;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                break;
            }
            case 6: {
                sqlTypeInfo.m_columnSize = 53;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                break;
            }
            case 7: {
                sqlTypeInfo.m_columnSize = 24;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                break;
            }
            case -6: {
                sqlTypeInfo.m_columnSize = 3;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 0;
                break;
            }
            case 5: {
                sqlTypeInfo.m_columnSize = 5;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 0;
                break;
            }
            case 4: {
                sqlTypeInfo.m_columnSize = 10;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 0;
                break;
            }
            case -5: {
                sqlTypeInfo.m_columnSize = 19;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                sqlTypeInfo.m_isUnsigned = false;
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 0;
                break;
            }
            case 93: {
                sqlTypeInfo.m_columnSize = 29;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 0;
                break;
            }
            case 91: {
                sqlTypeInfo.m_columnSize = 10;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                break;
            }
            case 92: {
                sqlTypeInfo.m_columnSize = 8;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                sqlTypeInfo.m_minScale = 0;
                sqlTypeInfo.m_maxScale = 0;
                break;
            }
            case -8: {
                sqlTypeInfo.m_columnSize = 255;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                sqlTypeInfo.m_createParams = "LENGTH";
                sqlTypeInfo.m_isCaseSensitive = true;
                break;
            }
            case -9: {
                sqlTypeInfo.m_columnSize = 510;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                sqlTypeInfo.m_createParams = "MAX LENGTH";
                sqlTypeInfo.m_isCaseSensitive = true;
                break;
            }
            case -10: {
                sqlTypeInfo.m_columnSize = 65500;
                sqlTypeInfo.m_literalPrefix = "'";
                sqlTypeInfo.m_literalSuffix = "'";
                sqlTypeInfo.m_createParams = "MAX LENGTH";
                sqlTypeInfo.m_isCaseSensitive = true;
                break;
            }
            case -11: {
                sqlTypeInfo.m_columnSize = 36;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                break;
            }
            case 16: {
                sqlTypeInfo.m_columnSize = 1;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_BASIC;
                break;
            }
            case 2003: {
                sqlTypeInfo.m_columnSize = -4;
                sqlTypeInfo.m_searchable = Searchable.PREDICATE_NONE;
                break;
            }
            default: {
                throw new InvalidArgumentException(7, "sqlType");
            }
        }
        return sqlTypeInfo;
    }

    private void initializeDataTypes() {
        try {
            for (int n : BASIC_SQL_TYPES) {
                SqlTypeInfo sqlTypeInfo = this.createSqlTypeInfo(n);
                TypePrepared typePrepared = this.prepareType(sqlTypeInfo);
                if (typePrepared != TypePrepared.DONE) continue;
                this.m_dataTypes.add(sqlTypeInfo);
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new InvalidOperationException();
        }
    }

    protected static enum TypePrepared {
        NOT_SUPPORTED,
        DONE;

    }

    protected static class SqlTypeInfo {
        public String m_typeName;
        public int m_sqlType;
        public int m_columnSize;
        public String m_literalPrefix;
        public String m_literalSuffix;
        public String m_createParams;
        public Nullable m_nullable;
        public boolean m_isCaseSensitive;
        public Searchable m_searchable;
        public Boolean m_isUnsigned;
        public Boolean m_hasFixedPrecisionAndScale;
        public Integer m_autoUnique;
        public Integer m_minScale;
        public Integer m_maxScale;
        public Integer m_intervalPrecision;

        public SqlTypeInfo(int n, String string, int n2) {
            this.m_sqlType = n;
            this.m_typeName = string;
            this.m_columnSize = n2;
            this.m_literalPrefix = null;
            this.m_literalSuffix = null;
            this.m_createParams = null;
            this.m_nullable = Nullable.NULLABLE;
            this.m_isCaseSensitive = false;
            this.m_searchable = Searchable.SEARCHABLE;
            this.m_isUnsigned = true;
            this.m_hasFixedPrecisionAndScale = false;
            this.m_autoUnique = 0;
        }
    }
}

