/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.PathGradient;
import dr.inference.hmc.ReversibleHMCProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.GeneralOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.PathDependent;
import dr.inference.operators.hmc.MassPreconditionScheduler;
import dr.inference.operators.hmc.MassPreconditioner;
import dr.inference.operators.hmc.MassPreconditioningOptions;
import dr.math.MathUtils;
import dr.math.MultivariateFunction;
import dr.math.NumericalDerivative;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedVector;
import dr.util.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class HamiltonianMonteCarloOperator
extends AbstractAdaptableOperator
implements GeneralOperator,
PathDependent,
ReversibleHMCProvider {
    final GradientWrtParameterProvider gradientProvider;
    protected double stepSize;
    LeapFrogEngine leapFrogEngine;
    protected final Parameter parameter;
    protected final MassPreconditioner preconditioning;
    protected final MassPreconditionScheduler preconditionScheduler;
    private final Options runtimeOptions;
    protected final double[] mask;
    protected final Transform transform;
    private static final boolean REJECT_ARITHMETIC_EXCEPTION = true;
    private static final boolean DEBUG = false;

    public HamiltonianMonteCarloOperator(AdaptationMode mode, double weight, GradientWrtParameterProvider gradientProvider, Parameter parameter, Transform transform, Parameter maskParameter, Options runtimeOptions, MassPreconditioner preconditioner) {
        this(mode, weight, gradientProvider, parameter, transform, maskParameter, runtimeOptions, preconditioner, MassPreconditionScheduler.Type.DEFAULT);
    }

    public HamiltonianMonteCarloOperator(AdaptationMode mode, double weight, GradientWrtParameterProvider gradientProvider, Parameter parameter, Transform transform, Parameter maskParameter, Options runtimeOptions, MassPreconditioner preconditioner, MassPreconditionScheduler.Type preconditionSchedulerType) {
        super(mode, runtimeOptions.targetAcceptanceProbability);
        this.setWeight(weight);
        this.gradientProvider = gradientProvider;
        this.runtimeOptions = runtimeOptions;
        this.stepSize = runtimeOptions.initialStepSize;
        this.preconditioning = preconditioner;
        this.preconditionScheduler = preconditionSchedulerType.factory(runtimeOptions, (MCMCOperator)this);
        this.parameter = parameter;
        this.mask = this.buildMask(maskParameter);
        this.transform = transform;
        this.leapFrogEngine = this.constructLeapFrogEngine(transform);
    }

    protected LeapFrogEngine constructLeapFrogEngine(Transform transform) {
        return transform != null ? new LeapFrogEngine.WithTransform(this.parameter, transform, this.getDefaultInstabilityHandler(), this.preconditioning, this.mask) : new LeapFrogEngine.Default(this.parameter, this.getDefaultInstabilityHandler(), this.preconditioning, this.mask);
    }

    public String getOperatorName() {
        return "VanillaHMC(" + this.parameter.getParameterName() + ")";
    }

    protected double[] buildMask(Parameter maskParameter) {
        if (maskParameter == null) {
            return null;
        }
        double[] mask = new double[maskParameter.getDimension()];
        int i = 0;
        while (i < mask.length) {
            mask[i] = maskParameter.getParameterValue(i) == 0.0 ? 0.0 : 1.0;
            ++i;
        }
        return mask;
    }

    public double doOperation() {
        throw new RuntimeException("Should not be executed");
    }

    public double doOperation(Likelihood joint) {
        if (this.shouldCheckStepSize()) {
            this.checkStepSize();
        }
        if (this.shouldCheckGradient()) {
            this.checkGradient(joint);
        }
        if (this.preconditionScheduler.shouldUpdatePreconditioning()) {
            this.updatePreconditioning();
        }
        try {
            return this.leapFrog();
        }
        catch (NumericInstabilityException e) {
            return Double.NEGATIVE_INFINITY;
        }
        catch (ArithmeticException e) {
            return Double.NEGATIVE_INFINITY;
        }
    }

    private void updatePreconditioning() {
        double[] lastGradient = this.leapFrogEngine.getLastGradient();
        double[] lastPosition = this.leapFrogEngine.getLastPosition();
        double[] currentPosition = this.leapFrogEngine.getInitialPosition();
        if (this.preconditionScheduler.shouldStoreSecant(lastGradient, lastPosition)) {
            this.preconditioning.storeSecant((ReadableVector)new WrappedVector.Raw(lastGradient), (ReadableVector)new WrappedVector.Raw(currentPosition));
        }
        this.preconditioning.updateMass();
    }

    public void setPathParameter(double beta) {
        if (this.gradientProvider instanceof PathGradient) {
            ((PathGradient)this.gradientProvider).setPathParameter(beta);
        }
    }

    private boolean shouldCheckStepSize() {
        return this.getCount() < 1L && this.getMode() == AdaptationMode.ADAPTATION_ON;
    }

    private void checkStepSize() {
        double[] initialPosition = this.parameter.getParameterValues();
        int iterations = 0;
        boolean acceptableSize = false;
        while (!acceptableSize && iterations < this.runtimeOptions.checkStepSizeMaxIterations) {
            try {
                this.leapFrog();
                double logLikelihood = this.gradientProvider.getLikelihood().getLogLikelihood();
                if (!Double.isNaN(logLikelihood) && !Double.isInfinite(logLikelihood)) {
                    acceptableSize = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!acceptableSize) {
                this.stepSize *= this.runtimeOptions.checkStepSizeReductionFactor;
            }
            ReadableVector.Utils.setParameter((double[])initialPosition, (Parameter)this.parameter);
            ++iterations;
        }
        if (!acceptableSize && iterations < this.runtimeOptions.checkStepSizeMaxIterations) {
            throw new RuntimeException("Unable to find acceptable initial HMC step-size");
        }
    }

    boolean shouldCheckGradient() {
        return this.getCount() < (long)this.runtimeOptions.gradientCheckCount;
    }

    void checkGradient(final Likelihood joint) {
        if (this.parameter.getDimension() != this.gradientProvider.getDimension()) {
            throw new RuntimeException("Unequal dimensions");
        }
        MultivariateFunction numeric = new MultivariateFunction(){

            public double evaluate(double[] argument) {
                if (HamiltonianMonteCarloOperator.this.transform == null) {
                    ReadableVector.Utils.setParameter((double[])argument, (Parameter)HamiltonianMonteCarloOperator.this.parameter);
                    return joint.getLogLikelihood();
                }
                double[] untransformedValue = HamiltonianMonteCarloOperator.this.transform.inverse(argument, 0, argument.length);
                ReadableVector.Utils.setParameter((double[])untransformedValue, (Parameter)HamiltonianMonteCarloOperator.this.parameter);
                return joint.getLogLikelihood() - HamiltonianMonteCarloOperator.this.transform.logJacobian(untransformedValue, 0, untransformedValue.length);
            }

            public int getNumArguments() {
                return HamiltonianMonteCarloOperator.this.parameter.getDimension();
            }

            public double getLowerBound(int n) {
                return (Double)HamiltonianMonteCarloOperator.this.parameter.getBounds().getLowerLimit(n);
            }

            public double getUpperBound(int n) {
                return (Double)HamiltonianMonteCarloOperator.this.parameter.getBounds().getUpperLimit(n);
            }
        };
        double[] analyticalGradientOriginal = this.gradientProvider.getGradientLogDensity();
        double[] restoredParameterValue = this.parameter.getParameterValues();
        if (this.transform == null) {
            double[] numericGradientOriginal = NumericalDerivative.gradient((MultivariateFunction)numeric, (double[])this.parameter.getParameterValues());
            if (!MathUtils.isClose((double[])analyticalGradientOriginal, (double[])numericGradientOriginal, (double)this.runtimeOptions.gradientCheckTolerance)) {
                String sb = "Gradients do not match:\n\tAnalytic: " + new WrappedVector.Raw(analyticalGradientOriginal) + "\n" + "\tNumeric : " + new WrappedVector.Raw(numericGradientOriginal) + "\n" + this.gradientMismatchInformation(analyticalGradientOriginal, numericGradientOriginal);
                throw new RuntimeException(sb);
            }
        } else {
            double[] transformedParameter = this.transform.transform(this.parameter.getParameterValues(), 0, this.parameter.getParameterValues().length);
            double[] numericGradientTransformed = NumericalDerivative.gradient((MultivariateFunction)numeric, (double[])transformedParameter);
            double[] analyticalGradientTransformed = this.transform.updateGradientLogDensity(analyticalGradientOriginal, this.parameter.getParameterValues(), 0, this.parameter.getParameterValues().length);
            if (!MathUtils.isClose((double[])analyticalGradientTransformed, (double[])numericGradientTransformed, (double)this.runtimeOptions.gradientCheckTolerance)) {
                String sb = "Transformed Gradients do not match:\n\tAnalytic: " + new WrappedVector.Raw(analyticalGradientTransformed) + "\n" + "\tNumeric : " + new WrappedVector.Raw(numericGradientTransformed) + "\n" + "\tParameter : " + new WrappedVector.Raw(this.parameter.getParameterValues()) + "\n" + "\tTransformed Parameter : " + new WrappedVector.Raw(transformedParameter) + "\n" + this.gradientMismatchInformation(analyticalGradientTransformed, numericGradientTransformed);
                throw new RuntimeException(sb);
            }
        }
        ReadableVector.Utils.setParameter((double[])restoredParameterValue, (Parameter)this.parameter);
    }

    private String gradientMismatchInformation(double[] analyticGradient, double[] numericGradient) {
        int n = analyticGradient.length;
        double maxDiff = 0.0;
        int maxInd = -1;
        double meanDiff = 0.0;
        ArrayList<Integer> overIndices = new ArrayList<Integer>();
        double[] absDiffs = new double[n];
        int i = 0;
        while (i < n) {
            double absDiff;
            absDiffs[i] = absDiff = Math.abs(analyticGradient[i] - numericGradient[i]);
            meanDiff += absDiff;
            if (absDiff > this.runtimeOptions.gradientCheckTolerance) {
                overIndices.add(i);
            }
            if (absDiff > maxDiff) {
                maxDiff = absDiff;
                maxInd = i;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\tMaximum aboslute difference: " + maxDiff + " (at index " + maxInd + ")\n");
        sb.append("\tAverage absolute difference: " + (meanDiff /= (double)n) + "\n");
        sb.append("\tList of all values exceeding the tolerance:\n");
        sb.append("\t\tindex    analytic    numeric    absolute difference\n");
        int ind = 0;
        String spacer = "    ";
        Iterator iterator = overIndices.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            sb.append("\t\t" + overIndices.get(ind) + spacer + analyticGradient[i2] + spacer + numericGradient[i2] + spacer + absDiffs[i2] + "\n");
            ++ind;
        }
        return sb.toString();
    }

    static double[] mask(double[] vector, double[] mask) {
        assert (mask == null || mask.length == vector.length);
        if (mask != null) {
            int i = 0;
            while (i < vector.length) {
                if (mask[i] == 0.0) {
                    vector[i] = 0.0;
                }
                ++i;
            }
        }
        return vector;
    }

    static WrappedVector mask(WrappedVector vector, double[] mask) {
        assert (mask == null || mask.length == vector.getDim());
        if (mask != null) {
            int i = 0;
            while (i < vector.getDim()) {
                if (mask[i] == 0.0) {
                    vector.set(i, 0.0);
                }
                ++i;
            }
        }
        return vector;
    }

    private int getNumberOfSteps() {
        int count = this.runtimeOptions.nSteps;
        if (this.runtimeOptions.randomStepCountFraction > 0.0) {
            double draw = (double)count * (1.0 + this.runtimeOptions.randomStepCountFraction * (MathUtils.nextDouble() - 0.5));
            count = Math.max(1, (int)draw);
        }
        return count;
    }

    @Override
    public double getKineticEnergy(ReadableVector momentum) {
        int dim = momentum.getDim();
        double energy = 0.0;
        int i = 0;
        while (i < dim) {
            energy += momentum.get(i) * this.preconditioning.getVelocity(i, momentum);
            ++i;
        }
        return energy / 2.0;
    }

    private double leapFrog() throws NumericInstabilityException {
        WrappedVector momentum = HamiltonianMonteCarloOperator.mask(this.preconditioning.drawInitialMomentum(), this.mask);
        return this.leapFrogGivenMomentum(momentum);
    }

    protected double leapFrogGivenMomentum(WrappedVector momentum) throws NumericInstabilityException {
        this.leapFrogEngine.updateMask();
        double[] position = this.leapFrogEngine.getInitialPosition();
        this.leapFrogEngine.projectMomentum(momentum.getBuffer(), position);
        double prop = this.getKineticEnergy((ReadableVector)momentum) + this.leapFrogEngine.getParameterLogJacobian();
        this.leapFrogEngine.updateMomentum(position, momentum.getBuffer(), HamiltonianMonteCarloOperator.mask(this.gradientProvider.getGradientLogDensity(), this.mask), this.stepSize / 2.0);
        int nStepsThisLeap = this.getNumberOfSteps();
        int i = 0;
        while (i < nStepsThisLeap) {
            try {
                this.leapFrogEngine.updatePosition(position, momentum, this.stepSize);
            }
            catch (ArithmeticException e) {
                throw new NumericInstabilityException();
            }
            if (i < nStepsThisLeap - 1) {
                try {
                    this.leapFrogEngine.updateMomentum(position, momentum.getBuffer(), HamiltonianMonteCarloOperator.mask(this.gradientProvider.getGradientLogDensity(), this.mask), this.stepSize);
                }
                catch (ArithmeticException e) {
                    throw new NumericInstabilityException();
                }
            }
            ++i;
        }
        this.leapFrogEngine.updateMomentum(position, momentum.getBuffer(), HamiltonianMonteCarloOperator.mask(this.gradientProvider.getGradientLogDensity(), this.mask), this.stepSize / 2.0);
        double res = this.getKineticEnergy((ReadableVector)momentum) + this.leapFrogEngine.getParameterLogJacobian();
        return prop - res;
    }

    protected double getAdaptableParameterValue() {
        return Math.log(this.stepSize);
    }

    public void setAdaptableParameterValue(double value) {
        this.stepSize = Math.exp(value);
    }

    public double getRawParameter() {
        return this.stepSize;
    }

    protected InstabilityHandler getDefaultInstabilityHandler() {
        return this.runtimeOptions.instabilityHandler;
    }

    public String getAdaptableParameterName() {
        return "stepSize";
    }

    @Override
    public void reversiblePositionMomentumUpdate(WrappedVector position, WrappedVector momentum, WrappedVector gradient, int direction, double time) {
        this.preconditionScheduler.forceUpdateCount();
        try {
            this.leapFrogEngine.updateMomentum(position.getBuffer(), momentum.getBuffer(), HamiltonianMonteCarloOperator.mask(gradient.getBuffer(), this.mask), time * (double)direction / 2.0);
            this.leapFrogEngine.updatePosition(position.getBuffer(), momentum, time * (double)direction);
            this.updateGradient(gradient);
            this.leapFrogEngine.updateMomentum(position.getBuffer(), momentum.getBuffer(), HamiltonianMonteCarloOperator.mask(gradient.getBuffer(), this.mask), time * (double)direction / 2.0);
        }
        catch (NumericInstabilityException e) {
            this.handleInstability();
        }
    }

    @Override
    public void providerUpdatePreconditioning() {
        this.updatePreconditioning();
    }

    public void updateGradient(WrappedVector gradient) {
        double[] buffer = this.gradientProvider.getGradientLogDensity();
        int i = 0;
        while (i < buffer.length) {
            gradient.set(i, buffer[i]);
            ++i;
        }
    }

    @Override
    public double[] getInitialPosition() {
        return this.leapFrogEngine.getInitialPosition();
    }

    @Override
    public double getParameterLogJacobian() {
        return this.leapFrogEngine.getParameterLogJacobian();
    }

    @Override
    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public GradientWrtParameterProvider getGradientProvider() {
        return this.gradientProvider;
    }

    @Override
    public void setParameter(double[] position) {
        this.leapFrogEngine.setParameter(position);
    }

    @Override
    public WrappedVector drawMomentum() {
        return HamiltonianMonteCarloOperator.mask(this.preconditioning.drawInitialMomentum(), this.mask);
    }

    @Override
    public double getJointProbability(WrappedVector momentum) {
        return this.gradientProvider.getLikelihood().getLogLikelihood() - this.getKineticEnergy((ReadableVector)momentum) - this.getParameterLogJacobian();
    }

    @Override
    public double getLogLikelihood() {
        return this.gradientProvider.getLikelihood().getLogLikelihood();
    }

    @Override
    public double getStepSize() {
        return this.stepSize;
    }

    @Override
    public int getNumGradientEvent() {
        return 0;
    }

    @Override
    public int getNumBoundaryEvent() {
        return 0;
    }

    @Override
    public double[] getMask() {
        return this.mask;
    }

    protected void handleInstability() {
        throw new RuntimeException("Numerical instability; need to handle");
    }

    public static enum InstabilityHandler {
        REJECT("reject"){

            @Override
            void checkValue(double x) throws NumericInstabilityException {
                if (Double.isNaN(x)) {
                    throw new NumericInstabilityException();
                }
            }

            @Override
            void checkPosition(Transform transform, double[] unTransformedPosition) throws NumericInstabilityException {
                if (!transform.isInInteriorDomain(unTransformedPosition, 0, unTransformedPosition.length)) {
                    throw new NumericInstabilityException();
                }
            }

            @Override
            boolean checkPositionTransform() {
                return true;
            }
        }
        ,
        DEBUG("debug"){

            @Override
            void checkValue(double x) throws NumericInstabilityException {
                if (Double.isNaN(x)) {
                    System.err.println("Numerical instability in HMC momentum; throwing exception");
                    throw new NumericInstabilityException();
                }
            }

            @Override
            void checkPosition(Transform transform, double[] unTransformedPosition) throws NumericInstabilityException {
                if (!transform.isInInteriorDomain(unTransformedPosition, 0, unTransformedPosition.length)) {
                    System.err.println("Numerical instability in HMC momentum; throwing exception");
                    throw new NumericInstabilityException();
                }
            }

            @Override
            boolean checkPositionTransform() {
                return true;
            }
        }
        ,
        IGNORE("ignore"){

            @Override
            void checkValue(double x) {
            }

            @Override
            void checkPosition(Transform transform, double[] unTransformedPosition) throws NumericInstabilityException {
            }

            @Override
            boolean checkPositionTransform() {
                return false;
            }
        };

        private final String name;

        private InstabilityHandler(String name) {
            this.name = name;
        }

        public static InstabilityHandler factory(String match) {
            InstabilityHandler[] instabilityHandlerArray = InstabilityHandler.values();
            int n = instabilityHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                InstabilityHandler type = instabilityHandlerArray[n2];
                if (match.equalsIgnoreCase(type.name)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        abstract void checkValue(double var1) throws NumericInstabilityException;

        abstract void checkPosition(Transform var1, double[] var2) throws NumericInstabilityException;

        abstract boolean checkPositionTransform();
    }

    static interface LeapFrogEngine {
        public double[] getInitialPosition();

        public double getParameterLogJacobian();

        public void updateMomentum(double[] var1, double[] var2, double[] var3, double var4) throws NumericInstabilityException;

        public void updatePosition(double[] var1, WrappedVector var2, double var3) throws NumericInstabilityException;

        public void setParameter(double[] var1);

        public double[] getLastGradient();

        public double[] getLastPosition();

        public void projectMomentum(double[] var1, double[] var2);

        public void updateMask();

        public static class Default
        implements LeapFrogEngine {
            protected final Parameter parameter;
            final InstabilityHandler instabilityHandler;
            private final MassPreconditioner preconditioning;
            final double[] mask;
            double[] lastGradient;
            double[] lastPosition;

            Default(Parameter parameter, InstabilityHandler instabilityHandler, MassPreconditioner preconditioning, double[] mask) {
                this.parameter = parameter;
                this.instabilityHandler = instabilityHandler;
                this.preconditioning = preconditioning;
                this.mask = mask;
            }

            @Override
            public double[] getInitialPosition() {
                return this.parameter.getParameterValues();
            }

            @Override
            public double getParameterLogJacobian() {
                return 0.0;
            }

            @Override
            public double[] getLastGradient() {
                return this.lastGradient;
            }

            @Override
            public double[] getLastPosition() {
                return this.lastPosition;
            }

            @Override
            public void projectMomentum(double[] momentum, double[] position) {
            }

            @Override
            public void updateMask() {
            }

            @Override
            public void updateMomentum(double[] position, double[] momentum, double[] gradient, double functionalStepSize) throws NumericInstabilityException {
                int dim = momentum.length;
                int i = 0;
                while (i < dim) {
                    int n = i;
                    momentum[n] = momentum[n] + functionalStepSize * gradient[i];
                    this.instabilityHandler.checkValue(momentum[i]);
                    ++i;
                }
                this.lastGradient = gradient;
                this.lastPosition = position;
            }

            @Override
            public void updatePosition(double[] position, WrappedVector momentum, double functionalStepSize) throws NumericInstabilityException {
                int dim = momentum.getDim();
                int i = 0;
                while (i < dim) {
                    int n = i;
                    position[n] = position[n] + functionalStepSize * this.preconditioning.getVelocity(i, (ReadableVector)momentum);
                    this.instabilityHandler.checkValue(position[i]);
                    ++i;
                }
                this.setParameter(position);
            }

            @Override
            public void setParameter(double[] position) {
                ReadableVector.Utils.setParameter((double[])position, (Parameter)this.parameter);
            }
        }

        public static class WithTransform
        extends Default {
            protected final Transform transform;
            double[] unTransformedPosition;

            WithTransform(Parameter parameter, Transform transform, InstabilityHandler instabilityHandler, MassPreconditioner preconditioning, double[] mask) {
                super(parameter, instabilityHandler, preconditioning, mask);
                this.transform = transform;
            }

            @Override
            public double getParameterLogJacobian() {
                return this.transform.logJacobian(this.unTransformedPosition, 0, this.unTransformedPosition.length);
            }

            @Override
            public double[] getInitialPosition() {
                this.unTransformedPosition = super.getInitialPosition();
                return this.transform.transform(this.unTransformedPosition, 0, this.unTransformedPosition.length);
            }

            @Override
            public void updateMomentum(double[] position, double[] momentum, double[] gradient, double functionalStepSize) throws NumericInstabilityException {
                gradient = this.transform.updateGradientLogDensity(gradient, this.unTransformedPosition, 0, this.unTransformedPosition.length);
                HamiltonianMonteCarloOperator.mask(gradient, this.mask);
                super.updateMomentum(position, momentum, gradient, functionalStepSize);
            }

            @Override
            public void updatePosition(double[] position, WrappedVector momentum, double functionalStepSize) throws NumericInstabilityException {
                super.updatePosition(position, momentum, functionalStepSize);
                if (this.instabilityHandler.checkPositionTransform()) {
                    this.checkPosition(this.unTransformedPosition);
                }
            }

            @Override
            public void setParameter(double[] position) {
                this.unTransformedPosition = this.transform.inverse(position, 0, position.length);
                super.setParameter(this.unTransformedPosition);
            }

            private void checkPosition(double[] unTransformedPosition) throws NumericInstabilityException {
                this.instabilityHandler.checkPosition(this.transform, unTransformedPosition);
            }
        }
    }

    public static class NumericInstabilityException
    extends Exception {
    }

    public static class Options
    implements MassPreconditioningOptions {
        final double initialStepSize;
        final int nSteps;
        final double randomStepCountFraction;
        final int gradientCheckCount;
        final MassPreconditioningOptions preconditioningOptions;
        final double gradientCheckTolerance;
        final int checkStepSizeMaxIterations;
        final double checkStepSizeReductionFactor;
        final double targetAcceptanceProbability;
        final InstabilityHandler instabilityHandler;

        public Options(double initialStepSize, int nSteps, double randomStepCountFraction, MassPreconditioningOptions preconditioningOptions, int gradientCheckCount, double gradientCheckTolerance, int checkStepSizeMaxIterations, double checkStepSizeReductionFactor, double targetAcceptanceProbability, InstabilityHandler instabilityHandler) {
            this.initialStepSize = initialStepSize;
            this.nSteps = nSteps;
            this.randomStepCountFraction = randomStepCountFraction;
            this.gradientCheckCount = gradientCheckCount;
            this.gradientCheckTolerance = gradientCheckTolerance;
            this.checkStepSizeMaxIterations = checkStepSizeMaxIterations;
            this.checkStepSizeReductionFactor = checkStepSizeReductionFactor;
            this.targetAcceptanceProbability = targetAcceptanceProbability;
            this.instabilityHandler = instabilityHandler;
            this.preconditioningOptions = preconditioningOptions;
        }

        @Override
        public int preconditioningUpdateFrequency() {
            return this.preconditioningOptions.preconditioningUpdateFrequency();
        }

        @Override
        public int preconditioningDelay() {
            return this.preconditioningOptions.preconditioningDelay();
        }

        @Override
        public int preconditioningMaxUpdate() {
            return this.preconditioningOptions.preconditioningMaxUpdate();
        }

        @Override
        public int preconditioningMemory() {
            return this.preconditioningOptions.preconditioningMemory();
        }

        @Override
        public Parameter preconditioningEigenLowerBound() {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        public Parameter preconditioningEigenUpperBound() {
            throw new RuntimeException("Not yet implemented.");
        }
    }
}

