/*
 * Decompiled with CFR 0.152.
 */
package jd2.datatypes.sa;

import ec.satoolkit.ISaSpecification;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.utilities.NameManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jd2.datatypes.Ts;
import jd2.datatypes.sa.EstimationPolicyType;
import jd2.datatypes.sa.SaManager;
import lombok.Generated;
import lombok.NonNull;

public final class SaItemType {
    public static final String DOMAIN_SPEC = "domainspec";
    public static final String ESTIMATION_SPEC = "estimationspec";
    public static final String POINT_SPEC = "pointspec";
    public static final String TS = "ts";
    public static final String QUALITY = "quality";
    public static final String PRIORITY = "priority";
    public static final String POLICY = "policy";
    public static final String METADATA = "metadata";
    public static final String NAME = "name";
    public static final String COMMENT = "comment";
    public static final String DIAGNOSTICS = "diagnostics";
    private static final String[] EMPTY = new String[0];
    private static final String NONAME = "";
    @NonNull
    private final Ts ts;
    private final ISaSpecification pointSpec;
    private final ISaSpecification estimationSpec;
    @NonNull
    private final ISaSpecification domainSpec;
    @NonNull
    private final EstimationPolicyType estimationPolicy;
    @NonNull
    private final Status status;
    private final int priority;
    @NonNull
    private final ProcQuality quality;
    @NonNull
    private final String[] warnings;
    @NonNull
    private final String name;
    private final Map<String, String> metaData;

    public static Builder builder() {
        return new Builder().estimationPolicy(EstimationPolicyType.None).status(Status.Unprocessed).quality(ProcQuality.Undefined).warnings(EMPTY).name(NONAME);
    }

    static SaItemType read(InformationSet info, NameManager<ISaSpecification> defaults, HashMap<String, String> equivalence) {
        String name;
        InformationSet md;
        String e;
        String q;
        Integer p;
        InformationSet espec;
        Builder builder = SaItemType.builder();
        Ts s = (Ts)info.get(TS, Ts.class);
        if (s == null) {
            return null;
        }
        builder.ts(s);
        String dname = (String)info.get(DOMAIN_SPEC, String.class);
        if (dname == null) {
            return null;
        }
        ISaSpecification dspec = (ISaSpecification)defaults.get(dname);
        if (dspec == null) {
            String ename = equivalence.get(dname);
            if (ename != null) {
                dspec = (ISaSpecification)defaults.get(ename);
            }
            if (dspec == null) {
                return null;
            }
        }
        builder.domainSpec(dspec);
        InformationSet pspec = info.getSubSet(POINT_SPEC);
        if (pspec != null) {
            builder.pointSpec(SaManager.createSpecification(pspec));
        }
        if ((espec = info.getSubSet(ESTIMATION_SPEC)) != null) {
            builder.estimationSpec(SaManager.createSpecification(espec));
        }
        if ((p = (Integer)info.get(PRIORITY, Integer.class)) != null) {
            builder.priority(p);
        }
        if ((q = (String)info.get(QUALITY, String.class)) != null) {
            builder.quality(ProcQuality.valueOf((String)q));
        }
        if ((e = (String)info.get(POLICY, String.class)) != null) {
            builder.estimationPolicy(EstimationPolicyType.valueOf(e));
        }
        if ((md = info.getSubSet(METADATA)) != null) {
            List sel = md.deepSelect(String.class);
            for (Information sinfo : sel) {
                builder.meta(sinfo.name, (String)sinfo.value);
            }
        }
        if ((name = (String)info.get(NAME, String.class)) != null) {
            builder.name(name);
        }
        return builder.build();
    }

    boolean write(InformationSet info, NameManager<ISaSpecification> defaults, boolean verbose) {
        if (!this.name.isEmpty()) {
            info.set(NAME, (Object)this.name);
        }
        info.set(TS, (Object)this.ts);
        String dname = defaults.get((Object)this.domainSpec);
        if (dname == null) {
            dname = defaults.nextName();
            defaults.set(dname, (Object)this.domainSpec);
        }
        info.set(DOMAIN_SPEC, (Object)dname);
        if (this.pointSpec != null) {
            info.set(POINT_SPEC, (Object)this.pointSpec.write(verbose));
        }
        if (this.estimationSpec != null) {
            info.set(ESTIMATION_SPEC, (Object)this.estimationSpec.write(verbose));
        }
        if (this.priority >= 0 || verbose) {
            info.set(PRIORITY, (Object)this.priority);
        }
        if (this.quality != ProcQuality.Undefined || verbose) {
            info.set(QUALITY, (Object)this.quality.name());
        }
        if (this.estimationPolicy != EstimationPolicyType.None) {
            info.set(POLICY, (Object)this.estimationPolicy.name());
        }
        if (!this.metaData.isEmpty()) {
            InformationSet minfo = info.subSet(METADATA);
            for (Map.Entry<String, String> entry : this.metaData.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                minfo.set(entry.getKey(), (Object)entry.getValue());
            }
        }
        return true;
    }

    @Generated
    private static int $default$priority() {
        return -1;
    }

    @Generated
    SaItemType(@NonNull Ts ts, ISaSpecification pointSpec, ISaSpecification estimationSpec, @NonNull ISaSpecification domainSpec, @NonNull EstimationPolicyType estimationPolicy, @NonNull Status status, int priority, @NonNull ProcQuality quality, @NonNull String[] warnings, @NonNull String name, Map<String, String> metaData) {
        if (ts == null) {
            throw new NullPointerException("ts is marked non-null but is null");
        }
        if (domainSpec == null) {
            throw new NullPointerException("domainSpec is marked non-null but is null");
        }
        if (estimationPolicy == null) {
            throw new NullPointerException("estimationPolicy is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        if (quality == null) {
            throw new NullPointerException("quality is marked non-null but is null");
        }
        if (warnings == null) {
            throw new NullPointerException("warnings is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.ts = ts;
        this.pointSpec = pointSpec;
        this.estimationSpec = estimationSpec;
        this.domainSpec = domainSpec;
        this.estimationPolicy = estimationPolicy;
        this.status = status;
        this.priority = priority;
        this.quality = quality;
        this.warnings = warnings;
        this.name = name;
        this.metaData = metaData;
    }

    @Generated
    public Builder toBuilder() {
        Builder builder = new Builder().ts(this.ts).pointSpec(this.pointSpec).estimationSpec(this.estimationSpec).domainSpec(this.domainSpec).estimationPolicy(this.estimationPolicy).status(this.status).priority(this.priority).quality(this.quality).warnings(this.warnings).name(this.name);
        if (this.metaData != null) {
            builder.metaData(this.metaData);
        }
        return builder;
    }

    @NonNull
    @Generated
    public Ts getTs() {
        return this.ts;
    }

    @Generated
    public ISaSpecification getPointSpec() {
        return this.pointSpec;
    }

    @Generated
    public ISaSpecification getEstimationSpec() {
        return this.estimationSpec;
    }

    @NonNull
    @Generated
    public ISaSpecification getDomainSpec() {
        return this.domainSpec;
    }

    @NonNull
    @Generated
    public EstimationPolicyType getEstimationPolicy() {
        return this.estimationPolicy;
    }

    @NonNull
    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @NonNull
    @Generated
    public ProcQuality getQuality() {
        return this.quality;
    }

    @NonNull
    @Generated
    public String[] getWarnings() {
        return this.warnings;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaItemType)) {
            return false;
        }
        SaItemType other = (SaItemType)o;
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        Ts this$ts = this.getTs();
        Ts other$ts = other.getTs();
        if (this$ts == null ? other$ts != null : !((Object)this$ts).equals(other$ts)) {
            return false;
        }
        ISaSpecification this$pointSpec = this.getPointSpec();
        ISaSpecification other$pointSpec = other.getPointSpec();
        if (this$pointSpec == null ? other$pointSpec != null : !this$pointSpec.equals(other$pointSpec)) {
            return false;
        }
        ISaSpecification this$estimationSpec = this.getEstimationSpec();
        ISaSpecification other$estimationSpec = other.getEstimationSpec();
        if (this$estimationSpec == null ? other$estimationSpec != null : !this$estimationSpec.equals(other$estimationSpec)) {
            return false;
        }
        ISaSpecification this$domainSpec = this.getDomainSpec();
        ISaSpecification other$domainSpec = other.getDomainSpec();
        if (this$domainSpec == null ? other$domainSpec != null : !this$domainSpec.equals(other$domainSpec)) {
            return false;
        }
        EstimationPolicyType this$estimationPolicy = this.getEstimationPolicy();
        EstimationPolicyType other$estimationPolicy = other.getEstimationPolicy();
        if (this$estimationPolicy == null ? other$estimationPolicy != null : !((Object)((Object)this$estimationPolicy)).equals((Object)other$estimationPolicy)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ProcQuality this$quality = this.getQuality();
        ProcQuality other$quality = other.getQuality();
        if (this$quality == null ? other$quality != null : !this$quality.equals(other$quality)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getWarnings(), other.getWarnings())) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$metaData = this.getMetaData();
        Map<String, String> other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        Ts $ts = this.getTs();
        result = result * 59 + ($ts == null ? 43 : ((Object)$ts).hashCode());
        ISaSpecification $pointSpec = this.getPointSpec();
        result = result * 59 + ($pointSpec == null ? 43 : $pointSpec.hashCode());
        ISaSpecification $estimationSpec = this.getEstimationSpec();
        result = result * 59 + ($estimationSpec == null ? 43 : $estimationSpec.hashCode());
        ISaSpecification $domainSpec = this.getDomainSpec();
        result = result * 59 + ($domainSpec == null ? 43 : $domainSpec.hashCode());
        EstimationPolicyType $estimationPolicy = this.getEstimationPolicy();
        result = result * 59 + ($estimationPolicy == null ? 43 : ((Object)((Object)$estimationPolicy)).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        ProcQuality $quality = this.getQuality();
        result = result * 59 + ($quality == null ? 43 : $quality.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getWarnings());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SaItemType(ts=" + this.getTs() + ", pointSpec=" + this.getPointSpec() + ", estimationSpec=" + this.getEstimationSpec() + ", domainSpec=" + this.getDomainSpec() + ", estimationPolicy=" + (Object)((Object)this.getEstimationPolicy()) + ", status=" + (Object)((Object)this.getStatus()) + ", priority=" + this.getPriority() + ", quality=" + this.getQuality() + ", warnings=" + Arrays.deepToString(this.getWarnings()) + ", name=" + this.getName() + ", metaData=" + this.getMetaData() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private Ts ts;
        @Generated
        private ISaSpecification pointSpec;
        @Generated
        private ISaSpecification estimationSpec;
        @Generated
        private ISaSpecification domainSpec;
        @Generated
        private EstimationPolicyType estimationPolicy;
        @Generated
        private Status status;
        @Generated
        private boolean priority$set;
        @Generated
        private int priority$value;
        @Generated
        private ProcQuality quality;
        @Generated
        private String[] warnings;
        @Generated
        private String name;
        @Generated
        private ArrayList<String> metaData$key;
        @Generated
        private ArrayList<String> metaData$value;

        @Generated
        Builder() {
        }

        @Generated
        public Builder ts(@NonNull Ts ts) {
            if (ts == null) {
                throw new NullPointerException("ts is marked non-null but is null");
            }
            this.ts = ts;
            return this;
        }

        @Generated
        public Builder pointSpec(ISaSpecification pointSpec) {
            this.pointSpec = pointSpec;
            return this;
        }

        @Generated
        public Builder estimationSpec(ISaSpecification estimationSpec) {
            this.estimationSpec = estimationSpec;
            return this;
        }

        @Generated
        public Builder domainSpec(@NonNull ISaSpecification domainSpec) {
            if (domainSpec == null) {
                throw new NullPointerException("domainSpec is marked non-null but is null");
            }
            this.domainSpec = domainSpec;
            return this;
        }

        @Generated
        public Builder estimationPolicy(@NonNull EstimationPolicyType estimationPolicy) {
            if (estimationPolicy == null) {
                throw new NullPointerException("estimationPolicy is marked non-null but is null");
            }
            this.estimationPolicy = estimationPolicy;
            return this;
        }

        @Generated
        public Builder status(@NonNull Status status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
            return this;
        }

        @Generated
        public Builder priority(int priority) {
            this.priority$value = priority;
            this.priority$set = true;
            return this;
        }

        @Generated
        public Builder quality(@NonNull ProcQuality quality) {
            if (quality == null) {
                throw new NullPointerException("quality is marked non-null but is null");
            }
            this.quality = quality;
            return this;
        }

        @Generated
        public Builder warnings(@NonNull String[] warnings) {
            if (warnings == null) {
                throw new NullPointerException("warnings is marked non-null but is null");
            }
            this.warnings = warnings;
            return this;
        }

        @Generated
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public Builder meta(String metaKey, String metaValue) {
            if (this.metaData$key == null) {
                this.metaData$key = new ArrayList();
                this.metaData$value = new ArrayList();
            }
            this.metaData$key.add(metaKey);
            this.metaData$value.add(metaValue);
            return this;
        }

        @Generated
        public Builder metaData(Map<? extends String, ? extends String> metaData) {
            if (metaData == null) {
                throw new NullPointerException("metaData cannot be null");
            }
            if (this.metaData$key == null) {
                this.metaData$key = new ArrayList();
                this.metaData$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : metaData.entrySet()) {
                this.metaData$key.add($lombokEntry.getKey());
                this.metaData$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearMetaData() {
            if (this.metaData$key != null) {
                this.metaData$key.clear();
                this.metaData$value.clear();
            }
            return this;
        }

        @Generated
        public SaItemType build() {
            Map<Object, Object> metaData;
            switch (this.metaData$key == null ? 0 : this.metaData$key.size()) {
                case 0: {
                    metaData = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metaData = Collections.singletonMap(this.metaData$key.get(0), this.metaData$value.get(0));
                    break;
                }
                default: {
                    metaData = new LinkedHashMap(this.metaData$key.size() < 0x40000000 ? 1 + this.metaData$key.size() + (this.metaData$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metaData$key.size(); ++$i) {
                        metaData.put(this.metaData$key.get($i), this.metaData$value.get($i));
                    }
                    metaData = Collections.unmodifiableMap(metaData);
                }
            }
            int priority$value = this.priority$value;
            if (!this.priority$set) {
                priority$value = SaItemType.$default$priority();
            }
            return new SaItemType(this.ts, this.pointSpec, this.estimationSpec, this.domainSpec, this.estimationPolicy, this.status, priority$value, this.quality, this.warnings, this.name, metaData);
        }

        @Generated
        public String toString() {
            return "SaItemType.Builder(ts=" + this.ts + ", pointSpec=" + this.pointSpec + ", estimationSpec=" + this.estimationSpec + ", domainSpec=" + this.domainSpec + ", estimationPolicy=" + (Object)((Object)this.estimationPolicy) + ", status=" + (Object)((Object)this.status) + ", priority$value=" + this.priority$value + ", quality=" + this.quality + ", warnings=" + Arrays.deepToString(this.warnings) + ", name=" + this.name + ", metaData$key=" + this.metaData$key + ", metaData$value=" + this.metaData$value + ")";
        }
    }

    public static enum Status {
        Unprocessed,
        NoSpec,
        NoData,
        Pending,
        Valid,
        Invalid;


        public boolean isError() {
            return this.isProcessed() && this != Valid;
        }

        public boolean isProcessed() {
            return this != Unprocessed && this != Pending;
        }
    }
}

