/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.binarray;

import java.util.StringTokenizer;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.binarray.BinArrayIndividual;
import net.sourceforge.jclec.binarray.BinArraySpecies;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public final class BinArrayIndividualSpecies
extends BinArraySpecies
implements IConfigure {
    private static final long serialVersionUID = 1849608890559693424L;

    public BinArrayIndividualSpecies() {
    }

    public BinArrayIndividualSpecies(byte[] genotypeSchema) {
        this.setGenotypeSchema(genotypeSchema);
    }

    public void setGenotypeSchema(byte[] genotypeSchema) {
        this.genotypeSchema = genotypeSchema;
    }

    @Override
    public BinArrayIndividual createIndividual(byte[] genotype) {
        return new BinArrayIndividual(genotype);
    }

    @Override
    public void configure(Configuration configuration) {
        byte[] genotypeSchema;
        int genotypeLength = configuration.getInt("[@genotype-length]", 0);
        if (genotypeLength == 0) {
            String genotypeSchemaString = configuration.getString("genotype-schema");
            StringTokenizer st = new StringTokenizer(genotypeSchemaString);
            int gl = st.countTokens();
            genotypeSchema = new byte[gl];
            int i = 0;
            while (i < gl) {
                String nt = st.nextToken();
                genotypeSchema[i] = nt.equals("*") ? -1 : Byte.parseByte(nt);
                ++i;
            }
        } else {
            genotypeSchema = new byte[genotypeLength];
            int i = 0;
            while (i < genotypeLength) {
                genotypeSchema[i] = -1;
                ++i;
            }
        }
        this.setGenotypeSchema(genotypeSchema);
    }

    public boolean equals(Object other) {
        if (other instanceof BinArrayIndividualSpecies) {
            EqualsBuilder eb = new EqualsBuilder();
            BinArrayIndividualSpecies baoth = (BinArrayIndividualSpecies)other;
            eb.append(this.genotypeSchema, baoth.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

