/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.SSMAPSO;

import java.util.Arrays;
import keel.Algorithms.Preprocess.Basic.KNN;
import org.core.Randomize;

public class Cromosoma
implements Comparable {
    boolean[] cuerpo;
    int[][] vecinos;
    double fitness;
    double fitnessAc;
    boolean evaluado;
    boolean valido;

    public Cromosoma(int K, int size, double[][] dMatrix, double[][] datos, double[][] real, int[][] nominal, boolean[][] nulo, boolean distanceEu) {
        int i;
        this.cuerpo = new boolean[size];
        this.vecinos = new int[size][K];
        for (i = 0; i < size; ++i) {
            double u = Randomize.Rand();
            this.cuerpo[i] = !(u < 0.5);
        }
        this.evaluado = false;
        this.valido = true;
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < K; ++j) {
                this.vecinos[i][j] = this.obtenerCercano(this.vecinos[i], j, dMatrix, i, datos, real, nominal, nulo, distanceEu);
            }
        }
    }

    public Cromosoma(int K, int size, Cromosoma a) {
        this.cuerpo = new boolean[size];
        this.vecinos = new int[size][K];
        for (int i = 0; i < this.cuerpo.length; ++i) {
            this.cuerpo[i] = a.getGen(i);
            for (int j = 0; j < K; ++j) {
                this.vecinos[i][j] = a.getVecino(i, j);
            }
        }
        this.fitness = a.getFitness();
        this.fitnessAc = a.getFitnessAc();
        this.evaluado = true;
        this.valido = true;
    }

    public Cromosoma(int K, Cromosoma a, Cromosoma b, double pCross, int size) {
        this.cuerpo = new boolean[size];
        this.vecinos = new int[size][K];
        for (int i = 0; i < this.cuerpo.length; ++i) {
            this.cuerpo[i] = Randomize.Rand() < pCross ? b.getGen(i) : a.getGen(i);
        }
        this.evaluado = false;
        this.valido = true;
    }

    public void mutation(int K, double pMut, double[][] dMatrix, double[][] datos, double[][] real, int[][] nominal, boolean[][] nulo, boolean distanceEu) {
        int i;
        for (i = 0; i < this.cuerpo.length; ++i) {
            if (!(Randomize.Rand() < pMut)) continue;
            this.cuerpo[i] = !this.cuerpo[i];
        }
        for (i = 0; i < this.cuerpo.length; ++i) {
            for (int j = 0; j < K; ++j) {
                this.vecinos[i][j] = this.obtenerCercano(this.vecinos[i], j, dMatrix, i, datos, real, nominal, nulo, distanceEu);
            }
        }
    }

    public int obtenerCercano(int[] vecinos, int J, double[][] dMatrix, int index, double[][] datos, double[][] real, int[][] nominal, boolean[][] nulo, boolean distanceEu) {
        int minPos;
        if (dMatrix == null) {
            int j;
            boolean cont;
            boolean perfect = false;
            int i = 0;
            while (true) {
                if (i < this.cuerpo.length && !this.cuerpo[i]) {
                    ++i;
                    continue;
                }
                cont = true;
                for (j = 0; j < J && cont; ++j) {
                    if (vecinos[j] != i) continue;
                    cont = false;
                    ++i;
                }
                perfect = cont;
                if (perfect) break;
            }
            minPos = i;
            if (minPos == this.cuerpo.length) {
                return 0;
            }
            double minDist = KNN.distancia((double[])datos[index], (double[])real[index], (int[])nominal[index], (boolean[])nulo[index], (double[])datos[minPos], (double[])real[minPos], (int[])nominal[minPos], (boolean[])nulo[minPos], (boolean)distanceEu);
            for (i = minPos + 1; i < this.cuerpo.length; ++i) {
                double dist;
                if (!this.cuerpo[i]) continue;
                cont = true;
                for (j = 0; j < J && cont; ++j) {
                    if (vecinos[j] != i) continue;
                    cont = false;
                }
                if (!cont || !(minDist > (dist = KNN.distancia((double[])datos[index], (double[])real[index], (int[])nominal[index], (boolean[])nulo[index], (double[])datos[i], (double[])real[i], (int[])nominal[i], (boolean[])nulo[i], (boolean)distanceEu)))) continue;
                minPos = i;
                minDist = dist;
            }
        } else {
            int j;
            boolean cont;
            boolean perfect = false;
            int i = 0;
            while (true) {
                if (i < this.cuerpo.length && !this.cuerpo[i]) {
                    ++i;
                    continue;
                }
                cont = true;
                for (j = 0; j < J && cont; ++j) {
                    if (vecinos[j] != i) continue;
                    cont = false;
                    ++i;
                }
                perfect = cont;
                if (perfect) break;
            }
            minPos = i;
            if (minPos == this.cuerpo.length) {
                return 0;
            }
            double minDist = dMatrix[index][minPos];
            for (i = minPos + 1; i < this.cuerpo.length; ++i) {
                if (!this.cuerpo[i]) continue;
                cont = true;
                for (j = 0; j < J && cont; ++j) {
                    if (vecinos[j] != i) continue;
                    cont = false;
                }
                if (!cont || !(minDist > dMatrix[index][i])) continue;
                minPos = i;
                minDist = dMatrix[index][i];
            }
        }
        return minPos;
    }

    public boolean getGen(int indice) {
        return this.cuerpo[indice];
    }

    public int getVecino(int indicei, int indicej) {
        return this.vecinos[indicei][indicej];
    }

    public double getFitness() {
        return this.fitness;
    }

    public double getFitnessAc() {
        return this.fitnessAc;
    }

    public void evaluacionCompleta(int nClases, int K, int[] clases) {
        double contador = 0.0;
        int maxPos = 0;
        int[] votos = new int[nClases];
        for (int i = 0; i < this.vecinos.length; ++i) {
            int j;
            Arrays.fill(votos, 0);
            for (j = 0; j < K; ++j) {
                int n = clases[this.vecinos[i][j]];
                votos[n] = votos[n] + 1;
            }
            int maxValue = votos[0];
            maxPos = 0;
            for (j = 1; j < nClases; ++j) {
                if (votos[j] <= maxValue) continue;
                maxValue = votos[j];
                maxPos = j;
            }
            if (clases[i] != maxPos) continue;
            contador += 1.0;
        }
        this.fitness = contador * 50.0 / (double)this.cuerpo.length + ((double)this.cuerpo.length - (double)this.genesActivos()) / (double)this.cuerpo.length * 50.0;
        this.fitnessAc = contador;
        this.evaluado = true;
    }

    public void borrar() {
        this.valido = false;
    }

    public boolean esValido() {
        return this.valido;
    }

    public void setGen(int pos, boolean valor) {
        this.cuerpo[pos] = valor;
    }

    public boolean estaEvaluado() {
        return this.evaluado;
    }

    public int genesActivos() {
        int suma = 0;
        for (int i = 0; i < this.cuerpo.length; ++i) {
            if (!this.cuerpo[i]) continue;
            ++suma;
        }
        return suma;
    }

    public double optimizacionLocal(int nClases, int K, int[] clases, double[][] dMatrix, double umbral, double[][] datos, double[][] real, int[][] nominal, boolean[][] nulo, boolean distanceEu) {
        int tmp;
        int pos;
        int j;
        double evaluaciones = 0.0;
        int n = this.genesActivos();
        int[] visitas = new int[n];
        int k = 0;
        for (j = 0; j < this.cuerpo.length; ++j) {
            if (!this.cuerpo[j]) continue;
            visitas[k] = j;
            ++k;
        }
        for (j = 0; j < visitas.length; ++j) {
            pos = Randomize.Randint(j, visitas.length - 1);
            tmp = visitas[j];
            visitas[j] = visitas[pos];
            visitas[pos] = tmp;
        }
        int i = 0;
        while (i < n) {
            double ev = this.evaluacionParcial(nClases, K, clases, visitas[i], dMatrix, umbral, datos, real, nominal, nulo, distanceEu);
            if (ev >= 0.0) {
                i = 0;
                visitas = new int[--n];
                try {
                    k = 0;
                    for (j = 0; j < this.cuerpo.length; ++j) {
                        if (!this.cuerpo[j]) continue;
                        visitas[k] = j;
                        ++k;
                    }
                }
                catch (Exception e) {
                    i = n;
                }
                for (j = 0; j < visitas.length; ++j) {
                    pos = Randomize.Randint(j, visitas.length - 1);
                    tmp = visitas[j];
                    visitas[j] = visitas[pos];
                    visitas[pos] = tmp;
                }
            } else {
                ++i;
            }
            evaluaciones += Math.abs(ev);
        }
        return evaluaciones;
    }

    public double evaluacionParcial(int nClases, int K, int[] clases, int ref, double[][] dMatrix, double umbral, double[][] datos, double[][] real, int[][] nominal, boolean[][] nulo, boolean distanceEu) {
        int j;
        int i;
        double ganancia = 0.0;
        int contador = 0;
        int maxPosAnterior = 0;
        int maxPosNuevo = 0;
        int[] votos = new int[nClases];
        int[][] vecinosTemp = new int[this.cuerpo.length][K];
        this.cuerpo[ref] = false;
        for (i = 0; i < this.cuerpo.length; ++i) {
            boolean evaluar = false;
            for (j = 0; j < K; ++j) {
                if (this.vecinos[i][j] == ref) {
                    evaluar = true;
                    vecinosTemp[i][j] = this.obtenerCercano(vecinosTemp[i], j, dMatrix, i, datos, real, nominal, nulo, distanceEu);
                    continue;
                }
                vecinosTemp[i][j] = this.vecinos[i][j];
            }
            if (!evaluar) continue;
            ++contador;
            Arrays.fill(votos, 0);
            for (j = 0; j < K; ++j) {
                int n = clases[this.vecinos[i][j]];
                votos[n] = votos[n] + 1;
            }
            int maxValue = votos[0];
            maxPosAnterior = 0;
            for (j = 1; j < nClases; ++j) {
                if (votos[j] <= maxValue) continue;
                maxValue = votos[j];
                maxPosAnterior = j;
            }
            Arrays.fill(votos, 0);
            for (j = 0; j < K; ++j) {
                int n = clases[vecinosTemp[i][j]];
                votos[n] = votos[n] + 1;
            }
            maxValue = votos[0];
            maxPosNuevo = 0;
            for (j = 1; j < nClases; ++j) {
                if (votos[j] <= maxValue) continue;
                maxValue = votos[j];
                maxPosNuevo = j;
            }
            if (clases[i] == maxPosAnterior && clases[i] != maxPosNuevo) {
                ganancia -= 1.0;
                continue;
            }
            if (clases[i] == maxPosAnterior || clases[i] != maxPosNuevo) continue;
            ganancia += 1.0;
        }
        if ((double)Math.round(ganancia) >= umbral) {
            for (i = 0; i < this.cuerpo.length; ++i) {
                for (j = 0; j < K; ++j) {
                    this.vecinos[i][j] = vecinosTemp[i][j];
                }
            }
            this.fitness += ganancia * 50.0 / (double)this.cuerpo.length + 1.0 / (double)this.cuerpo.length * 50.0;
            this.fitnessAc += ganancia;
            return (double)contador / (double)this.cuerpo.length;
        }
        this.cuerpo[ref] = true;
        return (double)contador / (double)this.cuerpo.length * -1.0;
    }

    public int compareTo(Object o1) {
        double valor1 = this.fitness;
        double valor2 = ((Cromosoma)o1).fitness;
        if (valor1 > valor2) {
            return -1;
        }
        if (valor1 < valor2) {
            return 1;
        }
        return 0;
    }

    public int differenceAtOne(Cromosoma a) {
        int cont = 0;
        int pos = -1;
        for (int i = 0; i < this.cuerpo.length && cont < 2; ++i) {
            if (this.cuerpo[i] == a.getGen(i)) continue;
            pos = i;
            ++cont;
        }
        if (cont >= 2) {
            return -1;
        }
        return pos;
    }

    public String toString() {
        String temp = "[";
        for (int i = 0; i < this.cuerpo.length; ++i) {
            temp = this.cuerpo[i] ? temp + "1" : temp + "0";
        }
        temp = temp + ", " + String.valueOf(this.fitness) + ", " + String.valueOf(this.genesActivos()) + "]";
        return temp;
    }
}

