/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.PDFCS;

import keel.Algorithms.SVM.SMO.SMO;
import keel.Algorithms.SVM.SMO.core.Instance;
import keel.Algorithms.SVM.SMO.core.Instances;
import keel.Algorithms.SVM.SMO.supportVector.Kernel;
import keel.Algorithms.SVM.SMO.supportVector.PDRFKernel;

public class FuzzyRuleSet {
    protected double m_b0;
    protected double[][] m_z;
    protected double[] m_b;
    protected Kernel m_kernel;
    protected int m_rules;

    public FuzzyRuleSet(SMO.BinarySMO smo, Instances data, Kernel kern) {
        int i;
        double[] lagrange = smo.getLagrangeMultipliers();
        double[][] temp_z = new double[data.numInstances()][];
        double[] temp_b = new double[data.numInstances()];
        int j = 0;
        for (i = 0; i < lagrange.length; ++i) {
            if (!(lagrange[i] > 0.0)) continue;
            double[] temp_values = new double[data.numAttributes() - 1];
            int l = 0;
            for (int k = 0; k < data.instance(i).toDoubleArray().length; ++k) {
                if (k == data.instance(i).classIndex()) continue;
                temp_values[l] = data.instance(i).toDoubleArray()[k];
                ++l;
            }
            temp_z[j] = temp_values;
            temp_b[j] = lagrange[i] * smo.getClasses()[i];
            ++j;
        }
        this.m_b0 = -smo.getB();
        this.m_b = new double[j];
        this.m_z = new double[j][];
        for (i = 0; i < j; ++i) {
            this.m_b[i] = temp_b[i];
            this.m_z[i] = temp_z[i];
        }
        this.m_rules = j;
        this.m_kernel = kern;
    }

    public double unthresholdedOutput(Instance inst) {
        double[] u = new double[inst.numAttributes() - 1];
        PDRFKernel pdrf = (PDRFKernel)this.m_kernel;
        double nume = this.m_b0;
        double denom = 1.0;
        for (int i = 0; i < this.m_b.length; ++i) {
            int l = 0;
            for (int j = 0; j < inst.numAttributes(); ++j) {
                if (j == inst.classIndex()) continue;
                u[l] = inst.value(j) - this.m_z[i][l];
                ++l;
            }
            nume += this.m_b[i] * pdrf.evaluatePRDF(u);
            denom += pdrf.evaluatePRDF(u);
        }
        return nume / denom;
    }

    public int getNumRules() {
        return this.m_rules;
    }
}

