/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles;

import java.util.ArrayList;
import java.util.StringTokenizer;
import keel.Algorithms.ImbalancedClassification.Ensembles.Selector;
import keel.Algorithms.ImbalancedClassification.Ensembles.myDataset;

public class Rule {
    ArrayList<Selector> antecedent = new ArrayList();
    String clase;
    myDataset train;
    int[] coveredExamples;
    int[] positiveCoveredEx;
    int nCubiertos;
    int nCubiertosOK;
    float fCubiertos;
    float fCubiertosOK;
    double fitness;
    int codigoRule;

    public Rule() {
        this.coveredExamples = new int[1];
    }

    public Rule(String clase, myDataset train) {
        this.train = train;
        this.clase = clase;
        this.coveredExamples = new int[train.size()];
        this.positiveCoveredEx = new int[train.size()];
    }

    public Rule(myDataset train, String linea) {
        this.train = train;
        this.coveredExamples = new int[train.size()];
        this.positiveCoveredEx = new int[train.size()];
        String[] nombres = train.nombres();
        StringTokenizer campo = new StringTokenizer(linea, " ");
        campo.nextToken();
        String aux = campo.nextToken();
        while (!aux.equalsIgnoreCase("THEN")) {
            String atributo = campo.nextToken();
            String operador = campo.nextToken();
            String valor = campo.nextToken();
            Selector s = new Selector(atributo, operador, valor);
            s.adjuntaNombres(nombres);
            this.antecedent.add(s);
            aux = campo.nextToken();
        }
        campo.nextToken();
        campo.nextToken();
        this.clase = campo.nextToken();
    }

    public void incluyeSelector(Selector s) {
        this.antecedent.add(s);
    }

    public String printString() {
        String cadena = new String("");
        cadena = cadena + "IF ";
        for (int i = 0; i < this.antecedent.size() - 1; ++i) {
            cadena = cadena + this.antecedent.get(i).printString() + "AND ";
        }
        cadena = cadena + this.antecedent.get(this.antecedent.size() - 1).printString();
        cadena = cadena + " THEN Class = " + this.clase + " (" + this.nCubiertosOK + "/" + this.nCubiertos + ")\n";
        return cadena;
    }

    public String printStringF() {
        String cadena = new String("");
        cadena = cadena + "IF ";
        for (int i = 0; i < this.antecedent.size() - 1; ++i) {
            cadena = cadena + this.antecedent.get(i).printString() + "AND ";
        }
        if (this.antecedent.size() > 0) {
            cadena = cadena + this.antecedent.get(this.antecedent.size() - 1).printString();
        }
        cadena = cadena + " THEN Class = " + this.clase + " (" + this.fCubiertosOK + "/" + this.fCubiertos + ")\n";
        return cadena;
    }

    public Rule copy() {
        Rule r = new Rule(this.clase, this.train);
        r.antecedent = new ArrayList();
        for (int i = 0; i < this.antecedent.size(); ++i) {
            r.antecedent.add(this.antecedent.get(i).copy());
        }
        r.nCubiertos = this.nCubiertos;
        r.nCubiertosOK = this.nCubiertosOK;
        r.coveredExamples = new int[this.coveredExamples.length];
        r.coveredExamples = (int[])this.coveredExamples.clone();
        r.positiveCoveredEx = new int[this.positiveCoveredEx.length];
        r.positiveCoveredEx = (int[])this.positiveCoveredEx.clone();
        r.fitness = this.fitness;
        r.codigoRule = this.codigoRule;
        return r;
    }

    public int covered() {
        return this.nCubiertos;
    }

    public int positiveCovered() {
        return this.nCubiertosOK;
    }

    public void coverExamples() {
        this.nCubiertosOK = 0;
        this.nCubiertos = 0;
        for (int i = 0; i < this.train.size(); ++i) {
            double[] ejemplo = this.train.getExample(i);
            if (!this.covers(ejemplo)) continue;
            this.coveredExamples[this.nCubiertos] = i;
            ++this.nCubiertos;
            if (this.train.getOutputAsString(i).compareToIgnoreCase(this.clase) != 0) continue;
            this.positiveCoveredEx[this.nCubiertosOK] = i;
            ++this.nCubiertosOK;
        }
    }

    public void coverExamples(double[] weights) {
        this.fCubiertosOK = 0.0f;
        this.fCubiertos = 0.0f;
        for (int i = 0; i < this.train.size(); ++i) {
            double[] ejemplo = this.train.getExample(i);
            if (!this.covers(ejemplo)) continue;
            this.fCubiertos = (float)((double)this.fCubiertos + weights[i]);
            if (this.train.getOutputAsString(i).compareToIgnoreCase(this.clase) != 0) continue;
            this.fCubiertosOK = (float)((double)this.fCubiertosOK + weights[i]);
        }
        this.train = null;
        this.coveredExamples = null;
        this.positiveCoveredEx = null;
    }

    public boolean covers(double[] example) {
        boolean cubierto = true;
        for (int i = 0; i < this.antecedent.size() && cubierto; ++i) {
            cubierto = cubierto && this.antecedent.get(i).covers(example);
        }
        return cubierto;
    }

    public int size() {
        return this.antecedent.size();
    }

    public boolean contieneAtributo(int att) {
        boolean contiene = false;
        for (int i = 0; i < this.antecedent.size() && !contiene; ++i) {
            contiene = this.antecedent.get((int)i).attribute == att;
        }
        return contiene;
    }
}

