## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(densitr)

## -----------------------------------------------------------------------------
dp <- dpload(dp.file = system.file("extdata", "00010001.dpa", package = "densitr"))
dp

## -----------------------------------------------------------------------------
head(dp$data)

## -----------------------------------------------------------------------------
head(dp$footer)

## ---- fig.width=15, fig.height=5----------------------------------------------
plot(dp)

## ---- results = 'asis'--------------------------------------------------------
dp.list <- dpload(dp.directory = system.file("extdata", package = "densitr"))

## -----------------------------------------------------------------------------
head(dp.list, 2)

## -----------------------------------------------------------------------------
dpdetect_s(dp.list[[1]])

## ---- fig.width=15, fig.height=10---------------------------------------------
dpdetect_s(dp.list[[1]], return.plot = TRUE)

## -----------------------------------------------------------------------------
dpdetect_e(dp.list[[1]])

## -----------------------------------------------------------------------------
dptrim(dp.list[[1]])

## ---- fig.width=15, fig.height=5----------------------------------------------
dptrim(dp.list[[1]], return.plot = TRUE)

## -----------------------------------------------------------------------------
dp.trimmed  <- dptriml(dp.list)

