/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public interface IntVar
extends ICause,
Variable,
Iterable<Integer>,
ArExpression {
    public static final int MIN_INT_BOUND = -21474836;
    public static final int MAX_INT_BOUND = 21474836;
    public static final int LR_NE = 0;
    public static final int LR_EQ = 1;
    public static final int LR_GE = 2;
    public static final int LR_LE = 3;

    default public boolean removeValue(int value, ICause cause) throws ContradictionException {
        return this.removeValue(value, cause, cause.defaultReason(this));
    }

    public boolean removeValue(int var1, ICause var2, Reason var3) throws ContradictionException;

    default public boolean removeValue(long value, ICause cause) throws ContradictionException {
        if ((long)((int)value) != value) {
            return false;
        }
        return this.removeValue((int)value, cause);
    }

    default public boolean removeValues(IntIterableSet values, ICause cause, Reason reason) throws ContradictionException {
        int vub;
        int vlb;
        boolean fixpoint;
        if (!2.$assertionsDisabled && cause == null) {
            throw new AssertionError();
        }
        boolean hasChanged = false;
        do {
            int nlb = this.getLB();
            int nub = this.getUB();
            vlb = values.nextValue(nlb - 1);
            vub = values.previousValue(nub + 1);
            if (!(hasChanged || vlb <= nub && vub >= nlb)) {
                return false;
            }
            if (vlb == nlb) {
                do {
                    nlb = this.nextValue(nlb);
                    vlb = values.nextValue(nlb - 1);
                } while (nlb < Integer.MAX_VALUE && nub < Integer.MAX_VALUE && vlb == nlb);
            }
            if (vub == nub) {
                do {
                    nub = this.previousValue(nub);
                    vub = values.previousValue(nub + 1);
                } while (nlb > Integer.MIN_VALUE && nub > Integer.MIN_VALUE && vub == nub);
            }
            fixpoint = this.updateBounds(nlb, nub, cause, reason);
            hasChanged |= fixpoint;
        } while (fixpoint);
        if (this.hasEnumeratedDomain()) {
            int value = vlb;
            while (value <= vub) {
                hasChanged |= this.removeValue(value, cause, reason);
                value = values.nextValue(value);
            }
        }
        return hasChanged;
    }

    default public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        return this.removeValues(values, cause, cause.defaultReason(this));
    }

    default public boolean removeAllValuesBut(IntIterableSet values, ICause cause, Reason reason) throws ContradictionException {
        int nub;
        int nlb;
        boolean fixpoint;
        boolean hasChanged = false;
        do {
            int clb = this.getLB();
            int cub = this.getUB();
            nlb = values.nextValue(clb - 1);
            nub = values.previousValue(cub + 1);
            fixpoint = this.updateBounds(nlb, nub, cause, reason);
            hasChanged |= fixpoint;
        } while (fixpoint);
        int to = this.previousValue(nub);
        if (this.hasEnumeratedDomain()) {
            int value = this.nextValue(nlb);
            while (value <= to) {
                if (!values.contains(value)) {
                    hasChanged |= this.removeValue(value, cause, reason);
                }
                value = this.nextValue(value);
            }
        }
        return hasChanged;
    }

    default public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        return this.removeAllValuesBut(values, cause, cause.defaultReason(this));
    }

    default public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        if (!2.$assertionsDisabled && cause == null) {
            throw new AssertionError();
        }
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        if (this.hasEnumeratedDomain()) {
            boolean done = false;
            for (int v = from; v <= to; ++v) {
                done |= this.removeValue(v, cause);
            }
            return done;
        }
        return false;
    }

    default public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        return this.instantiateTo(value, cause, cause.defaultReason(this));
    }

    public boolean instantiateTo(int var1, ICause var2, Reason var3) throws ContradictionException;

    default public boolean instantiateTo(long value, ICause cause) throws ContradictionException {
        if ((long)((int)value) != value) {
            return this.instantiateTo(value < (long)this.getLB() ? this.getLB() - 1 : this.getUB() + 1, cause);
        }
        return this.instantiateTo((int)value, cause);
    }

    default public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        return this.updateLowerBound(value, cause, cause.defaultReason(this));
    }

    public boolean updateLowerBound(int var1, ICause var2, Reason var3) throws ContradictionException;

    default public boolean updateLowerBound(long value, ICause cause) throws ContradictionException {
        if ((long)((int)value) != value) {
            if (value < (long)this.getLB()) {
                return false;
            }
            return this.updateLowerBound(this.getUB() + 1, cause);
        }
        return this.updateLowerBound((int)value, cause);
    }

    default public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        return this.updateUpperBound(value, cause, cause.defaultReason(this));
    }

    public boolean updateUpperBound(int var1, ICause var2, Reason var3) throws ContradictionException;

    default public boolean updateUpperBound(long value, ICause cause) throws ContradictionException {
        if ((long)((int)value) != value) {
            if (value > (long)this.getUB()) {
                return false;
            }
            return this.updateUpperBound(this.getLB() - 1, cause);
        }
        return this.updateUpperBound((int)value, cause);
    }

    default public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        return this.updateBounds(lb, ub, cause, cause.defaultReason(this));
    }

    default public boolean updateBounds(int lb, int ub, ICause cause, Reason reason) throws ContradictionException {
        return this.updateLowerBound(lb, cause, reason) | this.updateUpperBound(ub, cause, reason);
    }

    public boolean contains(int var1);

    public boolean isInstantiatedTo(int var1);

    public int getValue() throws IllegalStateException;

    public int getLB();

    public int getUB();

    public int getRange();

    public int nextValue(int var1);

    public int nextValueOut(int var1);

    public int previousValue(int var1);

    public int previousValueOut(int var1);

    public DisposableValueIterator getValueIterator(boolean var1);

    public DisposableRangeIterator getRangeIterator(boolean var1);

    public boolean hasEnumeratedDomain();

    public IIntDeltaMonitor monitorDelta(ICause var1);

    public boolean isBool();

    @Override
    default public void forEachIntVar(Consumer<IntVar> action) {
        action.accept(this);
    }

    default public IEventType transformEvent(IEventType evt) {
        return evt;
    }

    @Override
    default public IntVar intVar() {
        return this;
    }

    @Override
    default public int getNoChild() {
        return 1;
    }

    @Override
    default public boolean isExpressionLeaf() {
        return true;
    }

    default public IntStream stream() {
        Spliterators.AbstractIntSpliterator it = new Spliterators.AbstractIntSpliterator(this.getDomainSize(), 273){
            final int[] val;
            {
                this.val = new int[]{IntVar.this.getLB() - 1};
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                this.val[0] = IntVar.this.nextValue(this.val[0]);
                if (this.val[0] < Integer.MAX_VALUE) {
                    action.accept(this.val[0]);
                    return true;
                }
                return false;
            }
        };
        return StreamSupport.intStream(it, false);
    }

    default public int getLit(int val, int type) {
        throw new UnsupportedOperationException();
    }

    default public int getNELit(int v) {
        return this.getLit(v, 0);
    }

    default public int getEQLit(int v) {
        return this.getLit(v, 1);
    }

    default public int getGELit(int v) {
        return this.getLit(v, 2);
    }

    default public int getLELit(int v) {
        return this.getLit(v, 3);
    }

    default public int getMinLit() {
        throw new UnsupportedOperationException();
    }

    default public int getMaxLit() {
        throw new UnsupportedOperationException();
    }

    default public int getValLit() {
        throw new UnsupportedOperationException();
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

