/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class OutOfSampleDiagnosticsConfiguration
implements DiagnosticsConfiguration {
    private static final AtomicReference<OutOfSampleDiagnosticsConfiguration> DEFAULT = new AtomicReference<OutOfSampleDiagnosticsConfiguration>(OutOfSampleDiagnosticsConfiguration.builder().build());
    public static final boolean ACTIVE = false;
    private final boolean active;
    public static final double BAD = 0.01;
    public static final double UNC = 0.1;
    public static final double LENGTH = 1.5;
    private final double badThreshold;
    private final double uncertainThreshold;
    private final boolean diagnosticOnMean;
    private final boolean diagnosticOnVariance;
    private final double outOfSampleLength;

    public static void setDefault(OutOfSampleDiagnosticsConfiguration config) {
        DEFAULT.set(config);
    }

    public static OutOfSampleDiagnosticsConfiguration getDefault() {
        return DEFAULT.get();
    }

    public static Builder builder() {
        return new Builder().active(false).badThreshold(0.01).uncertainThreshold(0.1).diagnosticOnMean(true).diagnosticOnVariance(true).outOfSampleLength(1.5);
    }

    public DiagnosticsConfiguration activate(boolean active) {
        if (this.active == active) {
            return this;
        }
        return this.toBuilder().active(active).build();
    }

    @Generated
    OutOfSampleDiagnosticsConfiguration(boolean active, double badThreshold, double uncertainThreshold, boolean diagnosticOnMean, boolean diagnosticOnVariance, double outOfSampleLength) {
        this.active = active;
        this.badThreshold = badThreshold;
        this.uncertainThreshold = uncertainThreshold;
        this.diagnosticOnMean = diagnosticOnMean;
        this.diagnosticOnVariance = diagnosticOnVariance;
        this.outOfSampleLength = outOfSampleLength;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().active(this.active).badThreshold(this.badThreshold).uncertainThreshold(this.uncertainThreshold).diagnosticOnMean(this.diagnosticOnMean).diagnosticOnVariance(this.diagnosticOnVariance).outOfSampleLength(this.outOfSampleLength);
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public double getBadThreshold() {
        return this.badThreshold;
    }

    @Generated
    public double getUncertainThreshold() {
        return this.uncertainThreshold;
    }

    @Generated
    public boolean isDiagnosticOnMean() {
        return this.diagnosticOnMean;
    }

    @Generated
    public boolean isDiagnosticOnVariance() {
        return this.diagnosticOnVariance;
    }

    @Generated
    public double getOutOfSampleLength() {
        return this.outOfSampleLength;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutOfSampleDiagnosticsConfiguration)) {
            return false;
        }
        OutOfSampleDiagnosticsConfiguration other = (OutOfSampleDiagnosticsConfiguration)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (Double.compare(this.getBadThreshold(), other.getBadThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getUncertainThreshold(), other.getUncertainThreshold()) != 0) {
            return false;
        }
        if (this.isDiagnosticOnMean() != other.isDiagnosticOnMean()) {
            return false;
        }
        if (this.isDiagnosticOnVariance() != other.isDiagnosticOnVariance()) {
            return false;
        }
        return Double.compare(this.getOutOfSampleLength(), other.getOutOfSampleLength()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        long $badThreshold = Double.doubleToLongBits(this.getBadThreshold());
        result = result * 59 + (int)($badThreshold >>> 32 ^ $badThreshold);
        long $uncertainThreshold = Double.doubleToLongBits(this.getUncertainThreshold());
        result = result * 59 + (int)($uncertainThreshold >>> 32 ^ $uncertainThreshold);
        result = result * 59 + (this.isDiagnosticOnMean() ? 79 : 97);
        result = result * 59 + (this.isDiagnosticOnVariance() ? 79 : 97);
        long $outOfSampleLength = Double.doubleToLongBits(this.getOutOfSampleLength());
        result = result * 59 + (int)($outOfSampleLength >>> 32 ^ $outOfSampleLength);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "OutOfSampleDiagnosticsConfiguration(active=" + this.isActive() + ", badThreshold=" + this.getBadThreshold() + ", uncertainThreshold=" + this.getUncertainThreshold() + ", diagnosticOnMean=" + this.isDiagnosticOnMean() + ", diagnosticOnVariance=" + this.isDiagnosticOnVariance() + ", outOfSampleLength=" + this.getOutOfSampleLength() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean active;
        @Generated
        private double badThreshold;
        @Generated
        private double uncertainThreshold;
        @Generated
        private boolean diagnosticOnMean;
        @Generated
        private boolean diagnosticOnVariance;
        @Generated
        private double outOfSampleLength;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public @NonNull Builder badThreshold(double badThreshold) {
            this.badThreshold = badThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder uncertainThreshold(double uncertainThreshold) {
            this.uncertainThreshold = uncertainThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder diagnosticOnMean(boolean diagnosticOnMean) {
            this.diagnosticOnMean = diagnosticOnMean;
            return this;
        }

        @Generated
        public @NonNull Builder diagnosticOnVariance(boolean diagnosticOnVariance) {
            this.diagnosticOnVariance = diagnosticOnVariance;
            return this;
        }

        @Generated
        public @NonNull Builder outOfSampleLength(double outOfSampleLength) {
            this.outOfSampleLength = outOfSampleLength;
            return this;
        }

        @Generated
        public @NonNull OutOfSampleDiagnosticsConfiguration build() {
            return new OutOfSampleDiagnosticsConfiguration(this.active, this.badThreshold, this.uncertainThreshold, this.diagnosticOnMean, this.diagnosticOnVariance, this.outOfSampleLength);
        }

        @Generated
        public @NonNull String toString() {
            return "OutOfSampleDiagnosticsConfiguration.Builder(active=" + this.active + ", badThreshold=" + this.badThreshold + ", uncertainThreshold=" + this.uncertainThreshold + ", diagnosticOnMean=" + this.diagnosticOnMean + ", diagnosticOnVariance=" + this.diagnosticOnVariance + ", outOfSampleLength=" + this.outOfSampleLength + ")";
        }
    }
}

