/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.SplitUtils;
import dr.evolution.util.TaxonList;
import java.io.PrintWriter;
import java.io.StringWriter;

public class SplitSystem {
    private int labelCount;
    private int splitCount;
    private TaxonList taxonList;
    private boolean[][] splits;

    public SplitSystem(TaxonList taxonList, int n) {
        this.taxonList = taxonList;
        this.labelCount = taxonList.getTaxonCount();
        this.splitCount = n;
        this.splits = new boolean[this.splitCount][this.labelCount];
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public boolean[][] getSplitVector() {
        return this.splits;
    }

    public boolean[] getSplit(int n) {
        return this.splits[n];
    }

    public TaxonList getTaxonList() {
        return this.taxonList;
    }

    public boolean hasSplit(boolean[] blArray) {
        for (int i = 0; i < this.splitCount; ++i) {
            if (!SplitUtils.isSame(blArray, this.splits[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (n = 0; n < this.labelCount; ++n) {
            printWriter.println(this.taxonList.getTaxon(n));
        }
        printWriter.println();
        for (n = 0; n < this.splitCount; ++n) {
            for (int i = 0; i < this.labelCount; ++i) {
                if (this.splits[n][i]) {
                    printWriter.print('*');
                    continue;
                }
                printWriter.print('.');
            }
            printWriter.println();
        }
        return stringWriter.toString();
    }
}

