/*
 * Decompiled with CFR 0.152.
 */
package dr.math.iterations;

import dr.math.MathUtils;
import dr.math.functionEval.DrMath;
import dr.math.functionEval.FunctionDerivative;
import dr.math.interfaces.OneVariableFunction;
import dr.math.iterations.FunctionalIterator;

public class NewtonZeroFinder
extends FunctionalIterator {
    private OneVariableFunction df;

    public NewtonZeroFinder(OneVariableFunction oneVariableFunction, double d) {
        super(oneVariableFunction);
        this.setStartingValue(d);
    }

    public NewtonZeroFinder(OneVariableFunction oneVariableFunction, OneVariableFunction oneVariableFunction2, double d) throws IllegalArgumentException {
        this(oneVariableFunction, d);
        this.setDerivative(oneVariableFunction2);
    }

    @Override
    public double evaluateIteration() {
        double d = this.f.value(this.result) / this.df.value(this.result);
        this.result -= d;
        return this.relativePrecision(Math.abs(d));
    }

    @Override
    public void initializeIterations() {
        if (this.df == null) {
            this.df = new FunctionDerivative(this.f);
        }
        if (Double.isNaN(this.result)) {
            this.result = 0.0;
        }
        int n = 0;
        while (DrMath.equal(this.df.value(this.result), 0.0) && ++n <= this.getMaximumIterations()) {
            this.result += MathUtils.nextDouble();
        }
    }

    public void setDerivative(OneVariableFunction oneVariableFunction) throws IllegalArgumentException {
        this.df = new FunctionDerivative(this.f);
        if (!DrMath.equal(this.df.value(this.result), oneVariableFunction.value(this.result), 0.001)) {
            throw new IllegalArgumentException("Supplied derative function is inaccurate");
        }
        this.df = oneVariableFunction;
    }

    @Override
    public void setFunction(OneVariableFunction oneVariableFunction) {
        super.setFunction(oneVariableFunction);
        this.df = null;
    }

    public void setStartingValue(double d) {
        this.result = d;
    }
}

