/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.factor.opcache;

public class DivisionCache {
    private final int divisor;
    private int cachedBlockStart;
    private int cachedResult;

    public DivisionCache(int divisor) {
        this.divisor = divisor;
        this.cachedBlockStart = 0;
        this.cachedResult = 0;
    }

    public int apply(int arg) {
        if (this.divisor == 1) {
            return arg;
        }
        if (this.isInCache(arg)) {
            return this.cachedResult;
        }
        this.cachedResult = arg / this.divisor;
        this.cachedBlockStart = this.cachedResult * this.divisor;
        return this.cachedResult;
    }

    public boolean isInCache(int arg) {
        return arg >= this.cachedBlockStart && arg - this.cachedBlockStart < this.divisor;
    }
}

