/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.SubArrayOfLong;
import ec.tstoolkit.data.SubTableOfLong;
import ec.tstoolkit.data.Table;
import ec.tstoolkit.design.PrimitiveReplacementOf;

@PrimitiveReplacementOf(generic=Table.class, primitive=long.class)
public class TableOfLong {
    private final long[] m_data;
    private final int m_nrows;
    private final int m_ncols;

    public TableOfLong(int nrows, int ncols) {
        this.m_data = new long[nrows * ncols];
        this.m_nrows = nrows;
        this.m_ncols = ncols;
    }

    public TableOfLong(TableOfLong table) {
        this.m_data = (long[])table.m_data.clone();
        this.m_nrows = table.m_nrows;
        this.m_ncols = table.m_ncols;
    }

    public SubArrayOfLong column(int col) {
        return SubArrayOfLong.create(this.m_data, col * this.m_nrows, (col + 1) * this.m_nrows, 1);
    }

    public SubTableOfLong extract() {
        return new SubTableOfLong(this.m_data, 0, this.m_nrows, this.m_ncols, 1, this.m_nrows);
    }

    public SubTableOfLong extract(int r0, int r1, int c0, int c1) {
        return new SubTableOfLong(this.m_data, r0 + c0 * this.m_nrows, r1 - r0, c1 - c0, 1, this.m_nrows);
    }

    public SubTableOfLong extract(int r0, int c0, int nr, int nc, int rinc, int cinc) {
        return new SubTableOfLong(this.m_data, r0 + c0 * this.m_nrows, nr, nc, rinc, cinc * this.m_nrows);
    }

    public long get(int r, int c) {
        return this.m_data[r + c * this.m_nrows];
    }

    public int getColumnsCount() {
        return this.m_ncols;
    }

    public int getRowsCount() {
        return this.m_nrows;
    }

    public boolean isEmpty() {
        return this.m_data == null;
    }

    public SubArrayOfLong row(int row) {
        return SubArrayOfLong.create(this.m_data, row, row + this.m_ncols * this.m_nrows, this.m_nrows);
    }

    public long[] internalStorage() {
        return this.m_data;
    }

    public void set(int r, int c, long value) {
        this.m_data[r + c * this.m_nrows] = value;
    }
}

