/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Random;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.ConditionalEstimator;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;

public class KKConditionalEstimator
implements ConditionalEstimator {
    private double[] m_Values;
    private double[] m_CondValues = new double[50];
    private double[] m_Weights;
    private int m_NumValues = 0;
    private double m_SumOfWeights = 0.0;
    private double m_StandardDev = 0.0;
    private boolean m_AllWeightsOne = true;
    private double m_Precision;

    private int findNearestPair(double d, double d2) {
        int n = 0;
        int n2 = this.m_NumValues;
        int n3 = 0;
        while (n < n2) {
            n3 = (n + n2) / 2;
            double d3 = this.m_CondValues[n3];
            if (d3 == d) {
                double d4 = this.m_Values[n3];
                if (d4 == d2) {
                    return n3;
                }
                if (d4 > d2) {
                    n2 = n3;
                } else if (d4 < d2) {
                    n = n3 + 1;
                }
            }
            if (d3 > d) {
                n2 = n3;
                continue;
            }
            if (!(d3 < d)) continue;
            n = n3 + 1;
        }
        return n;
    }

    private double round(double d) {
        return Math.rint(d / this.m_Precision) * this.m_Precision;
    }

    public KKConditionalEstimator(double d) {
        this.m_Values = new double[50];
        this.m_Weights = new double[50];
        this.m_Precision = d;
    }

    public void addValue(double d, double d2, double d3) {
        d = this.round(d);
        int n = this.findNearestPair(d2 = this.round(d2), d);
        if (this.m_NumValues <= n || this.m_CondValues[n] != d2 || this.m_Values[n] != d) {
            if (this.m_NumValues < this.m_Values.length) {
                int n2 = this.m_NumValues - n;
                System.arraycopy(this.m_Values, n, this.m_Values, n + 1, n2);
                System.arraycopy(this.m_CondValues, n, this.m_CondValues, n + 1, n2);
                System.arraycopy(this.m_Weights, n, this.m_Weights, n + 1, n2);
                this.m_Values[n] = d;
                this.m_CondValues[n] = d2;
                this.m_Weights[n] = d3;
                ++this.m_NumValues;
            } else {
                double[] dArray = new double[this.m_Values.length * 2];
                double[] dArray2 = new double[this.m_Values.length * 2];
                double[] dArray3 = new double[this.m_Values.length * 2];
                int n3 = this.m_NumValues - n;
                System.arraycopy(this.m_Values, 0, dArray, 0, n);
                System.arraycopy(this.m_CondValues, 0, dArray2, 0, n);
                System.arraycopy(this.m_Weights, 0, dArray3, 0, n);
                dArray[n] = d;
                dArray2[n] = d2;
                dArray3[n] = d3;
                System.arraycopy(this.m_Values, n, dArray, n + 1, n3);
                System.arraycopy(this.m_CondValues, n, dArray2, n + 1, n3);
                System.arraycopy(this.m_Weights, n, dArray3, n + 1, n3);
                ++this.m_NumValues;
                this.m_Values = dArray;
                this.m_CondValues = dArray2;
                this.m_Weights = dArray3;
            }
            if (d3 != 1.0) {
                this.m_AllWeightsOne = false;
            }
        } else {
            int n4 = n;
            this.m_Weights[n4] = this.m_Weights[n4] + d3;
            this.m_AllWeightsOne = false;
        }
        this.m_SumOfWeights += d3;
        double d4 = this.m_CondValues[this.m_NumValues - 1] - this.m_CondValues[0];
        this.m_StandardDev = Math.max(d4 / Math.sqrt(this.m_SumOfWeights), this.m_Precision / 6.0);
    }

    public Estimator getEstimator(double d) {
        KernelEstimator kernelEstimator = new KernelEstimator(this.m_Precision);
        if (this.m_NumValues == 0) {
            return kernelEstimator;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.m_NumValues; ++i) {
            d2 = this.m_CondValues[i] - d;
            double d4 = (d2 - this.m_Precision / 2.0) / this.m_StandardDev;
            double d5 = (d2 + this.m_Precision / 2.0) / this.m_StandardDev;
            d3 = Statistics.normalProbability(d5) - Statistics.normalProbability(d4);
            ((Estimator)kernelEstimator).addValue(this.m_Values[i], d3 * this.m_Weights[i]);
        }
        return kernelEstimator;
    }

    public double getProbability(double d, double d2) {
        return this.getEstimator(d2).getProbability(d);
    }

    public String toString() {
        String string = "KK Conditional Estimator. " + this.m_NumValues + " Normal Kernels:\n" + "StandardDev = " + Utils.doubleToString(this.m_StandardDev, 4, 2) + "  \nMeans =";
        for (int i = 0; i < this.m_NumValues; ++i) {
            string = string + " (" + this.m_Values[i] + ", " + this.m_CondValues[i] + ")";
            if (this.m_AllWeightsOne) continue;
            string = string + "w=" + this.m_Weights[i];
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            int n3 = 42;
            if (stringArray.length > 0) {
                n3 = Integer.parseInt(stringArray[0]);
            }
            KKConditionalEstimator kKConditionalEstimator = new KKConditionalEstimator(0.1);
            Random random = new Random(n3);
            int n4 = 50;
            if (stringArray.length > 2) {
                n4 = Integer.parseInt(stringArray[2]);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                int n5 = Math.abs(random.nextInt() % 100);
                n = Math.abs(random.nextInt() % 100);
                System.out.println("# " + n5 + "  " + n);
                kKConditionalEstimator.addValue(n5, n, 1.0);
            }
            n2 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : Math.abs(random.nextInt() % 100);
            System.out.println("## Conditional = " + n2);
            Estimator estimator = kKConditionalEstimator.getEstimator(n2);
            for (n = 0; n <= 100; n += 5) {
                System.out.println(" " + n + "  " + estimator.getProbability(n));
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

