/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.fitness;

import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.base.AbstractFitness;
import net.sourceforge.jclec.fitness.ICompositeFitness;
import net.sourceforge.jclec.fitness.ISimpleFitness;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CompositeFitness
extends AbstractFitness
implements ICompositeFitness {
    private static final long serialVersionUID = 3257291339740559156L;
    protected ISimpleFitness[] components;

    public CompositeFitness() {
        this(null);
    }

    public CompositeFitness(ISimpleFitness[] components) {
        this.setComponents(components);
    }

    @Override
    public ISimpleFitness[] getComponents() {
        return this.components;
    }

    @Override
    public void setComponents(ISimpleFitness[] components) {
        this.components = components;
    }

    @Override
    public ISimpleFitness getComponent(int cidx) {
        try {
            return this.components[cidx];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.valueOf(cidx) + "isn't a valid component index");
        }
    }

    @Override
    public void setComponent(int cidx, ISimpleFitness cval) {
        try {
            this.components[cidx] = cval;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.valueOf(cidx) + "isn't a valid component index");
        }
    }

    @Override
    public IFitness copy() {
        CompositeFitness result = new CompositeFitness();
        int cl = this.components.length;
        result.components = new ISimpleFitness[cl];
        int i = 0;
        while (i < cl) {
            result.components[i] = (ISimpleFitness)this.components[i].copy();
            ++i;
        }
        return result;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        ISimpleFitness[] iSimpleFitnessArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            ISimpleFitness fitness = iSimpleFitnessArray[n2];
            hcb.append(fitness);
            ++n2;
        }
        return hcb.toHashCode();
    }

    public boolean equals(Object oth) {
        if (oth instanceof CompositeFitness) {
            CompositeFitness coth = (CompositeFitness)oth;
            int cl = this.components.length;
            int ocl = coth.components.length;
            if (cl == ocl) {
                EqualsBuilder eb = new EqualsBuilder();
                int i = 0;
                while (i < cl) {
                    eb.append(this.components[i], coth.components[i]);
                    ++i;
                }
                return eb.isEquals();
            }
            return false;
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append("components", this.components);
        return tsb.toString();
    }
}

