/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.fitness.IValueFitness;

public class IndividualStatistics {
    public static final IIndividual bestIndividual(List<IIndividual> set, final Comparator<IFitness> comparator) {
        Comparator<IIndividual> indComparator = new Comparator<IIndividual>(){

            @Override
            public int compare(IIndividual arg0, IIndividual arg1) {
                return comparator.compare(arg0.getFitness(), arg1.getFitness());
            }
        };
        int setSize = set.size();
        IIndividual best = set.get(0);
        int i = 1;
        while (i < setSize) {
            IIndividual other = set.get(i);
            if (indComparator.compare(best, other) == -1) {
                best = other;
            }
            ++i;
        }
        return best;
    }

    public static final IIndividual worstIndividual(List<IIndividual> set, final Comparator<IFitness> comparator) {
        Comparator<IIndividual> indComparator = new Comparator<IIndividual>(){

            @Override
            public int compare(IIndividual arg0, IIndividual arg1) {
                return comparator.compare(arg0.getFitness(), arg1.getFitness());
            }
        };
        int setSize = set.size();
        IIndividual worst = set.get(0);
        int i = 1;
        while (i < setSize) {
            IIndividual other = set.get(i);
            if (indComparator.compare(worst, other) == 1) {
                worst = other;
            }
            ++i;
        }
        return worst;
    }

    public static final IIndividual medianIndividual(List<IIndividual> set, final Comparator<IFitness> comparator) {
        Comparator<IIndividual> indComparator = new Comparator<IIndividual>(){

            @Override
            public int compare(IIndividual arg0, IIndividual arg1) {
                return comparator.compare(arg1.getFitness(), arg0.getFitness());
            }
        };
        int setSize = set.size();
        LinkedList<IIndividual> aux = new LinkedList<IIndividual>(set);
        Collections.sort(aux, indComparator);
        return set.get(setSize / 2);
    }

    public static final double averageFitness(List<IIndividual> set) {
        double result = 0.0;
        int nOfInds = set.size();
        for (IIndividual ind : set) {
            IFitness fitness = ind.getFitness();
            try {
                result += ((IValueFitness)fitness).getValue();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("");
            }
        }
        return result /= (double)nOfInds;
    }

    public static final double fitnessVariance(List<IIndividual> set) {
        double avg = 0.0;
        double var = 0.0;
        int nOfInds = set.size();
        for (IIndividual ind : set) {
            IFitness fitness = ind.getFitness();
            try {
                double tmp = ((IValueFitness)fitness).getValue();
                avg += tmp;
                var += tmp * tmp;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("");
            }
        }
        var = var / (double)nOfInds - (avg /= (double)nOfInds) * avg;
        return var;
    }

    public static final double[] averageFitnessAndFitnessVariance(List<IIndividual> set) {
        double[] result = new double[]{0.0, 0.0};
        int nOfInds = set.size();
        for (IIndividual ind : set) {
            IFitness fitness = ind.getFitness();
            try {
                double tmp = ((IValueFitness)fitness).getValue();
                result[0] = result[0] + tmp;
                result[1] = result[1] + tmp * tmp;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("");
            }
        }
        result[0] = result[0] / (double)nOfInds;
        result[1] = result[1] / (double)nOfInds - result[0] * result[0];
        return result;
    }
}

