/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

import java.util.Enumeration;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.M5StaticUtils;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.MyAttribute;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.MyDataset;

public class Itemset {
    protected MyDataset dataset;
    protected double[] values;
    protected double weight;
    protected static final double MISSING_VALUE = Double.NaN;

    public Itemset(Itemset itemset) {
        this.values = itemset.values;
        this.weight = itemset.weight;
        this.dataset = null;
    }

    public Itemset(double w, double[] attributeValues) {
        this.values = attributeValues;
        this.weight = w;
        this.dataset = null;
    }

    public Itemset(int numAttributes) {
        this.values = new double[numAttributes];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Double.NaN;
        }
        this.weight = 1.0;
        this.dataset = null;
    }

    public int index(int position) {
        return position;
    }

    public int classIndex() {
        if (this.dataset == null) {
            throw new RuntimeException("Itemset doesn't have access to a dataset!");
        }
        return this.dataset.getClassIndex();
    }

    public boolean classIsMissing() {
        if (this.classIndex() < 0) {
            throw new RuntimeException("Class is not set.");
        }
        return this.isMissing(this.classIndex());
    }

    public double getClassValue() {
        if (this.classIndex() < 0) {
            throw new RuntimeException("dataset in itemset is null");
        }
        return this.getValue(this.classIndex());
    }

    public MyAttribute getClassAttribute() throws Exception {
        if (this.dataset == null) {
            throw new Exception("Itemset doesn't have access to a dataset!");
        }
        return this.dataset.getClassAttribute();
    }

    public int numClasses() {
        if (this.dataset == null) {
            throw new RuntimeException("dataset in itemset is null");
        }
        return this.dataset.numClasses();
    }

    public MyAttribute getAttribute(int index) {
        if (this.dataset == null) {
            throw new RuntimeException("dataset in itemset is null");
        }
        return this.dataset.getAttribute(index);
    }

    public int numAttributes() {
        return this.values.length;
    }

    public int numValues() {
        return this.values.length;
    }

    public MyAttribute attributeSparse(int indexOfIndex) throws Exception {
        if (this.dataset == null) {
            throw new Exception("Itemset doesn't have access to a dataset!");
        }
        return this.dataset.getAttribute(indexOfIndex);
    }

    public void setClassValue(double value) {
        if (this.classIndex() < 0) {
            throw new RuntimeException("Class is not set.");
        }
        this.setValue(this.classIndex(), value);
    }

    public void setClassValue(String value) throws Exception {
        if (this.classIndex() < 0) {
            throw new RuntimeException("Class is not set.");
        }
        this.setValue(this.classIndex(), value);
    }

    public void setValue(int index, double value) {
        double[] help = new double[this.values.length];
        System.arraycopy(this.values, 0, help, 0, this.values.length);
        this.values = help;
        this.values[index] = value;
    }

    public void setValueSparse(int indexOfIndex, double value) {
        double[] help = new double[this.values.length];
        System.arraycopy(this.values, 0, help, 0, this.values.length);
        this.values = help;
        this.values[indexOfIndex] = value;
    }

    public final void setValue(int attIndex, String value) throws Exception {
        if (this.dataset == null) {
            throw new Exception("Itemset doesn't have access to a dataset!");
        }
        if (!this.getAttribute(attIndex).isDiscret()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = this.getAttribute(attIndex).valueIndex(value);
        if (valIndex == -1) {
            if (this.getAttribute(attIndex).isDiscret()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            valIndex = this.getAttribute(attIndex).valueIndex(value);
        }
        this.setValue(attIndex, (double)valIndex);
    }

    public final void setValue(MyAttribute att, double value) {
        this.setValue(att.index(), value);
    }

    public final void setValue(MyAttribute att, String value) throws Exception {
        this.setValue(att.index(), value);
    }

    public double getValueSparse(int indexOfIndex) {
        return this.values[indexOfIndex];
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public String getStringValue(int index) throws Exception {
        if (this.dataset == null) {
            throw new Exception("Itemset doesn't have access to a dataset!");
        }
        if (!this.dataset.getAttribute(index).isDiscret()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        return this.dataset.getAttribute(index).value(index);
    }

    public String getStringValue(MyAttribute att) throws Exception {
        return this.getStringValue(att.index());
    }

    public double getValue(MyAttribute att) {
        return this.values[att.index()];
    }

    public final void setWeight(double w) {
        this.weight = w;
    }

    public final double getWeight() {
        return this.weight;
    }

    public MyDataset getDataset() {
        return this.dataset;
    }

    public final void setDataset(MyDataset data) {
        this.dataset = data;
    }

    public boolean isMissing(int index) {
        return Double.isNaN(this.values[index]);
    }

    public boolean isMissing(MyAttribute att) {
        return this.isMissing(att.index());
    }

    public boolean isMissingSparse(int indexOfIndex) {
        return Double.isNaN(this.values[indexOfIndex]);
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public static double getMissingValue() {
        return Double.NaN;
    }

    public void setClassMissing() {
        if (this.classIndex() < 0) {
            throw new RuntimeException("Class is not set.");
        }
        this.setMissing(this.classIndex());
    }

    public final void setMissing(int index) {
        this.setValue(index, Double.NaN);
    }

    public final void setMissing(MyAttribute att) {
        this.setMissing(att.index());
    }

    public Object copy() {
        Itemset result = new Itemset(this);
        result.dataset = this.dataset;
        return result;
    }

    public void insertAttributeAt(int position) {
        if (this.dataset != null) {
            throw new RuntimeException("Itemset has accesss to a dataset!");
        }
        if (position < 0 || position > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        this.forceInsertAttributeAt(position);
    }

    public Itemset mergeInstance(Itemset inst) {
        int m = 0;
        double[] newVals = new double[this.numAttributes() + inst.numAttributes()];
        int j = 0;
        while (j < this.numAttributes()) {
            newVals[m] = this.getValue(j);
            ++j;
            ++m;
        }
        j = 0;
        while (j < inst.numAttributes()) {
            newVals[m] = inst.getValue(j);
            ++j;
            ++m;
        }
        return new Itemset(1.0, newVals);
    }

    public void deleteAttributeAt(int position) {
        if (this.dataset != null) {
            throw new RuntimeException("Itemset has access to a dataset!");
        }
        this.forceDeleteAttributeAt(position);
    }

    public void replaceMissingValues(double[] array) {
        if (array == null || array.length != this.values.length) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        double[] help = new double[this.values.length];
        System.arraycopy(this.values, 0, help, 0, this.values.length);
        this.values = help;
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.isMissing(i)) continue;
            this.values[i] = array[i];
        }
    }

    public boolean equalHeaders(Itemset inst) throws Exception {
        if (this.dataset == null) {
            throw new Exception("Itemset doesn't have access to a dataset!");
        }
        return this.dataset.equalHeaders(inst.dataset);
    }

    public Enumeration enumerateAttributes() throws Exception {
        if (this.dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        return this.dataset.enumerateAttributes();
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.dataset.numAttributes(); ++i) {
            MyAttribute att = this.dataset.getAttribute(i);
            result = att.isContinuous() ? result + att.name() + "=" + this.values[i] + " " : result + att.name() + "=" + att.value((int)this.values[i]) + " ";
        }
        return result;
    }

    public final String toString(MyAttribute att) throws Exception {
        return Integer.toString(att.index());
    }

    public final String toString(int attIndex) throws Exception {
        StringBuffer text = new StringBuffer();
        if (this.isMissing(attIndex)) {
            text.append("?");
        } else if (this.dataset == null) {
            text.append(M5StaticUtils.doubleToString(this.values[attIndex], 6));
        } else if (this.dataset.getAttribute(attIndex).isDiscret()) {
            text.append(M5StaticUtils.quote(this.getStringValue(attIndex)));
        } else {
            text.append(M5StaticUtils.doubleToString(this.getValue(attIndex), 6));
        }
        return text.toString();
    }

    private void forceDeleteAttributeAt(int position) {
        double[] newValues = new double[this.values.length - 1];
        System.arraycopy(this.values, 0, newValues, 0, position);
        if (position < this.values.length - 1) {
            System.arraycopy(this.values, position + 1, newValues, position, this.values.length - (position + 1));
        }
        this.values = newValues;
    }

    private void forceInsertAttributeAt(int position) {
        double[] newValues = new double[this.values.length + 1];
        System.arraycopy(this.values, 0, newValues, 0, position);
        newValues[position] = Double.NaN;
        System.arraycopy(this.values, position, newValues, position + 1, this.values.length - position);
        this.values = newValues;
    }

    protected Itemset() {
    }
}

