/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy;

import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.Fuzzy;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyNumberTRIANG;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyNumberTRLEFT;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyNumberTRRIGHT;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzySingleton;

public class FuzzyPartition {
    private Fuzzy[] content;

    public FuzzyPartition(double min, double max, int n) {
        this.content = new Fuzzy[n];
        double d = (max - min) / (double)(n - 1);
        double iz = min - d;
        double ce = min;
        double de = min + d;
        this.content[0] = new FuzzyNumberTRLEFT(ce, de);
        for (int i = 1; i < n - 1; ++i) {
            this.content[i] = new FuzzyNumberTRIANG(iz += d, ce += d, de += d);
        }
        de += d;
        this.content[n - 1] = new FuzzyNumberTRRIGHT(iz += d, ce += d);
    }

    public FuzzyPartition(double[] values) {
        this.content = new Fuzzy[values.length];
        int n = this.content.length;
        this.content[0] = new FuzzyNumberTRLEFT(values[0], values[1]);
        for (int i = 1; i < n - 1; ++i) {
            this.content[i] = new FuzzyNumberTRIANG(values[i - 1], values[i], values[i + 1]);
        }
        this.content[n - 1] = new FuzzyNumberTRRIGHT(values[n - 2], values[n - 1]);
    }

    public double[] toVector() {
        if (this.content[0] instanceof FuzzySingleton) {
            return new double[0];
        }
        if (this.content.length == 2) {
            double[] result = new double[2];
            FuzzyNumberTRLEFT b = (FuzzyNumberTRLEFT)this.content[0];
            result[0] = b.center;
            result[1] = b.right;
            return result;
        }
        double[] result = new double[this.content.length];
        FuzzyNumberTRIANG b = (FuzzyNumberTRIANG)this.content[1];
        result[0] = b.left;
        for (int i = 1; i < result.length - 1; ++i) {
            b = (FuzzyNumberTRIANG)this.content[i];
            result[i] = b.center;
        }
        b = (FuzzyNumberTRIANG)this.content[result.length - 2];
        result[result.length - 1] = b.right;
        return result;
    }

    public FuzzyPartition(int n) {
        this.content = new Fuzzy[n];
        for (int i = 0; i < n; ++i) {
            this.content[i] = new FuzzySingleton(i);
        }
    }

    public FuzzyPartition(FuzzyPartition p) {
        this.content = new Fuzzy[p.content.length];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = p.content[i].clone();
        }
    }

    public FuzzyPartition clone() {
        return new FuzzyPartition(this);
    }

    public void set(FuzzyPartition p) {
        this.content = new Fuzzy[p.content.length];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = p.content[i].clone();
        }
    }

    public Fuzzy getComponent(int n) {
        return this.content[n];
    }

    public void setComponent(int n, Fuzzy b) {
        this.content[n] = b.clone();
    }

    public int size() {
        return this.content.length;
    }

    public String aString() {
        String result = "PART(";
        for (int i = 0; i < this.content.length; ++i) {
            result = result + this.content[i].aString() + " ";
        }
        result = result + ")";
        return result;
    }
}

