/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.net;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import keel.Algorithms.Neural_Networks.net.Parameters;

public class Data {
    public double[][] train;
    public double[][] validation;
    public double[][] test;
    public double[] a = null;
    public double[] b = null;

    public Data(int n_variables, int n_train, int n_test, int n_val) {
        this.train = new double[n_train][n_variables];
        if (n_test != 0) {
            this.test = new double[n_test][n_variables];
        }
        if (n_val != 0) {
            this.validation = new double[n_val][n_variables];
        }
    }

    public Data(Parameters global) throws FileNotFoundException, IOException {
        int pos2;
        int j;
        int pos1;
        int i;
        String line;
        BufferedReader f;
        FileInputStream file;
        try {
            file = new FileInputStream(global.train_file);
            f = new BufferedReader(new InputStreamReader(file));
            line = f.readLine();
            global.n_train_patterns = Integer.parseInt(line);
            line = f.readLine();
            global.Ninputs = Integer.parseInt(line);
            line = f.readLine();
            global.Noutputs = Integer.parseInt(line);
            this.train = new double[global.n_train_patterns][global.Ninputs + global.Noutputs];
            for (i = 0; i < global.n_train_patterns; ++i) {
                line = f.readLine();
                pos1 = 0;
                for (j = 0; j < global.Ninputs + global.Noutputs - 1; ++j) {
                    pos2 = line.indexOf(" ", pos1);
                    this.train[i][j] = Double.parseDouble(line.substring(pos1, pos2));
                    pos1 = pos2 + 1;
                }
                this.train[i][global.Ninputs + global.Noutputs - 1] = Double.parseDouble(line.substring(pos1));
            }
            file.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Training file does not exist");
            System.exit(-1);
        }
        if (global.test_data) {
            try {
                file = new FileInputStream(global.test_file);
                f = new BufferedReader(new InputStreamReader(file));
                line = f.readLine();
                global.n_test_patterns = Integer.parseInt(line);
                line = f.readLine();
                global.Ninputs = Integer.parseInt(line);
                line = f.readLine();
                global.Noutputs = Integer.parseInt(line);
                this.test = new double[global.n_test_patterns][global.Ninputs + global.Noutputs];
                for (i = 0; i < global.n_test_patterns; ++i) {
                    line = f.readLine();
                    pos1 = 0;
                    for (j = 0; j < global.Ninputs + global.Noutputs - 1; ++j) {
                        pos2 = line.indexOf(" ", pos1);
                        this.test[i][j] = Double.parseDouble(line.substring(pos1, pos2));
                        pos1 = pos2 + 1;
                    }
                    this.test[i][global.Ninputs + global.Noutputs - 1] = Double.parseDouble(line.substring(pos1));
                }
                file.close();
            }
            catch (FileNotFoundException f2) {
                System.err.println("Testing file does not exist");
                System.exit(-1);
            }
        }
        if (global.val_data) {
            try {
                file = new FileInputStream(global.val_file);
                f = new BufferedReader(new InputStreamReader(file));
                line = f.readLine();
                global.n_val_patterns = Integer.parseInt(line);
                line = f.readLine();
                global.Ninputs = Integer.parseInt(line);
                line = f.readLine();
                global.Nhidden[global.Nhidden_layers] = global.Noutputs = Integer.parseInt(line);
                this.validation = new double[global.n_val_patterns][global.Ninputs + global.Noutputs];
                for (i = 0; i < global.n_val_patterns; ++i) {
                    line = f.readLine();
                    pos1 = 0;
                    for (j = 0; j < global.Ninputs + global.Noutputs - 1; ++j) {
                        pos2 = line.indexOf(" ", pos1);
                        this.validation[i][j] = Double.parseDouble(line.substring(pos1, pos2));
                        pos1 = pos2 + 1;
                    }
                    this.validation[i][global.Ninputs + global.Noutputs - 1] = Double.parseDouble(line.substring(pos1));
                }
                file.close();
            }
            catch (FileNotFoundException e) {
                System.err.println("Validation file does not exist");
                System.exit(-1);
            }
        }
    }

    public void TipifyInputData(Parameters global) {
        for (int i = 0; i < global.Ninputs; ++i) {
            int j;
            double sq_sum = 0.0;
            double sigma = 0.0;
            double mean = 0.0;
            for (j = 0; j < global.n_train_patterns; ++j) {
                mean += this.train[j][i];
                sq_sum += this.train[j][i] * this.train[j][i];
            }
            if (!((sigma = Math.sqrt(sq_sum / (double)global.n_train_patterns - (mean /= (double)global.n_train_patterns) * mean)) > 1.0E-6)) continue;
            for (j = 0; j < global.n_train_patterns; ++j) {
                this.train[j][i] = (this.train[j][i] - mean) / sigma;
            }
            if (global.test_data) {
                for (j = 0; j < global.n_test_patterns; ++j) {
                    this.test[j][i] = (this.test[j][i] - mean) / sigma;
                }
            }
            if (!global.val_data) continue;
            for (j = 0; j < global.n_val_patterns; ++j) {
                this.validation[j][i] = (this.validation[j][i] - mean) / sigma;
            }
        }
    }

    public void ScaleOutputData(Parameters global, double lbound, double ubound) {
        this.a = new double[global.Noutputs];
        this.b = new double[global.Noutputs];
        for (int i = global.Ninputs; i < global.Ninputs + global.Noutputs; ++i) {
            int j;
            double max_val;
            int ii = i - global.Ninputs;
            double min_val = max_val = this.train[0][i];
            for (j = 0; j < global.n_train_patterns; ++j) {
                if (max_val < this.train[j][i]) {
                    max_val = this.train[j][i];
                    continue;
                }
                if (!(min_val > this.train[j][i])) continue;
                min_val = this.train[j][i];
            }
            if (max_val == min_val) continue;
            this.a[ii] = (ubound - lbound) / (max_val - min_val);
            this.b[ii] = (lbound * max_val - ubound * min_val) / (max_val - min_val);
            for (j = 0; j < global.n_train_patterns; ++j) {
                this.train[j][i] = this.a[ii] * this.train[j][i] + this.b[ii];
            }
            if (global.test_data) {
                for (j = 0; j < global.n_test_patterns; ++j) {
                    this.test[j][i] = this.a[ii] * this.test[j][i] + this.b[ii];
                }
            }
            if (!global.val_data) continue;
            for (j = 0; j < global.n_val_patterns; ++j) {
                this.validation[j][i] = this.a[ii] * this.validation[j][i] + this.b[ii];
            }
        }
    }
}

