## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(andorR)

## ----eval=FALSE---------------------------------------------------------------
# # This code shows how to load a YAML file from the package's example data
# yaml_path <- system.file("extdata", "ethical.yml", package = "andorR")
# tree_from_yaml <- load_tree_yaml(yaml_path)
# 
# # View the loaded tree
# print(tree_from_yaml)

## ----eval=FALSE---------------------------------------------------------------
# # This code shows how to load a JSON file from the package's example data
# json_path <- system.file("extdata", "ethical.json", package = "andorR")
# tree_from_json <- load_tree_json(json_path)
# 
# # View the loaded tree
# print(tree_from_json)

## ----echo=FALSE---------------------------------------------------------------
# Load the built-in ethical dataset to display its structure
data(ethical)
knitr::kable(head(ethical, n=10), caption = "Example of the Relational (ID/Parent) Format")

## -----------------------------------------------------------------------------
# Load the example 'ethical' data frame that comes with the package
data(ethical)

# Build the tree from the data frame object
tree_from_df <- load_tree_df(ethical)

# The structure is identical to the one loaded from YAML
print(tree_from_df$children[[1]]$name) # Prints "Financial Viability"

## ----echo=FALSE---------------------------------------------------------------
# Create a small example of the path string format for display
path_example_df <- data.frame(
  path = c(
    "Invest in Company X",
    "Invest in Company X/Financial Viability",
    "Invest in Company X/Financial Viability/Profitability and Growth Signals",
    "Invest in Company X/Financial Viability/Profitability and Growth Signals/FIN1"
  ),
  rule = c("AND", "AND", "OR", NA)
)
knitr::kable(path_example_df, caption = "Example of the Path String Format")

## ----eval=FALSE---------------------------------------------------------------
# # This code shows how to load a path string CSV from the package's example data
# path_csv_path <- system.file("extdata", "ethical_path.csv", package = "andorR")
# tree_from_path <- load_tree_csv_path(path_csv_path)
# 
# print(tree_from_path)

