## -----------------------------------------------------------------------------
library(api2lm)

## -----------------------------------------------------------------------------
data(home_sales, package = "api2lm")

## -----------------------------------------------------------------------------
lmod <- lm(price ~ ., data = home_sales)
coef(lmod)

## -----------------------------------------------------------------------------
outlier_plot(lmod, id_n = 2)

## -----------------------------------------------------------------------------
outlier_test(lmod)

## -----------------------------------------------------------------------------
leverage_plot(lmod)

## ---- fig.height=6, fig.width=6-----------------------------------------------
dfbetas_plot(lmod, id_n = 2,
             regressors = ~ bedrooms + bathrooms + sqft_living + sqft_lot)

## -----------------------------------------------------------------------------
dffits_plot(lmod, id_n = 3)

## -----------------------------------------------------------------------------
cooks_plot(lmod, id_n = 3)

## -----------------------------------------------------------------------------
influence_plot(lmod)

