## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message=FALSE, warning=FALSE--------------------------------------
library(eFCM)

# Load weekly precipitation maxima (pre-aggregated)
data("counterfactual")  # matrix/data frame: [weeks × stations]

# Load station coordinates
data("LonLat")
coord <- LonLat

## ---- fig.width = 6, fig.height = 4, fig.align='center'-----------------------
plot(1:nrow(counterfactual), apply(counterfactual, 1, mean),
     type = "l", xlab = "Week", ylab = "Mean Precipitation (mm)",
     main = "Weekly Maxima of Counterfactual Precipitation")
abline(h = quantile(apply(counterfactual, 1, mean), 0.9), col = "red", lty = 2)

## ---- eval=FALSE--------------------------------------------------------------
#  cf_data = fdata(counterfactual, coord, cellsize = c(1, 1))

## ---- echo=T------------------------------------------------------------------
data(cf_data)
data(fit)

## ---- eval=FALSE--------------------------------------------------------------
#  fit = fcm(s = 1, cf_data, boot = T, R = 1000)

## -----------------------------------------------------------------------------
summary(fit)

## -----------------------------------------------------------------------------
coef(fit, method = "hessian")
coef(fit, method = "boot")

## -----------------------------------------------------------------------------
logLik(fit)
AIC(fit)
BIC(fit)
AICc(fit)

## ---- fig.width = 4, fig.height = 4.5, fig.align='center'---------------------
qqplot(fit, which = 1)

## ---- eval=T, fig.width = 4, fig.height = 4.5, fig.align='center'-------------
chiplot(fit, method = "hessian", ylim = c(0, 1))

## ---- eval=T, fig.width = 4, fig.height = 4.5, fig.align='center'-------------
chiplot(fit, method = "boot", ylim = c(0, 1))

## ---- eval=FALSE--------------------------------------------------------------
#  lbda <- fit$par[1]
#  delta <- fit$par[2]
#  dist <- rdist.earth(fit$coord)
#  sim  <- rmfcm(lbda, delta, dist, n = 1e4)

