/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jpmml.lightgbm.LightGBMUtil;

public class Section
extends LinkedHashMap<String, String> {
    public Section() {
    }

    public Section(Section section) {
        super(section);
    }

    public boolean checkId(String id) {
        return this.checkId(id::equals);
    }

    public boolean checkId(Predicate<String> predicate) {
        return predicate.test(this.id());
    }

    public String id() {
        Map.Entry entry = (Map.Entry)Iterables.getFirst(this.entrySet(), null);
        if (entry == null) {
            throw new IllegalStateException();
        }
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        return value != null ? key + "=" + value : key;
    }

    public int getInt(String key) {
        return Integer.parseInt(this.get(key));
    }

    public int[] getIntArray(String key, int length) {
        return LightGBMUtil.parseIntArray(this.get(key), length);
    }

    public int[][] getIntArrayList(String key, int[] lengths) {
        return LightGBMUtil.parseIntArrayList(this.get(key), lengths);
    }

    public long parseUnsignedInt(String key) {
        return Long.parseLong(this.get(key));
    }

    public long[] getUnsignedIntArray(String key, int length) {
        return LightGBMUtil.parseUnsignedIntArray(this.get(key), length);
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.get(key));
    }

    public double[] getDoubleArray(String key, int length) {
        return LightGBMUtil.parseDoubleArray(this.get(key), length);
    }

    public double[][] getDoubleArrayList(String key, int[] lengths) {
        return LightGBMUtil.parseDoubleArrayList(this.get(key), lengths);
    }

    public String getString(String key) {
        String result = this.get(key, false);
        result = LightGBMUtil.unescape(result);
        return result;
    }

    public String[] getStringArray(String key, int length) {
        String[] result = LightGBMUtil.parseStringArray(this.get(key), length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = LightGBMUtil.unescape(result[i]);
        }
        return result;
    }

    public String get(String key) {
        return this.get(key, true);
    }

    public String get(String key, boolean required) {
        if (required && !super.containsKey(key)) {
            throw new IllegalArgumentException(key);
        }
        return (String)super.get(key);
    }

    public String put(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            return this.put(string.substring("[".length(), string.length() - "]".length()), ':');
        }
        return this.put(string, '=');
    }

    @Override
    public String put(String string, char separator) {
        String value;
        String key;
        int index = string.indexOf(separator);
        if (index > 0) {
            key = string.substring(0, index);
            value = string.substring(index + 1);
        } else {
            key = string;
            value = null;
        }
        return super.put(key, value);
    }
}

