/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openscience.cdk.graph.ShortestPaths;

final class InitialCycles {
    private final int[][] graph;
    private final int[] ordering;
    private final Map<Integer, Set<Cycle>> cycles = new TreeMap<Integer, Set<Cycle>>();
    private final Map<Edge, Integer> edgeToIndex;
    private final Edge[] edges;
    private static final int DEFAULT_DEGREE = 4;
    private int nDeg2Vertices;
    private final int limit;
    private final boolean biconnected;

    InitialCycles(int[][] graph) {
        this(graph, graph.length, false);
    }

    InitialCycles(int[][] graph, int limit) {
        this(graph, limit, false);
    }

    private InitialCycles(int[][] graph, int limit, boolean biconnected) {
        this.graph = Objects.requireNonNull(graph, "no graph provided");
        this.biconnected = biconnected;
        this.limit = limit;
        this.ordering = this.ordering(graph);
        this.edgeToIndex = new HashMap<Edge, Integer>(2 * graph.length);
        int n = graph.length;
        for (int v = 0; v < n; ++v) {
            for (int w : graph[v]) {
                if (w <= v) continue;
                Edge edge = new Edge(v, w);
                this.edgeToIndex.put(edge, this.edgeToIndex.size());
            }
        }
        this.edges = new Edge[this.edgeToIndex.size()];
        for (Map.Entry<Edge, Integer> e : this.edgeToIndex.entrySet()) {
            this.edges[e.getValue().intValue()] = e.getKey();
        }
        this.compute();
    }

    int[][] graph() {
        return this.graph;
    }

    Iterable<Integer> lengths() {
        return this.cycles.keySet();
    }

    Collection<Cycle> cyclesOfLength(int length) {
        return Collections.unmodifiableSet(this.cycles.getOrDefault(length, Collections.emptySet()));
    }

    Collection<Cycle> cycles() {
        TreeSet<Cycle> res = new TreeSet<Cycle>();
        for (Set<Cycle> val : this.cycles.values()) {
            res.addAll(val);
        }
        return Collections.unmodifiableSet(res);
    }

    int numberOfCycles() {
        int count = 0;
        for (Set<Cycle> val : this.cycles.values()) {
            count += val.size();
        }
        return count;
    }

    int numberOfEdges() {
        return this.edgeToIndex.size();
    }

    Edge edge(int i) {
        return this.edges[i];
    }

    int indexOfEdge(int u, int v) {
        return this.edgeToIndex.get(new Edge(u, v));
    }

    BitSet toEdgeVector(int[] path) {
        BitSet incidence = new BitSet(this.edgeToIndex.size());
        int len = path.length - 1;
        for (int i = 0; i < len; ++i) {
            incidence.set(this.indexOfEdge(path[i], path[i + 1]));
        }
        return incidence;
    }

    private void compute() {
        int first;
        int n = this.graph.length;
        int[] s = new int[n];
        int[] vertices = new int[n];
        for (int v = 0; v < n; ++v) {
            vertices[this.ordering[v]] = v;
        }
        for (int i = first = this.biconnected && this.nDeg2Vertices < n ? this.nDeg2Vertices : 2; i < n; ++i) {
            int r = vertices[i];
            ShortestPaths pathsFromR = new ShortestPaths(this.graph, null, r, this.limit / 2, this.ordering);
            for (int j = 0; j < i; ++j) {
                int y = vertices[j];
                if (!pathsFromR.isPrecedingPathTo(y)) continue;
                int sizeOfS = 0;
                for (int z : this.graph[y]) {
                    int distToY;
                    if (!pathsFromR.isPrecedingPathTo(z)) continue;
                    int distToZ = pathsFromR.distanceTo(z);
                    if (distToZ + 1 == (distToY = pathsFromR.distanceTo(y))) {
                        s[sizeOfS++] = z;
                        continue;
                    }
                    if (distToZ != distToY || this.ordering[z] >= this.ordering[y]) continue;
                    int[] pathToY = pathsFromR.pathTo(y);
                    int[] pathToZ = pathsFromR.pathTo(z);
                    if (!InitialCycles.singletonIntersect(pathToZ, pathToY)) continue;
                    OddCycle cycle = new OddCycle(pathsFromR, pathToY, pathToZ);
                    this.add(cycle);
                }
                for (int k = 0; k < sizeOfS; ++k) {
                    for (int l = k + 1; l < sizeOfS; ++l) {
                        int[] pathToQ;
                        int[] pathToP = pathsFromR.pathTo(s[k]);
                        if (!InitialCycles.singletonIntersect(pathToP, pathToQ = pathsFromR.pathTo(s[l]))) continue;
                        EvenCycle cycle = new EvenCycle(pathsFromR, pathToP, y, pathToQ);
                        this.add(cycle);
                    }
                }
            }
        }
    }

    private void add(Cycle cycle) {
        if (cycle.length() <= this.limit) {
            this.cycles.computeIfAbsent(cycle.length(), k -> new TreeSet()).add(cycle);
        }
    }

    private int[] ordering(int[][] graph) {
        int n = graph.length;
        int[] order = new int[n];
        int[] count = new int[5];
        for (int[] ints : graph) {
            int key = ints.length + 1;
            if (key >= count.length) {
                count = Arrays.copyOf(count, key * 2);
            }
            int n2 = key;
            count[n2] = count[n2] + 1;
        }
        for (int i = 1; i < count.length; ++i) {
            int n3 = i;
            count[n3] = count[n3] + count[i - 1];
        }
        for (int v = 0; v < n; ++v) {
            int n4 = graph[v].length;
            count[n4] = count[n4] + 1;
        }
        this.nDeg2Vertices = count[2];
        return order;
    }

    static boolean singletonIntersect(int[] p, int[] q) {
        int n = p.length;
        for (int i = 1; i < n; ++i) {
            if (p[i] != q[i]) continue;
            return false;
        }
        return true;
    }

    static int[] join(int[] pathToY, int[] pathToZ) {
        int[] path = Arrays.copyOf(pathToY, pathToY.length + pathToZ.length);
        int j = path.length - 1;
        for (int k : pathToZ) {
            path[j--] = k;
        }
        return path;
    }

    static int[] join(int[] pathToP, int y, int[] pathToQ) {
        int[] path = Arrays.copyOf(pathToP, 1 + pathToQ.length + pathToQ.length);
        path[pathToP.length] = y;
        int j = path.length - 1;
        for (int k : pathToQ) {
            path[j--] = k;
        }
        return path;
    }

    static InitialCycles ofBiconnectedComponent(int[][] graph) {
        return InitialCycles.ofBiconnectedComponent(graph, graph.length);
    }

    static InitialCycles ofBiconnectedComponent(int[][] graph, int limit) {
        return new InitialCycles(graph, limit, true);
    }

    static final class Edge {
        private final int v;
        private final int w;

        Edge(int v, int w) {
            this.v = v;
            this.w = w;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge that = (Edge)o;
            return this.v == that.v && this.w == that.w || this.v == that.w && this.w == that.v;
        }

        public int hashCode() {
            return this.v ^ this.w;
        }

        public String toString() {
            return "{" + this.v + ", " + this.w + "}";
        }
    }

    class OddCycle
    extends Cycle {
        final int y;
        final int z;

        OddCycle(ShortestPaths paths, int[] pathToY, int[] pathToZ) {
            super(paths, InitialCycles.join(pathToY, pathToZ));
            this.y = pathToY[pathToY.length - 1];
            this.z = pathToZ[pathToY.length - 1];
        }

        @Override
        BitSet edges(int[] path) {
            return InitialCycles.this.toEdgeVector(path);
        }

        @Override
        int[][] family() {
            int[][] pathsToY = this.paths.pathsTo(this.y);
            int[][] pathsToZ = this.paths.pathsTo(this.z);
            int[][] paths = new int[this.sizeOfFamily()][0];
            int i = 0;
            for (int[] pathToY : pathsToY) {
                for (int[] pathToZ : pathsToZ) {
                    paths[i++] = InitialCycles.join(pathToY, pathToZ);
                }
            }
            return paths;
        }

        @Override
        int sizeOfFamily() {
            return this.paths.nPathsTo(this.y) * this.paths.nPathsTo(this.z);
        }
    }

    class EvenCycle
    extends Cycle {
        final int p;
        final int q;
        final int y;

        EvenCycle(ShortestPaths paths, int[] pathToP, int y, int[] pathToQ) {
            super(paths, InitialCycles.join(pathToP, y, pathToQ));
            this.p = pathToP[pathToP.length - 1];
            this.q = pathToQ[pathToQ.length - 1];
            this.y = y;
        }

        @Override
        BitSet edges(int[] path) {
            return InitialCycles.this.toEdgeVector(path);
        }

        @Override
        int[][] family() {
            int[][] pathsToP = this.paths.pathsTo(this.p);
            int[][] pathsToQ = this.paths.pathsTo(this.q);
            int[][] paths = new int[this.sizeOfFamily()][0];
            int i = 0;
            for (int[] pathToP : pathsToP) {
                for (int[] pathToQ : pathsToQ) {
                    paths[i++] = InitialCycles.join(pathToP, this.y, pathToQ);
                }
            }
            return paths;
        }

        @Override
        int sizeOfFamily() {
            return this.paths.nPathsTo(this.p) * this.paths.nPathsTo(this.q);
        }
    }

    static abstract class Cycle
    implements Comparable<Cycle> {
        private final int[] path;
        final ShortestPaths paths;
        final BitSet edgeVector;

        Cycle(ShortestPaths paths, int[] path) {
            this.path = path;
            this.paths = paths;
            this.edgeVector = this.edges(path);
        }

        abstract BitSet edges(int[] var1);

        BitSet edgeVector() {
            return this.edgeVector;
        }

        int[] path() {
            return this.path;
        }

        abstract int[][] family();

        abstract int sizeOfFamily();

        int length() {
            return this.path.length - 1;
        }

        @Override
        public int compareTo(Cycle that) {
            int cmp = this.path.length - that.path.length;
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < this.path.length; ++i) {
                cmp = Integer.compare(this.path[i], that.path[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

