/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.FastIntervals;
import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.Intervals;
import dr.evolution.coalescent.MutableIntervalList;
import dr.evolution.coalescent.TreeIntervalList;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.util.ComparableDouble;
import dr.util.HeapSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeIntervals
extends AbstractModel
implements Units,
TreeIntervalList {
    private Tree tree = null;
    private Set<String> includedLeafSet = null;
    private Set[] excludedLeafSets = null;
    private final boolean buildIntervalNodeMapping;
    private MutableIntervalList intervals = null;
    private IntervalNodeMapping intervalNodeMapping;
    private MutableIntervalList storedIntervals = null;
    private boolean eventsKnown = false;
    private boolean storedEventsKnown = false;

    public TreeIntervals(Tree tree) {
        this(tree, true);
    }

    public TreeIntervals(Tree tree, boolean bl) {
        super("TreeIntervals");
        this.buildIntervalNodeMapping = bl;
        this.setup(tree);
    }

    public TreeIntervals(Tree tree, TaxonList taxonList, List<TaxonList> list) throws TreeUtils.MissingTaxonException {
        this(tree, taxonList, list, false);
    }

    public TreeIntervals(Tree tree, TaxonList taxonList, List<TaxonList> list, boolean bl) throws TreeUtils.MissingTaxonException {
        super("TreeIntervals");
        this.buildIntervalNodeMapping = bl;
        if (taxonList != null) {
            this.includedLeafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
        }
        if (list != null && list.size() > 0) {
            this.excludedLeafSets = new Set[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.excludedLeafSets[i] = TreeUtils.getLeavesForTaxa(tree, list.get(i));
            }
        } else {
            this.excludedLeafSets = null;
        }
        this.setup(tree);
    }

    private void setup(Tree tree) {
        this.tree = tree;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        if (this.buildIntervalNodeMapping) {
            this.intervals = new Intervals(tree.getNodeCount());
            this.storedIntervals = new Intervals(tree.getNodeCount());
        } else {
            this.intervals = new FastIntervals(tree.getExternalNodeCount(), tree.getInternalNodeCount());
            this.storedIntervals = new FastIntervals(tree.getExternalNodeCount(), tree.getInternalNodeCount());
        }
        this.eventsKnown = false;
        this.intervalNodeMapping = this.buildIntervalNodeMapping ? new IntervalNodeMapping.Default(tree.getNodeCount(), tree) : new IntervalNodeMapping.None();
        this.addStatistic(new DeltaStatistic());
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.eventsKnown = false;
        }
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedIntervals.copyIntervals(this.intervals);
        this.storedEventsKnown = this.eventsKnown;
        this.intervalNodeMapping.storeMapping();
    }

    @Override
    protected void restoreState() {
        MutableIntervalList mutableIntervalList = this.storedIntervals;
        this.storedIntervals = this.intervals;
        this.intervals = mutableIntervalList;
        this.eventsKnown = this.storedEventsKnown;
        this.intervalNodeMapping.restoreMapping();
    }

    @Override
    protected final void acceptState() {
    }

    public final Model getModel() {
        return this;
    }

    private NodeRef getIncludedMRCA(Tree tree) {
        if (this.includedLeafSet != null) {
            return TreeUtils.getCommonAncestorNode(tree, this.includedLeafSet);
        }
        return tree.getRoot();
    }

    private Set<NodeRef> getExcludedMRCAs(Tree tree) {
        if (this.excludedLeafSets == null || this.excludedLeafSets.length == 0) {
            return null;
        }
        HashSet<NodeRef> hashSet = new HashSet<NodeRef>();
        for (Set set : this.excludedLeafSets) {
            hashSet.add(TreeUtils.getCommonAncestorNode(tree, set));
        }
        return hashSet;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    public IntervalList getIntervals() {
        return this.intervals;
    }

    @Override
    public final void calculateIntervals() {
        this.intervals.resetEvents();
        if (this.includedLeafSet != null || this.excludedLeafSets != null) {
            this.collectTimes(this.tree, this.getIncludedMRCA(this.tree), this.getExcludedMRCAs(this.tree), this.intervals);
        } else {
            this.collectTimes(this.tree, this.intervals);
        }
        this.intervals.getIntervalCount();
        if (this.buildIntervalNodeMapping) {
            this.intervalNodeMapping.initializeMaps();
            for (int i = 0; i < this.intervals.getIntervalCount() + 1; ++i) {
                this.intervalNodeMapping.addNode(this.intervals.getNodeForEvent(i));
                if (i <= 0 || i >= this.intervals.getIntervalCount()) continue;
                this.intervalNodeMapping.addNode(this.intervals.getNodeForEvent(i));
            }
            this.intervalNodeMapping.setIntervalStartIndices(this.intervals.getIntervalCount());
        }
        this.eventsKnown = true;
    }

    private void collectTimes(Tree tree, NodeRef nodeRef, Set<NodeRef> set, MutableIntervalList mutableIntervalList) {
        mutableIntervalList.addCoalescentEvent(tree.getNodeHeight(nodeRef));
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            boolean bl = true;
            if (set != null && set.contains(nodeRef2)) {
                bl = false;
            }
            if (!bl || tree.isExternal(nodeRef2)) {
                mutableIntervalList.addSampleEvent(tree.getNodeHeight(nodeRef2));
                continue;
            }
            this.collectTimes(tree, nodeRef2, set, mutableIntervalList);
        }
    }

    private void collectTimes(Tree tree, MutableIntervalList mutableIntervalList) {
        int n;
        for (n = 0; n < tree.getExternalNodeCount(); ++n) {
            mutableIntervalList.addSampleEvent(tree.getNodeHeight(tree.getExternalNode(n)), tree.getExternalNode(n).getNumber());
        }
        for (n = 0; n < tree.getInternalNodeCount(); ++n) {
            mutableIntervalList.addCoalescentEvent(tree.getNodeHeight(tree.getInternalNode(n)), tree.getInternalNode(n).getNumber());
        }
    }

    @Override
    public double getStartTime() {
        return this.intervals.getStartTime();
    }

    @Override
    public int getIntervalCount() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalCount();
    }

    @Override
    public int getSampleCount() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getSampleCount();
    }

    @Override
    public double getInterval(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getInterval(n);
    }

    @Override
    public double getIntervalTime(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalTime(n);
    }

    @Override
    public int getLineageCount(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        if (n >= this.getIntervalCount()) {
            throw new IllegalArgumentException();
        }
        return this.intervals.getLineageCount(n);
    }

    @Override
    public int getCoalescentEvents(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getCoalescentEvents(n);
    }

    @Override
    public IntervalType getIntervalType(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getIntervalType(n);
    }

    @Override
    public double getTotalDuration() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.getTotalDuration();
    }

    @Override
    public boolean isBinaryCoalescent() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.isBinaryCoalescent();
    }

    @Override
    public boolean isCoalescentOnly() {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervals.isCoalescentOnly();
    }

    @Override
    public Units.Type getUnits() {
        return this.intervals.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.intervals.setUnits(type);
    }

    @Override
    public int[] getIntervalsForNode(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervalNodeMapping.getIntervalsForNode(n);
    }

    @Override
    public int[] getNodeNumbersForInterval(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervalNodeMapping.getNodeNumbersForInterval(n);
    }

    @Override
    public boolean isBuildIntervalNodeMapping() {
        return this.buildIntervalNodeMapping;
    }

    @Override
    public NodeRef getCoalescentNode(int n) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        if (this.getIntervalType(n) != IntervalType.COALESCENT) {
            throw new IllegalArgumentException("Not a coalescent interval");
        }
        return this.tree.getNode(this.intervalNodeMapping.getNodeNumbersForInterval(n)[1]);
    }

    @Override
    public double[] sortByNodeNumbers(double[] dArray) {
        if (!this.eventsKnown) {
            this.calculateIntervals();
        }
        return this.intervalNodeMapping.sortByNodeNumbers(dArray);
    }

    @Override
    public double[] getCoalescentIntervals() {
        double[] dArray = new double[this.tree.getInternalNodeCount()];
        int n = 0;
        for (int i = 0; i < this.intervals.getIntervalCount(); ++i) {
            if (this.getIntervalType(i) != IntervalType.COALESCENT) continue;
            dArray[n] = this.getInterval(i);
            ++n;
        }
        return dArray;
    }

    public static interface IntervalNodeMapping {
        public void addNode(int var1);

        public void setIntervalStartIndices(int var1);

        public void initializeMaps();

        public void mapNodeInterval(int var1, int var2);

        public void storeMapping();

        public void restoreMapping();

        public int[] getIntervalsForNode(int var1);

        public int[] getNodeNumbersForInterval(int var1);

        public double[] sortByNodeNumbers(double[] var1);

        public static class None
        implements IntervalNodeMapping {
            @Override
            public void addNode(int n) {
            }

            @Override
            public void setIntervalStartIndices(int n) {
            }

            @Override
            public void initializeMaps() {
            }

            @Override
            public void mapNodeInterval(int n, int n2) {
            }

            @Override
            public int[] getIntervalsForNode(int n) {
                throw new RuntimeException("No intervalNodeMapping available. This function should not be called.");
            }

            @Override
            public int[] getNodeNumbersForInterval(int n) {
                throw new RuntimeException("No intervalNodeMapping available. This function should not be called.");
            }

            @Override
            public double[] sortByNodeNumbers(double[] dArray) {
                throw new RuntimeException("No intervalNodeMapping available. This function should not be called.");
            }

            @Override
            public void storeMapping() {
            }

            @Override
            public void restoreMapping() {
            }
        }

        public static class Default
        implements IntervalNodeMapping {
            private int[] nodeNumbersInIntervals;
            private int[] intervalStartIndices;
            private int[] intervalNumberOfNodes;
            private int[] storedNodeNumbersInIntervals;
            private int[] storedIntervalStartIndices;
            private int[] storedIntervalNumberOfNodes;
            private int nextIndex = 0;
            private int nIntervals;
            private Tree tree;
            private final int maxIndicesPerNode = 3;

            public Default(int n, Tree tree) {
                this.nodeNumbersInIntervals = new int[3 * n];
                this.storedNodeNumbersInIntervals = new int[3 * n];
                this.intervalStartIndices = new int[n];
                this.storedIntervalStartIndices = new int[n];
                this.intervalNumberOfNodes = new int[3 * n];
                this.storedIntervalNumberOfNodes = new int[3 * n];
                this.tree = tree;
            }

            @Override
            public void addNode(int n) {
                if (this.nextIndex > 500) {
                    // empty if block
                }
                this.nodeNumbersInIntervals[this.nextIndex] = n;
                ++this.nextIndex;
            }

            @Override
            public void mapNodeInterval(int n, int n2) {
                int n3;
                for (n3 = 0; n3 < 3; ++n3) {
                    if (this.intervalNumberOfNodes[3 * n + n3] != -1) continue;
                    this.intervalNumberOfNodes[3 * n + n3] = n2;
                    break;
                }
                if (n3 == 3) {
                    throw new RuntimeException("The node appears in more than3 intervals!");
                }
            }

            @Override
            public void setIntervalStartIndices(int n) {
                if (this.nodeNumbersInIntervals[this.nextIndex - 1] == this.nodeNumbersInIntervals[this.nextIndex - 2]) {
                    this.nodeNumbersInIntervals[this.nextIndex - 1] = 0;
                    --this.nextIndex;
                }
                int n2 = 1;
                this.mapNodeInterval(this.nodeNumbersInIntervals[0], 0);
                for (int i = 1; i < n; ++i) {
                    while (this.nodeNumbersInIntervals[n2] != this.nodeNumbersInIntervals[n2 - 1]) {
                        this.mapNodeInterval(this.nodeNumbersInIntervals[n2], i - 1);
                        ++n2;
                    }
                    this.intervalStartIndices[i] = n2;
                    this.mapNodeInterval(this.nodeNumbersInIntervals[n2], i);
                    ++n2;
                }
                while (n2 < this.nextIndex) {
                    this.mapNodeInterval(this.nodeNumbersInIntervals[n2], n - 1);
                    ++n2;
                }
                this.nIntervals = n;
            }

            @Override
            public void initializeMaps() {
                Arrays.fill(this.intervalNumberOfNodes, -1);
                Arrays.fill(this.intervalStartIndices, 0);
                Arrays.fill(this.nodeNumbersInIntervals, 0);
                this.nextIndex = 0;
            }

            @Override
            public int[] getIntervalsForNode(int n) {
                int n2 = 0;
                while (this.intervalNumberOfNodes[3 * n + n2] != -1) {
                    ++n2;
                }
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = this.intervalNumberOfNodes[3 * n + i];
                }
                return nArray;
            }

            @Override
            public int[] getNodeNumbersForInterval(int n) {
                assert (n < this.nIntervals);
                int n2 = this.intervalStartIndices[n];
                int n3 = n == this.nIntervals - 1 ? this.nextIndex - 1 : this.intervalStartIndices[n + 1] - 1;
                int[] nArray = new int[n3 - n2 + 1];
                for (int i = 0; i < n3 - n2 + 1; ++i) {
                    nArray[i] = this.nodeNumbersInIntervals[n2 + i];
                }
                return nArray;
            }

            @Override
            public double[] sortByNodeNumbers(double[] dArray) {
                int n;
                double[] dArray2 = new double[dArray.length];
                int[] nArray = new int[dArray.length];
                ArrayList<ComparableDouble> arrayList = new ArrayList<ComparableDouble>();
                for (n = 0; n < nArray.length; ++n) {
                    arrayList.add(new ComparableDouble(this.getIntervalsForNode(n + this.tree.getExternalNodeCount())[0]));
                }
                HeapSort.sort(arrayList, nArray);
                for (n = 0; n < nArray.length; ++n) {
                    dArray2[nArray[n]] = dArray[n];
                }
                return dArray2;
            }

            @Override
            public void storeMapping() {
                System.arraycopy(this.nodeNumbersInIntervals, 0, this.storedNodeNumbersInIntervals, 0, this.nodeNumbersInIntervals.length);
                System.arraycopy(this.intervalNumberOfNodes, 0, this.storedIntervalNumberOfNodes, 0, this.intervalNumberOfNodes.length);
                System.arraycopy(this.intervalStartIndices, 0, this.storedIntervalStartIndices, 0, this.intervalStartIndices.length);
            }

            @Override
            public void restoreMapping() {
                int[] nArray = this.storedNodeNumbersInIntervals;
                this.storedNodeNumbersInIntervals = this.nodeNumbersInIntervals;
                this.nodeNumbersInIntervals = nArray;
                int[] nArray2 = this.storedIntervalNumberOfNodes;
                this.storedIntervalNumberOfNodes = this.intervalNumberOfNodes;
                this.intervalNumberOfNodes = nArray2;
                int[] nArray3 = this.storedIntervalStartIndices;
                this.storedIntervalStartIndices = this.intervalStartIndices;
                this.intervalStartIndices = nArray3;
            }
        }
    }

    public class DeltaStatistic
    extends Statistic.Abstract {
        public DeltaStatistic() {
            super("delta");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            throw new RuntimeException("Not implemented");
        }
    }
}

