/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.epidemiology.DynamicalSystem;
import dr.evomodel.epidemiology.SIRModelParser;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.math.distributions.NormalDistribution;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SIRModel
extends DemographicModel
implements Likelihood {
    private boolean isUsed = false;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private double storedLogLikelihood;
    private double stepSize = 0.01;
    private double endTime = 5.0;
    Parameter reproductiveNumberParameter = null;
    Parameter recoveryRateParameter = null;
    Parameter hostPopulationSizeParameter = null;
    Parameter proportionsParameter = null;
    SIRDemographicFunction demographicFunction = null;

    public SIRModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        this(SIRModelParser.SIR_MODEL, parameter, parameter2, parameter3, parameter4, type);
    }

    public SIRModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        super(string);
        this.reproductiveNumberParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 1.0, 1));
        this.recoveryRateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.hostPopulationSizeParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.proportionsParameter = parameter4;
        this.addVariable(parameter4);
        this.demographicFunction = new SIRDemographicFunction(type);
        this.setUnits(type);
        this.addStatistic(new TimeseriesStatistic("susceptibles"));
        this.addStatistic(new TimeseriesStatistic("infecteds"));
        this.addStatistic(new TimeseriesStatistic("recovereds"));
        this.addStatistic(new TimeseriesStatistic("effectivePopulationSize"));
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.demographicFunction.reset();
        this.fireModelChanged();
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
        this.demographicFunction.store();
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
        this.demographicFunction.restore();
    }

    public double getSusceptibles(double d) {
        return this.demographicFunction.getSusceptibles(d);
    }

    public double getInfecteds(double d) {
        return this.demographicFunction.getInfecteds(d);
    }

    public double getRecovereds(double d) {
        return this.demographicFunction.getRecovereds(d);
    }

    public double getEffectivePopulationSize(double d) {
        return this.demographicFunction.getDemographic(d);
    }

    @Override
    public String prettyName() {
        return Likelihood.Abstract.getPrettyName(this);
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.getLikelihoodKnown()) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    protected boolean getLikelihoodKnown() {
        return this.likelihoodKnown;
    }

    @Override
    public boolean evaluateEarly() {
        return false;
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this));
    }

    @Override
    public boolean isUsed() {
        return this.isUsed;
    }

    @Override
    public void setUsed() {
        this.isUsed = true;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId())};
    }

    public double calculateLogLikelihood() {
        double d = this.demographicFunction.getRecovereds(this.endTime);
        return NormalDistribution.logPdf(d, 0.0, 100.0);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        return this.demographicFunction;
    }

    class SIRDemographicFunction
    extends DemographicFunction.Abstract {
        DynamicalSystem syst;

        public SIRDemographicFunction(Units.Type type) {
            super(type);
            this.syst = new DynamicalSystem(0.0, 0.01);
            double d = SIRModel.this.hostPopulationSizeParameter.getParameterValue(0);
            double d2 = d * SIRModel.this.proportionsParameter.getParameterValue(0);
            double d3 = d * SIRModel.this.proportionsParameter.getParameterValue(1);
            double d4 = d * SIRModel.this.proportionsParameter.getParameterValue(2);
            this.syst.addVariable("susceptibles", d2);
            this.syst.addVariable("infecteds", d3);
            this.syst.addVariable("recovereds", d4);
            this.syst.addVariable("total", d);
            this.syst.addForce("contact", SIRModel.this.reproductiveNumberParameter.getParameterValue(0) * SIRModel.this.recoveryRateParameter.getParameterValue(0), new String[]{"infecteds", "susceptibles"}, new String[]{"total"}, "susceptibles", "infecteds");
            this.syst.addForce("recovery", SIRModel.this.recoveryRateParameter.getParameterValue(0), new String[]{"infecteds"}, new String[0], "infecteds", "recovereds");
        }

        public void reset() {
            double d = SIRModel.this.hostPopulationSizeParameter.getParameterValue(0);
            double d2 = d * SIRModel.this.proportionsParameter.getParameterValue(0);
            double d3 = d * SIRModel.this.proportionsParameter.getParameterValue(1);
            double d4 = d * SIRModel.this.proportionsParameter.getParameterValue(2);
            this.syst.resetVar("susceptibles", d2);
            this.syst.resetVar("infecteds", d3);
            this.syst.resetVar("recovereds", d4);
            this.syst.resetVar("total", d);
            this.syst.resetForce("contact", SIRModel.this.reproductiveNumberParameter.getParameterValue(0) * SIRModel.this.recoveryRateParameter.getParameterValue(0));
            this.syst.resetForce("recovery", SIRModel.this.recoveryRateParameter.getParameterValue(0));
            this.syst.resetTime();
        }

        public void store() {
            this.syst.store();
        }

        public void restore() {
            this.syst.restore();
        }

        @Override
        public double getDemographic(double d) {
            double d2;
            double d3 = SIRModel.this.reproductiveNumberParameter.getParameterValue(0) * SIRModel.this.recoveryRateParameter.getParameterValue(0);
            double d4 = this.getInfecteds(d) * SIRModel.this.hostPopulationSizeParameter.getParameterValue(0);
            double d5 = d4 / (d2 = 2.0 * d3 * this.getSusceptibles(d));
            if (d5 < 0.001) {
                d5 = 0.001;
            }
            return d5;
        }

        @Override
        public double getLogDemographic(double d) {
            return Math.log(this.getDemographic(d));
        }

        public double getSusceptibles(double d) {
            return this.syst.getValue("susceptibles", d);
        }

        public double getInfecteds(double d) {
            return this.syst.getValue("infecteds", d);
        }

        public double getRecovereds(double d) {
            return this.syst.getValue("recovereds", d);
        }

        @Override
        public double getIntensity(double d) {
            return 1.0;
        }

        @Override
        public double getInverseIntensity(double d) {
            return 1.0;
        }

        @Override
        public double getIntegral(double d, double d2) {
            double d3 = 0.5 * (this.getDemographic(d) + this.getDemographic(d2));
            double d4 = (d2 - d) * (1.0 / d3);
            return d4;
        }

        @Override
        public int getNumArguments() {
            return 0;
        }

        @Override
        public String getArgumentName(int n) {
            return null;
        }

        @Override
        public double getArgument(int n) {
            return 0.0;
        }

        @Override
        public void setArgument(int n, double d) {
        }

        @Override
        public double getLowerBound(int n) {
            return 0.0;
        }

        @Override
        public double getUpperBound(int n) {
            return 0.0;
        }

        public DemographicFunction getCopy() {
            return null;
        }

        @Override
        public double getThreshold() {
            return 0.0;
        }
    }

    public class TimeseriesStatistic
    extends Statistic.Abstract {
        public TimeseriesStatistic(String string) {
            super(string);
        }

        @Override
        public String getDimensionName(int n) {
            double d = (double)n * SIRModel.this.stepSize;
            return Double.toString(d);
        }

        @Override
        public int getDimension() {
            return (int)(SIRModel.this.endTime / SIRModel.this.stepSize);
        }

        @Override
        public double getStatisticValue(int n) {
            double d = (double)n * SIRModel.this.stepSize;
            if (this.getStatisticName().equals("susceptibles")) {
                return SIRModel.this.getSusceptibles(d);
            }
            if (this.getStatisticName().equals("infecteds")) {
                return SIRModel.this.getInfecteds(d);
            }
            if (this.getStatisticName().equals("recovereds")) {
                return SIRModel.this.getRecovereds(d);
            }
            if (this.getStatisticName().equals("effectivePopulationSize")) {
                return SIRModel.this.getEffectivePopulationSize(d);
            }
            return 0.0;
        }
    }

    protected class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return SIRModel.this.getLogLikelihood();
        }
    }
}

