/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import beagle.BeagleInfo;
import java.util.ArrayList;
import java.util.List;

public class BeagleFunctionality {
    private static boolean checkGTEVersion(int[] nArray) {
        int[] nArray2 = BeagleInfo.getVersionNumbers();
        if (nArray.length == 0 || nArray2.length == 0) {
            return false;
        }
        for (int i = 0; i < nArray.length && i < nArray2.length; ++i) {
            if (nArray2[i] > nArray[i]) {
                return true;
            }
            if (nArray2[i] >= nArray[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean IS_THREAD_COUNT_COMPATIBLE() {
        return BeagleFunctionality.checkGTEVersion(new int[]{3, 1});
    }

    public static boolean IS_ODD_STATE_SSE_FIXED() {
        return BeagleFunctionality.checkGTEVersion(new int[]{3, 1, 3});
    }

    static boolean IS_PRE_ORDER_SUPPORTED() {
        int[] nArray = BeagleInfo.getVersionNumbers();
        return BeagleFunctionality.checkGTEVersion(new int[]{3, 2});
    }

    static boolean IS_MULTI_PARTITION_COMPATIBLE() {
        int[] nArray = BeagleInfo.getVersionNumbers();
        return BeagleFunctionality.checkGTEVersion(new int[]{3});
    }

    public static List<Integer> parseSystemPropertyIntegerArray(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string2 = System.getProperty(string);
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                try {
                    int n = Integer.parseInt(string3.trim());
                    arrayList.add(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid entry '" + string3 + "' in " + string);
                }
            }
        }
        return arrayList;
    }

    public static List<Long> parseSystemPropertyLongArray(String string) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string2 = System.getProperty(string);
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                try {
                    long l = Long.parseLong(string3.trim());
                    arrayList.add(l);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid entry '" + string3 + "' in " + string);
                }
            }
        }
        return arrayList;
    }

    public static List<String> parseSystemPropertyStringArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.getProperty(string);
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                try {
                    String string4 = string3.trim();
                    arrayList.add(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid entry '" + string3 + "' in " + string);
                }
            }
        }
        return arrayList;
    }
}

