/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.app.gui.chart.LinearAxis;
import dr.stats.Variate;
import dr.util.FrequencyDistribution;

public class DensityEstimate {
    protected final Variate.D samples;
    protected Variate.D xCoordinates;
    protected Variate.D yCoordinates;
    protected FrequencyDistribution frequencyDistribution;

    public DensityEstimate(Double[] doubleArray, int n) {
        this.samples = new Variate.D(doubleArray);
        this.calculateDensity(this.samples, n);
    }

    protected void calculateDensity(Variate.D d, int n) {
        this.frequencyDistribution = this.calculateFrequencies(this.samples, n);
        this.xCoordinates = new Variate.D();
        this.yCoordinates = new Variate.D();
        double d2 = this.frequencyDistribution.getLowerBound() - this.frequencyDistribution.getBinSize();
        this.xCoordinates.add(d2 + this.frequencyDistribution.getBinSize() / 2.0);
        this.yCoordinates.add(0.0);
        d2 += this.frequencyDistribution.getBinSize();
        for (int i = 0; i < this.frequencyDistribution.getBinCount(); ++i) {
            this.xCoordinates.add(d2 + this.frequencyDistribution.getBinSize() / 2.0);
            double d3 = (double)this.frequencyDistribution.getFrequency(i) / this.frequencyDistribution.getBinSize() / (double)d.getCount();
            this.yCoordinates.add(d3);
            d2 += this.frequencyDistribution.getBinSize();
        }
        this.xCoordinates.add(d2 + this.frequencyDistribution.getBinSize() / 2.0);
        this.yCoordinates.add(0.0);
    }

    protected FrequencyDistribution calculateFrequencies(Variate variate, int n) {
        double d;
        double d2 = (Double)variate.getMin();
        if (d2 == (d = ((Double)variate.getMax()).doubleValue())) {
            d2 = d2 == 0.0 ? -1.0 : (d2 -= Math.abs(d2 / 10.0));
            d = d == 0.0 ? 1.0 : (d += Math.abs(d / 10.0));
        }
        LinearAxis linearAxis = new LinearAxis(0, 0);
        linearAxis.setRange(d2, d);
        int n2 = linearAxis.getMajorTickCount();
        linearAxis.setPrefNumTicks(n2, 4);
        double d3 = linearAxis.getMinorTickSpacing();
        int n3 = (int)((linearAxis.getMaxAxis() - linearAxis.getMinAxis()) / d3) + 2;
        if (n > 0) {
            while (n3 < n) {
                linearAxis.setPrefNumTicks(++n2, 4);
                d3 = linearAxis.getMinorTickSpacing();
                n3 = (int)((linearAxis.getMaxAxis() - linearAxis.getMinAxis()) / d3) + 2;
            }
        }
        FrequencyDistribution frequencyDistribution = new FrequencyDistribution(linearAxis.getMinAxis(), n3, d3);
        for (int i = 0; i < variate.getCount(); ++i) {
            frequencyDistribution.addValue((Double)variate.get(i));
        }
        return frequencyDistribution;
    }

    public Variate.D getXCoordinates() {
        return this.xCoordinates;
    }

    public Variate.D getYCoordinates() {
        return this.yCoordinates;
    }

    public FrequencyDistribution getFrequencyDistribution() {
        return this.frequencyDistribution;
    }
}

