/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc4;

import com.amazon.dsi.dataengine.interfaces.IArray;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SArray;
import com.amazon.jdbc.common.SForwardResultSet;
import com.amazon.jdbc.common.SStatement;
import com.amazon.jdbc.jdbc4.S4Array;
import com.amazon.jdbc.jdbc4.S4ResultSetMetaData;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.utilities.JDBCVersion;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S4ForwardResultSet
extends SForwardResultSet {
    public S4ForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        this.m_jdbcVersion = JDBCVersion.JDBC4;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S4ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SArray createArrayResult(IArray iArray) throws SQLException {
        return new S4Array(iArray, this.getParentConnection(), this.getLogger(), this.getWarningListener());
    }
}

