/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.jdbc.driver.NoSupportHAManager;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ServiceMember;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.simplefan.FanEventListener;
import oracle.simplefan.FanManager;
import oracle.simplefan.FanSubscription;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY})
public class HAManager {
    private ConcurrentHashMap<String, Map<String, ServiceMember>> services;
    private ConcurrentHashMap<String, Map<String, ServiceMember>> hosts;
    private Map<String, Integer> cardinalities = new HashMap<String, Integer>();
    private static final String FAN_SERVICE_NAME_PROPERTY = "serviceName";
    private FanManager fanMngr = null;
    private FanSubscription fanSubscription = null;
    static final ConcurrentHashMap<String, HAManager> allManagers = new ConcurrentHashMap();
    static final String FAN_CONFIG_PROPERTY = "oracle.jdbc.fanONSConfig";
    private Timer timer = null;
    private int drainIntervals = 0;
    private final AtomicInteger remainingIntervals = new AtomicInteger();
    private int targetDrainCountTotal = 0;
    private int targetDrainCountPerInterval = 0;
    private final AtomicInteger currentDrainTarget = new AtomicInteger();
    private final AtomicInteger currentDrainCount = new AtomicInteger();
    private TimerTask drainingTimerTask = null;
    private TimerTask delayedDrainingTimerTask = null;
    private static AtomicBoolean dependentJarsChecked = new AtomicBoolean(false);
    private static boolean allDependentJarsPresent = true;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    HAManager() {
        this.services = new ConcurrentHashMap();
        this.hosts = new ConcurrentHashMap();
        this.timer = new Timer(true);
    }

    HAManager(String string) throws SQLException {
        this();
        this.configure(string);
    }

    static HAManager getInstance(String string) throws SQLException {
        return new HAManager(string);
    }

    private void configure(String string) throws SQLException {
        block2: {
            assert (string != null && !"".equals(string)) : "onsConfigStr: " + string;
            if (this.fanMngr != null) break block2;
            this.fanMngr = FanManager.getInstance();
            if (string != null && !"".equals(string)) {
                Properties properties = new Properties();
                properties.setProperty("onsRemoteConfig", string);
                this.fanMngr.configure(properties);
            }
        }
    }

    private void addService(String string) throws SQLException {
        block3: {
            assert (string != null && !"".equals(string)) : "currentServiceName: " + string;
            if (this.fanMngr == null) break block3;
            Properties properties = new Properties();
            properties.setProperty(FAN_SERVICE_NAME_PROPERTY, string);
            this.fanSubscription = this.fanMngr.subscribe(properties);
            FanEventListener fanEventListener = null;
            try {
                Class<?> clazz = Class.forName("oracle.jdbc.driver.HAFanListener");
                Constructor<?> constructor = clazz.getDeclaredConstructor(HAManager.class);
                fanEventListener = (FanEventListener)constructor.newInstance(this);
            }
            catch (Throwable throwable) {
                throw new SQLException("Metadata error: error while creating FAN listener");
            }
            this.fanSubscription.addListener(fanEventListener);
        }
    }

    void addConnection(OracleConnection oracleConnection) throws SQLException {
        Properties properties = oracleConnection.getServerSessionInfo();
        String string = HAManager.toLowerCase(properties.getProperty("SERVICE_NAME"));
        String string2 = HAManager.toLowerCase(properties.getProperty("INSTANCE_NAME"));
        String string3 = HAManager.toLowerCase(properties.getProperty("DATABASE_NAME"));
        String string4 = HAManager.toLowerCase(properties.getProperty("SERVER_HOST"));
        String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
        ConcurrentHashMap<String, ServiceMember> concurrentHashMap = new ConcurrentHashMap<String, ServiceMember>();
        Map map = this.services.putIfAbsent(string, concurrentHashMap);
        if (map == null) {
            this.addService(string);
            ServiceMember serviceMember = new ServiceMember(string, string2, string3, string4);
            serviceMember.up();
            serviceMember.addConnection(oracleConnection);
            concurrentHashMap.put(string5, serviceMember);
        } else {
            ServiceMember serviceMember = (ServiceMember)map.get(string5);
            if (serviceMember != null) {
                serviceMember.up();
                serviceMember.addConnection(oracleConnection);
            } else {
                serviceMember = new ServiceMember(string, string2, string3, string4);
                serviceMember.up();
                serviceMember.addConnection(oracleConnection);
                map.put(string5, serviceMember);
            }
        }
        oracleConnection.setHAManager(this);
    }

    public void dropConnection(OracleConnection oracleConnection) throws SQLException {
        Properties properties = oracleConnection.getServerSessionInfo();
        String string = HAManager.toLowerCase(properties.getProperty("SERVICE_NAME"));
        String string2 = HAManager.toLowerCase(properties.getProperty("INSTANCE_NAME"));
        String string3 = HAManager.toLowerCase(properties.getProperty("DATABASE_NAME"));
        String string4 = HAManager.toLowerCase(properties.getProperty("SERVER_HOST"));
        String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
        Map<String, ServiceMember> map = this.services.get(string);
        if (map == null) {
            throw new SQLException("Metadata error: no member instances for service");
        }
        ServiceMember serviceMember = map.get(string5);
        if (serviceMember == null) {
            throw new SQLException("Metadata error: no member instance for service");
        }
        serviceMember.dropConnection(oracleConnection);
    }

    void plannedDown(String string, String string2, String string3, String string4, int n2) {
        try {
            Map<String, ServiceMember> map = this.services.get(string);
            if (map == null) {
                return;
            }
            if (string2 == null) {
                for (ServiceMember serviceMember : map.values()) {
                    if (!serviceMember.getDatabase().equalsIgnoreCase(string3)) continue;
                    serviceMember.down();
                }
            } else {
                String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
                ServiceMember serviceMember = map.get(string5);
                if (serviceMember != null) {
                    serviceMember.down();
                    this.drainGracefully(serviceMember, map, n2);
                }
            }
        }
        catch (Throwable throwable) {
        }
    }

    private void drainGracefully(ServiceMember serviceMember, Map<String, ServiceMember> map, int n2) {
        if (n2 > 0) {
            this.drainIntervals = (n2 + 10 - 1) / 10;
            this.remainingIntervals.set(this.drainIntervals);
            this.targetDrainCountTotal = serviceMember.connCount;
            this.targetDrainCountPerInterval = (this.targetDrainCountTotal + this.drainIntervals - 1) / this.drainIntervals;
            this.currentDrainCount.set(0);
            this.currentDrainTarget.set(0);
            this.drainingTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (HAManager.this.remainingIntervals.get() > 0) {
                        int n2 = HAManager.this.targetDrainCountTotal - HAManager.this.currentDrainCount.get();
                        int n3 = Math.min(HAManager.this.targetDrainCountPerInterval, n2);
                        HAManager.this.currentDrainTarget.addAndGet(n3);
                        HAManager.this.remainingIntervals.decrementAndGet();
                    }
                }
            };
            boolean bl = true;
            for (ServiceMember serviceMember2 : map.values()) {
                if (!serviceMember2.isUp()) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.delayedDrainingTimerTask = this.drainingTimerTask;
            } else {
                this.scheduleTimerTask(this.drainingTimerTask, this.drainIntervals);
            }
        }
    }

    private void scheduleTimerTask(TimerTask timerTask, int n2) {
        if (n2 > 0) {
            this.timer.schedule(timerTask, 0L, (long)n2 * 1000L);
        } else {
            this.timer.schedule(timerTask, 0L);
        }
    }

    void unplannedDown(String string, String string2, String string3, String string4) {
        try {
            Map<String, ServiceMember> map = this.services.get(string);
            if (map == null) {
                return;
            }
            if (string2 == null) {
                for (ServiceMember serviceMember : map.values()) {
                    if (!serviceMember.getDatabase().equalsIgnoreCase(string3)) continue;
                    serviceMember.down();
                    serviceMember.cleanupConnections();
                }
            } else {
                String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
                ServiceMember serviceMember = map.get(string5);
                if (serviceMember != null) {
                    serviceMember.down();
                    serviceMember.cleanupConnections();
                }
            }
        }
        catch (Throwable throwable) {
        }
    }

    void nodeDown(String string) {
        try {
            Map<String, ServiceMember> map = this.hosts.get(string);
            if (map == null) {
                return;
            }
            for (ServiceMember serviceMember : map.values()) {
                serviceMember.down();
                serviceMember.cleanupConnections();
            }
        }
        catch (Throwable throwable) {
        }
    }

    void serviceUp(String string, String string2, String string3, String string4, int n2) {
        try {
            String string5;
            if (!this.services.containsKey(string)) {
                return;
            }
            if (string2 == null) {
                this.cardinalities.put(string, n2);
                return;
            }
            Map<String, ServiceMember> map = this.services.get(string);
            ServiceMember serviceMember = map.get(string5 = string + "###" + string2 + "###" + string3 + "###" + string4);
            if (serviceMember != null) {
                serviceMember.up();
                this.cardinalities.put(string, n2);
                if (this.delayedDrainingTimerTask != null) {
                    this.scheduleTimerTask(this.drainingTimerTask, this.drainIntervals);
                }
            }
        }
        catch (Throwable throwable) {
        }
    }

    public boolean isServiceMemberDown(OracleConnection oracleConnection) throws SQLException {
        Properties properties = oracleConnection.getServerSessionInfo();
        String string = HAManager.toLowerCase(properties.getProperty("SERVICE_NAME"));
        String string2 = HAManager.toLowerCase(properties.getProperty("INSTANCE_NAME"));
        String string3 = HAManager.toLowerCase(properties.getProperty("DATABASE_NAME"));
        String string4 = HAManager.toLowerCase(properties.getProperty("SERVER_HOST"));
        String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
        Map<String, ServiceMember> map = this.services.get(string);
        if (map != null) {
            ServiceMember serviceMember = map.get(string5);
            return serviceMember.isDown();
        }
        return false;
    }

    public boolean checkAndDrain(OracleConnection oracleConnection) throws SQLException {
        boolean bl = false;
        if (this.drainIntervals > 0) {
            if (this.remainingIntervals.get() == 0) {
                if (this.drainingTimerTask != null) {
                    this.drainingTimerTask.cancel();
                }
                this.drainingTimerTask = null;
                if (this.delayedDrainingTimerTask != null) {
                    this.delayedDrainingTimerTask.cancel();
                }
                this.delayedDrainingTimerTask = null;
                this.drainIntervals = 0;
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        if (this.isServiceMemberDown(oracleConnection) && (bl || this.currentDrainCount.get() < this.currentDrainTarget.get())) {
            ((PhysicalConnection)oracleConnection).closeConnectionSafely();
            this.currentDrainCount.incrementAndGet();
            return true;
        }
        return false;
    }

    public static void enableHAIfNecessary(String string, OracleConnection oracleConnection) throws SQLException {
        Object object;
        boolean bl = true;
        if (dependentJarsChecked.compareAndSet(false, true)) {
            try {
                object = oracleConnection.getClass().getClassLoader();
                Class.forName("oracle.simplefan.FanManager", false, (ClassLoader)object);
                Class.forName("oracle.ons.ONS", false, (ClassLoader)object);
                allDependentJarsPresent = true;
            }
            catch (Throwable throwable) {
                allDependentJarsPresent = false;
                bl = false;
            }
        }
        if (!allDependentJarsPresent) {
        } else {
            object = allManagers.get(string);
            if (object == null) {
                String string2 = System.getProperty(FAN_CONFIG_PROPERTY);
                short s2 = oracleConnection.getVersionNumber();
                String string3 = null;
                if (s2 < 11100) {
                    bl = false;
                } else if (string2 != null && !"".equals(string2)) {
                    bl = true;
                    string3 = string2;
                } else {
                    Properties properties = oracleConnection.getServerSessionInfo();
                    String string4 = properties.getProperty("AUTH_ONS_CONFIG");
                    if (s2 >= 12101) {
                        if (string4 == null) {
                            bl = false;
                        } else {
                            bl = true;
                            string3 = string4;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (bl) {
                    try {
                        object = HAManager.getInstance(string3);
                    }
                    catch (Throwable throwable) {
                        bl = false;
                        object = NoSupportHAManager.getInstance();
                    }
                } else {
                    object = NoSupportHAManager.getInstance();
                }
                allManagers.putIfAbsent(string, (HAManager)object);
            }
            ((HAManager)object).addConnection(oracleConnection);
        }
    }

    public static void shutdownAll() {
        for (HAManager hAManager : allManagers.values()) {
            if (hAManager == null) continue;
            hAManager.close();
        }
    }

    public void close() {
        if (this.fanSubscription != null) {
            this.fanSubscription.close();
        }
    }

    final String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(1024);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    private static String toLowerCase(String string) {
        return null == string ? null : string.toLowerCase();
    }
}

