/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;

public class SparseRCMDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseDComplexMatrix1D[] elements;

    public SparseRCMDComplexMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseDComplexMatrix1D[n];
        for (int i = 0; i < n; ++i) {
            this.elements[i] = new SparseDComplexMatrix1D(n2);
        }
    }

    public SparseDComplexMatrix1D[] elements() {
        return this.elements;
    }

    public double[] getQuick(int n, int n2) {
        return this.elements[n].getQuick(n2);
    }

    public void setQuick(int n, int n2, double[] dArray) {
        this.elements[n].setQuick(n2, dArray);
    }

    public void setQuick(int n, int n2, double d, double d2) {
        this.elements[n].setQuick(n2, d, d2);
    }

    public void trimToSize() {
        for (int i = 0; i < this.rows; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseDComplexMatrix1D viewRow(int n) {
        return this.elements[n];
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }

    public DComplexMatrix2D like(int n, int n2) {
        return new SparseRCMDComplexMatrix2D(n, n2);
    }
}

