/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree;

import net.sf.jclec.IConfigure;
import net.sf.jclec.exprtree.IPrimitive;
import net.sf.jclec.syntaxtree.AbstractSyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.NonTerminalNode;
import net.sf.jclec.syntaxtree.SyntaxTree;
import net.sf.jclec.syntaxtree.SyntaxTreeIndividual;
import net.sf.jclec.syntaxtree.TerminalNode;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxTreeIndividualSpecies
extends AbstractSyntaxTreeSpecies<SyntaxTreeIndividual>
implements IConfigure {
    private static final long serialVersionUID = -5659464424179862147L;

    public void setNumberOfSyntaxTrees(int numberOfSyntaxTrees) {
        this.genotypeSchema = new AbstractSyntaxTreeSpecies.SyntaxTreeSchema[numberOfSyntaxTrees];
        int i = 0;
        while (i < numberOfSyntaxTrees) {
            this.genotypeSchema[i] = new AbstractSyntaxTreeSpecies.SyntaxTreeSchema();
            ++i;
        }
    }

    public void setMaxDerivSize(int treeIndex, int maxDerivSize) {
        this.genotypeSchema[treeIndex].setMaxDerivSize(maxDerivSize);
    }

    public void setRootSymbol(int treeIndex, String rootSymbol) {
        this.genotypeSchema[treeIndex].setRootSymbol(rootSymbol);
    }

    public void setTerminals(int treeIndex, TerminalNode[] terminals) {
        this.genotypeSchema[treeIndex].setTerminals(terminals);
    }

    public void setNonTerminals(int treeIndex, NonTerminalNode[] nonTerminals) {
        this.genotypeSchema[treeIndex].setNonTerminals(nonTerminals);
    }

    @Override
    public SyntaxTreeIndividual createIndividual() {
        return new SyntaxTreeIndividual();
    }

    public SyntaxTreeIndividual createIndividual(SyntaxTree[] genotype) {
        return new SyntaxTreeIndividual(genotype);
    }

    @Override
    public void configure(Configuration settings) {
        int numberOfSyntaxTrees = settings.getInt("[@number-of-syntax-trees]");
        this.setNumberOfSyntaxTrees(numberOfSyntaxTrees);
        int i = 0;
        while (i < numberOfSyntaxTrees) {
            String header = "syntax-tree(" + i + ")";
            int numberOfTermSymbols = settings.getList(String.valueOf(header) + ".terminal-symbols.symbol.name").size();
            TerminalNode[] terminals = new TerminalNode[numberOfTermSymbols];
            int j = 0;
            while (j < numberOfTermSymbols) {
                TerminalNode termSymbol = new TerminalNode();
                termSymbol.symbol = settings.getString(String.valueOf(header) + ".terminal-symbols.symbol(" + j + ")" + ".name");
                try {
                    String termSymbolCodeClassname = settings.getString(String.valueOf(header) + ".terminal-symbols.symbol(" + j + ")" + ".code");
                    Class<?> termSymbolCodeClass = Class.forName(termSymbolCodeClassname);
                    termSymbol.code = (IPrimitive)termSymbolCodeClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                terminals[j] = termSymbol;
                ++j;
            }
            this.setTerminals(i, terminals);
            int numberOfNonTermSymbols = settings.getList(String.valueOf(header) + ".non-terminal-symbols.symbol.name").size();
            NonTerminalNode[] nonTermSymbols = new NonTerminalNode[numberOfNonTermSymbols];
            int j2 = 0;
            while (j2 < numberOfNonTermSymbols) {
                NonTerminalNode nonTermSymbol = new NonTerminalNode();
                nonTermSymbol.symbol = settings.getString(String.valueOf(header) + ".non-terminal-symbols.symbol(" + j2 + ")" + ".name");
                nonTermSymbol.production = settings.getList(String.valueOf(header) + ".non-terminal-symbols.symbol(" + j2 + ")" + ".production-rule.element").toArray(new String[0]);
                nonTermSymbols[j2] = nonTermSymbol;
                ++j2;
            }
            this.setNonTerminals(i, nonTermSymbols);
            String rootSymbol = settings.getString(String.valueOf(header) + ".root-symbol");
            this.setRootSymbol(i, rootSymbol);
            int maxDerivSize = settings.getInt(String.valueOf(header) + ".max-deriv-size");
            this.setMaxDerivSize(i, maxDerivSize);
            ++i;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof SyntaxTreeIndividualSpecies) {
            SyntaxTreeIndividualSpecies cother = (SyntaxTreeIndividualSpecies)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.genotypeSchema, cother.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

