/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.DataException;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Files;

public abstract class FuzzyIBLAlgorithm {
    protected String[] outFile;
    protected String testFile;
    protected String trainFile;
    protected String referenceFile;
    protected InstanceSet train;
    protected InstanceSet test;
    protected InstanceSet reference;
    protected Instance temp;
    protected int inputAtt;
    protected int trainSize;
    protected Attribute[] inputs;
    protected Attribute output;
    protected boolean[] nulls;
    protected boolean[] nominal;
    protected double[][] trainData;
    protected int[] trainOutput;
    protected double[][] testData;
    protected int[] testOutput;
    protected double[][] referenceData;
    protected int[] referenceOutput;
    protected String relation;
    protected int nClasses;
    protected int[] nInstances;
    protected String name;
    protected long seed;
    protected int[] trainPrediction;
    protected int[] testPrediction;

    protected void readDataFiles(String script) {
        this.readConfiguracion(script);
        this.readParameters(script);
        try {
            this.train = new InstanceSet();
            this.train.readSet(this.trainFile, true);
            this.inputAtt = Attributes.getInputNumAttributes();
            this.trainSize = this.train.getNumInstances();
            this.inputs = Attributes.getInputAttributes();
            this.output = Attributes.getOutputAttribute(0);
            this.normalizeTrain();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            this.test = new InstanceSet();
            this.test.readSet(this.testFile, false);
            this.normalizeTest();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            this.reference = new InstanceSet();
            this.reference.readSet(this.referenceFile, false);
            this.normalizeReference();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        this.nClasses = Attributes.getOutputAttribute(0).getNumNominalValues();
        this.nInstances = new int[this.nClasses];
        Arrays.fill(this.nInstances, 0);
        for (int i = 0; i < this.trainOutput.length; ++i) {
            int n = this.trainOutput[i];
            this.nInstances[n] = this.nInstances[n] + 1;
        }
        this.trainPrediction = new int[this.trainSize];
        this.testPrediction = new int[this.test.getNumInstances()];
        Arrays.fill(this.trainPrediction, -1);
        Arrays.fill(this.testPrediction, -1);
    }

    protected void readConfiguracion(String script) {
        this.outFile = new String[3];
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        String cad = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(cad, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.trainFile = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.referenceFile = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.testFile = new String(line, i, j - i);
        cad = fileLines.nextToken();
        tokens = new StringTokenizer(cad, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[1] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[2] = new String(line, i, j - i);
    }

    protected abstract void readParameters(String var1);

    protected void normalizeTrain() throws DataException {
        int j;
        int i;
        if (Attributes.getOutputNumAttributes() < 1) {
            throw new DataException("This dataset haven\u00b4t outputs, so it not corresponding to a classification problem.");
        }
        if (Attributes.getOutputNumAttributes() > 1) {
            throw new DataException("This dataset have more of one output.");
        }
        if (Attributes.getOutputAttribute(0).getType() == 2) {
            throw new DataException("This dataset have an input attribute with float values, so it not corresponding to a classification problem.");
        }
        StringTokenizer tokens = new StringTokenizer(this.train.getHeader(), " \n\r");
        tokens.nextToken();
        this.relation = tokens.nextToken();
        this.trainData = new double[this.train.getNumInstances()][this.inputAtt];
        this.trainOutput = new int[this.train.getNumInstances()];
        for (i = 0; i < this.train.getNumInstances(); ++i) {
            this.temp = this.train.getInstance(i);
            this.trainData[i] = this.temp.getAllInputValues();
            this.trainOutput[i] = (int)this.temp.getOutputRealValues(0);
            this.nulls = this.temp.getInputMissingValues();
            for (j = 0; j < this.nulls.length; ++j) {
                if (!this.nulls[j]) continue;
                this.trainData[i][j] = 0.0;
            }
        }
        double[] minimum = new double[this.inputAtt];
        double[] range = new double[this.inputAtt];
        for (i = 0; i < this.inputAtt; ++i) {
            if (Attributes.getInputAttribute(i).getType() == 0) continue;
            minimum[i] = Attributes.getInputAttribute(i).getMinAttribute();
            range[i] = Attributes.getInputAttribute(i).getMaxAttribute() - minimum[i];
        }
        for (i = 0; i < this.train.getNumInstances(); ++i) {
            for (j = 0; j < this.inputAtt; ++j) {
                if (Attributes.getInputAttribute(j).getType() == 0) {
                    if (Attributes.getInputAttribute(j).getNominalValuesList().size() <= 1) continue;
                    double[] dArray = this.trainData[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)(Attributes.getInputAttribute(j).getNominalValuesList().size() - 1);
                    continue;
                }
                double[] dArray = this.trainData[i];
                int n = j;
                dArray[n] = dArray[n] - minimum[j];
                double[] dArray2 = this.trainData[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] / range[j];
            }
        }
    }

    protected void normalizeTest() throws DataException {
        int j;
        int i;
        if (Attributes.getOutputNumAttributes() < 1) {
            throw new DataException("This dataset haven\u00b4t outputs, so it not corresponding to a classification problem.");
        }
        if (Attributes.getOutputNumAttributes() > 1) {
            throw new DataException("This dataset have more of one output.");
        }
        if (Attributes.getOutputAttribute(0).getType() == 2) {
            throw new DataException("This dataset have an input attribute with float values, so it not corresponding to a classification \tproblem.");
        }
        StringTokenizer tokens = new StringTokenizer(this.test.getHeader(), " \n\r");
        tokens.nextToken();
        tokens.nextToken();
        this.testData = new double[this.test.getNumInstances()][this.inputAtt];
        this.testOutput = new int[this.test.getNumInstances()];
        for (i = 0; i < this.test.getNumInstances(); ++i) {
            this.temp = this.test.getInstance(i);
            this.testData[i] = this.temp.getAllInputValues();
            this.testOutput[i] = (int)this.temp.getOutputRealValues(0);
            this.nulls = this.temp.getInputMissingValues();
            for (j = 0; j < this.nulls.length; ++j) {
                if (!this.nulls[j]) continue;
                this.testData[i][j] = 0.0;
            }
        }
        double[] minimum = new double[this.inputAtt];
        double[] range = new double[this.inputAtt];
        for (i = 0; i < this.inputAtt; ++i) {
            if (Attributes.getInputAttribute(i).getType() == 0) continue;
            minimum[i] = Attributes.getInputAttribute(i).getMinAttribute();
            range[i] = Attributes.getInputAttribute(i).getMaxAttribute() - minimum[i];
        }
        for (i = 0; i < this.test.getNumInstances(); ++i) {
            for (j = 0; j < this.inputAtt; ++j) {
                if (Attributes.getInputAttribute(j).getType() == 0) {
                    if (Attributes.getInputAttribute(j).getNominalValuesList().size() <= 1) continue;
                    double[] dArray = this.testData[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)(Attributes.getInputAttribute(j).getNominalValuesList().size() - 1);
                    continue;
                }
                double[] dArray = this.testData[i];
                int n = j;
                dArray[n] = dArray[n] - minimum[j];
                double[] dArray2 = this.testData[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] / range[j];
            }
        }
    }

    protected void normalizeReference() throws DataException {
        int j;
        int i;
        if (Attributes.getOutputNumAttributes() < 1) {
            throw new DataException("This dataset haven\u00b4t outputs, so it not corresponding to a classification problem.");
        }
        if (Attributes.getOutputNumAttributes() > 1) {
            throw new DataException("This dataset have more of one output.");
        }
        if (Attributes.getOutputAttribute(0).getType() == 2) {
            throw new DataException("This dataset have an input attribute with float values, so it not corresponding to a classification problem.");
        }
        StringTokenizer tokens = new StringTokenizer(this.reference.getHeader(), " \n\r");
        tokens.nextToken();
        tokens.nextToken();
        this.referenceData = new double[this.reference.getNumInstances()][this.inputAtt];
        this.referenceOutput = new int[this.reference.getNumInstances()];
        for (i = 0; i < this.reference.getNumInstances(); ++i) {
            this.temp = this.reference.getInstance(i);
            this.referenceData[i] = this.temp.getAllInputValues();
            this.referenceOutput[i] = (int)this.temp.getOutputRealValues(0);
            this.nulls = this.temp.getInputMissingValues();
            for (j = 0; j < this.nulls.length; ++j) {
                if (!this.nulls[j]) continue;
                this.referenceData[i][j] = 0.0;
            }
        }
        double[] minimum = new double[this.inputAtt];
        double[] range = new double[this.inputAtt];
        for (i = 0; i < this.inputAtt; ++i) {
            if (Attributes.getInputAttribute(i).getType() == 0) continue;
            minimum[i] = Attributes.getInputAttribute(i).getMinAttribute();
            range[i] = Attributes.getInputAttribute(i).getMaxAttribute() - minimum[i];
        }
        for (i = 0; i < this.reference.getNumInstances(); ++i) {
            for (j = 0; j < this.inputAtt; ++j) {
                if (Attributes.getInputAttribute(j).getType() == 0) {
                    if (Attributes.getInputAttribute(j).getNominalValuesList().size() <= 1) continue;
                    double[] dArray = this.referenceData[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)(Attributes.getInputAttribute(j).getNominalValuesList().size() - 1);
                    continue;
                }
                double[] dArray = this.referenceData[i];
                int n = j;
                dArray[n] = dArray[n] - minimum[j];
                double[] dArray2 = this.referenceData[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] / range[j];
            }
        }
    }

    protected void writeOutput(String filename, int[] realClass, int[] prediction) {
        int i;
        String text = "";
        text = text + "@relation " + this.relation + "\n";
        for (i = 0; i < this.inputs.length; ++i) {
            text = text + "@attribute " + this.inputs[i].getName() + " ";
            if (this.inputs[i].getType() == 0) {
                text = text + "{";
                for (int j = 0; j < this.inputs[i].getNominalValuesList().size(); ++j) {
                    text = text + (String)this.inputs[i].getNominalValuesList().elementAt(j);
                    if (j >= this.inputs[i].getNominalValuesList().size() - 1) continue;
                    text = text + ", ";
                }
                text = text + "}\n";
                continue;
            }
            text = this.inputs[i].getType() == 1 ? text + "integer" : text + "real";
            text = text + " [" + String.valueOf(this.inputs[i].getMinAttribute()) + ", " + String.valueOf(this.inputs[i].getMaxAttribute()) + "]\n";
        }
        text = text + "@attribute " + this.output.getName() + " ";
        if (this.output.getType() == 0) {
            text = text + "{";
            for (int j = 0; j < this.output.getNominalValuesList().size(); ++j) {
                text = text + (String)this.output.getNominalValuesList().elementAt(j);
                if (j >= this.output.getNominalValuesList().size() - 1) continue;
                text = text + ", ";
            }
            text = text + "}\n";
        } else {
            text = text + "integer [" + String.valueOf(this.output.getMinAttribute()) + ", " + String.valueOf(this.output.getMaxAttribute()) + "]\n";
        }
        text = text + "@data\n";
        Files.writeFile(filename, text);
        if (this.output.getType() == 1) {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                text = text + "" + realClass[i] + " ";
                text = text + "" + prediction[i] + " ";
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        } else {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                text = text + "" + (String)this.output.getNominalValuesList().elementAt(realClass[i]) + " ";
                text = prediction[i] > -1 ? text + "" + (String)this.output.getNominalValuesList().elementAt(prediction[i]) + " " : text + "Unclassified ";
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        }
    }
}

